/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus;

import dev.aurelium.auraskills.api.registry.NamespacedRegistry;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.NexoHook;
import dev.aurelium.auraskills.bukkit.menus.MenuFileUpdates;
import dev.aurelium.auraskills.bukkit.menus.shared.SkillItem;
import dev.aurelium.auraskills.common.api.ApiAuraSkills;
import dev.aurelium.auraskills.common.util.file.FileUtil;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MenuFileManager {
    private final AuraSkills plugin;
    public static final String[] MENU_NAMES = new String[]{"abilities", "leaderboard", "level_progression", "skills", "sources", "stats", "stat_info"};

    public MenuFileManager(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void generateDefaultFiles() {
        for (String menuName : MENU_NAMES) {
            File file = new File(String.valueOf(this.plugin.getDataFolder()) + "/menus", menuName + ".yml");
            if (file.exists()) continue;
            this.plugin.saveResource("menus/" + menuName + ".yml", false);
        }
    }

    public void loadMenus() {
        ApiAuraSkills api = (ApiAuraSkills)this.plugin.getApi();
        for (NamespacedRegistry registry : api.getNamespacedRegistryMap().values()) {
            registry.getMenuDirectory().ifPresent(dir -> this.plugin.getSlate().addMergeDirectory((File)dir));
        }
        int menusLoaded = this.plugin.getSlate().loadMenus();
        SkillItem.loadFormats(this.plugin);
        this.plugin.getLogger().info("Loaded " + menusLoaded + " menus");
    }

    public void loadMenusOnStartup() {
        if (this.plugin.getHookManager().isRegistered(NexoHook.class)) {
            this.plugin.getScheduler().scheduleSync(() -> {
                NexoHook hook = this.plugin.getHookManager().getHook(NexoHook.class);
                if (!hook.getItemsLoadedCallbacks().isEmpty()) {
                    this.loadMenus();
                }
            }, 250L, TimeUnit.MILLISECONDS);
        } else {
            this.loadMenus();
        }
    }

    public void updateMenus() {
        for (String menuName : MENU_NAMES) {
            File userFile = new File(String.valueOf(this.plugin.getDataFolder()) + "/menus", menuName + ".yml");
            if (!userFile.exists()) continue;
            try {
                ConfigurationNode embeddedConfig = FileUtil.loadEmbeddedYamlFile("menus/" + menuName + ".yml", this.plugin);
                ConfigurationNode userConfig = FileUtil.loadYamlFile(userFile);
                this.updateAndSave(menuName, embeddedConfig, userConfig, userFile);
            }
            catch (IOException e) {
                this.plugin.logger().warn("Error updating menu file " + userFile.getName());
                e.printStackTrace();
            }
        }
    }

    private void updateAndSave(String menuName, ConfigurationNode embedded, ConfigurationNode user, File userFile) throws SerializationException {
        if (embedded.node("file_version").virtual()) {
            return;
        }
        int embVersion = embedded.node("file_version").getInt();
        int userVersion = user.node("file_version").getInt(0);
        if (userVersion >= embVersion) {
            return;
        }
        List<MenuFileUpdates> updates = MenuFileUpdates.getUpdates(menuName, userVersion, embVersion);
        if (updates.isEmpty()) {
            return;
        }
        int changed = 0;
        for (MenuFileUpdates update : updates) {
            List addedItems = update.getAddedKeys().getOrDefault("items", new ArrayList());
            changed += this.updateConfigSection("items", embedded, user, addedItems);
            List addedTemplates = update.getAddedKeys().getOrDefault("templates", new ArrayList());
            changed += this.updateConfigSection("templates", embedded, user, addedTemplates);
            List addedComponents = update.getAddedKeys().getOrDefault("components", new ArrayList());
            changed += this.updateConfigSection("components", embedded, user, addedComponents);
            List addedFormats = update.getAddedKeys().getOrDefault("formats", new ArrayList());
            changed += this.updateStringSection("formats", embedded, user, addedFormats);
        }
        user.node("file_version").set(embVersion);
        try {
            FileUtil.saveYamlFile(userFile, user);
            this.plugin.logger().info("Menu file " + userFile.getName() + " was updated: " + changed + " new sections added");
        }
        catch (IOException e) {
            this.plugin.logger().warn("Error saving menu file " + userFile.getName());
            e.printStackTrace();
        }
    }

    private int updateConfigSection(String name, ConfigurationNode embedded, ConfigurationNode user, List<String> keys) throws SerializationException {
        if (keys.isEmpty()) {
            return 0;
        }
        int changed = 0;
        if (!embedded.node(name).virtual() && !user.node(name).virtual()) {
            for (ConfigurationNode configurationNode : embedded.node(name).childrenMap().values()) {
                String key = (String)configurationNode.key();
                if (key == null || !keys.contains(key) || !configurationNode.isMap() || !user.node(name).node(key).virtual()) continue;
                user.node(name).node(key).set(configurationNode);
                ++changed;
            }
        }
        return changed;
    }

    private int updateStringSection(String name, ConfigurationNode embedded, ConfigurationNode user, List<String> keys) throws SerializationException {
        if (keys.isEmpty()) {
            return 0;
        }
        int changed = 0;
        if (!embedded.node(name).virtual() && !user.node(name).virtual()) {
            for (ConfigurationNode configurationNode : embedded.node(name).childrenMap().values()) {
                String value;
                String key = (String)configurationNode.key();
                if (key == null || !keys.contains(key) || (value = configurationNode.getString()) == null || !user.node(name).node(key).virtual()) continue;
                user.node(name).node(key).set(value);
                ++changed;
            }
        }
        return changed;
    }
}

