/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.handler;

import dev.aurelium.auraskills.api.event.loot.LootDropEvent;
import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootContext;
import dev.aurelium.auraskills.api.loot.LootDropCause;
import dev.aurelium.auraskills.api.loot.LootPool;
import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.LevelerContext;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.WorldGuardFlags;
import dev.aurelium.auraskills.bukkit.hooks.WorldGuardHook;
import dev.aurelium.auraskills.bukkit.loot.context.MobContext;
import dev.aurelium.auraskills.bukkit.loot.item.BukkitItemSupplier;
import dev.aurelium.auraskills.bukkit.loot.type.EntityLoot;
import dev.aurelium.auraskills.bukkit.loot.type.ItemLoot;
import dev.aurelium.auraskills.bukkit.ref.BukkitItemRef;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.common.commands.CommandExecutor;
import dev.aurelium.auraskills.common.hooks.PlaceholderHook;
import dev.aurelium.auraskills.common.loot.AbstractLootHandler;
import dev.aurelium.auraskills.common.loot.CommandLoot;
import dev.aurelium.auraskills.common.loot.SourceContext;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.slate.text.TextFormatter;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LootHandler
extends AbstractLootHandler {
    protected final AuraSkills plugin;
    private final TextFormatter tf = new TextFormatter();
    private final LevelerContext levelerContext;

    public LootHandler(AuraSkills plugin) {
        this.plugin = plugin;
        this.levelerContext = new LevelerContext(plugin.getApi());
    }

    protected void giveCommandLoot(Player player, CommandLoot loot, @Nullable XpSource source, Skill skill) {
        User user = this.plugin.getUser(player);
        for (String command : loot.getCommands()) {
            CommandExecutor executor;
            String finalCommand = TextUtil.replace(command, "{player}", player.getName());
            if (this.plugin.getHookManager().isRegistered(PlaceholderHook.class)) {
                finalCommand = this.plugin.getHookManager().getHook(PlaceholderHook.class).setPlaceholders(user, finalCommand);
            }
            if ((executor = loot.getExecutor()) == CommandExecutor.CONSOLE) {
                Bukkit.dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), (String)finalCommand);
                continue;
            }
            if (executor != CommandExecutor.PLAYER) continue;
            Bukkit.dispatchCommand((CommandSender)player, (String)finalCommand);
        }
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, source, skill);
    }

    protected void giveFishingCommandLoot(Player player, CommandLoot loot, PlayerFishEvent event, @Nullable XpSource source, Skill skill) {
        Entity entity = event.getCaught();
        if (!(entity instanceof Item)) {
            return;
        }
        Item itemEntity = (Item)entity;
        itemEntity.setItemStack(new ItemStack(Material.AIR));
        this.giveCommandLoot(player, loot, source, skill);
    }

    protected void giveBlockItemLoot(Player player, ItemLoot loot, BlockBreakEvent breakEvent, Skill skill, LootDropCause cause, LootTable table) {
        Block block = breakEvent.getBlock();
        BukkitItemSupplier bukkitItemSupplier = new BukkitItemSupplier(loot.getItem());
        ItemStack drop = this.generateDamaged(BukkitItemRef.unwrap(bukkitItemSupplier.supplyItem(this.plugin, table)), loot.getMinDamage(), loot.getMaxDamage());
        if (drop == null) {
            return;
        }
        drop.setAmount(this.generateAmount(loot.getMinAmount(), loot.getMaxAmount()));
        Location location = block.getLocation().add(0.5, 0.5, 0.5);
        this.giveDropItemLoot(player, location, cause, drop);
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, null, skill);
    }

    protected void giveMobItemLoot(Player player, ItemLoot loot, Location location, Skill skill, LootDropCause cause, LootTable table) {
        BukkitItemSupplier bukkitItemSupplier = new BukkitItemSupplier(loot.getItem());
        ItemStack drop = this.generateDamaged(BukkitItemRef.unwrap(bukkitItemSupplier.supplyItem(this.plugin, table)), loot.getMinDamage(), loot.getMaxDamage());
        if (drop == null) {
            return;
        }
        drop.setAmount(this.generateAmount(loot.getMinAmount(), loot.getMaxAmount()));
        this.giveDropItemLoot(player, location, cause, drop);
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, null, skill);
    }

    private void giveDropItemLoot(Player player, Location location, LootDropCause cause, ItemStack drop) {
        boolean toInventory = this.plugin.getLootManager().toInventory(player.getInventory().getItemInMainHand());
        LootDropEvent dropEvent = new LootDropEvent(player, this.plugin.getUser(player).toApi(), drop, location, (LootDropEvent.Cause)cause, toInventory);
        Bukkit.getPluginManager().callEvent((Event)dropEvent);
        if (dropEvent.isCancelled()) {
            return;
        }
        ItemUtils.giveBlockLoot(player, dropEvent);
    }

    protected void giveFishingItemLoot(Player player, ItemLoot loot, PlayerFishEvent event, @Nullable XpSource source, Skill skill, LootDropCause cause, LootTable table) {
        Entity entity = event.getCaught();
        if (!(entity instanceof Item)) {
            return;
        }
        Item itemEntity = (Item)entity;
        int amount = this.generateAmount(loot.getMinAmount(), loot.getMaxAmount());
        if (amount == 0) {
            return;
        }
        BukkitItemSupplier bukkitItemSupplier = new BukkitItemSupplier(loot.getItem());
        ItemStack drop = this.generateDamaged(BukkitItemRef.unwrap(bukkitItemSupplier.supplyItem(this.plugin, table)), loot.getMinDamage(), loot.getMaxDamage());
        if (drop == null) {
            return;
        }
        drop.setAmount(amount);
        LootDropEvent dropEvent = new LootDropEvent(player, this.plugin.getUser(player).toApi(), drop, event.getHook().getLocation(), (LootDropEvent.Cause)cause, false);
        Bukkit.getPluginManager().callEvent((Event)dropEvent);
        if (dropEvent.isCancelled()) {
            return;
        }
        itemEntity.setItemStack(dropEvent.getItem());
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, source, skill);
    }

    protected void giveFishingEntityLoot(Player player, EntityLoot loot, PlayerFishEvent event, @Nullable XpSource source, Skill skill, LootDropEvent.Cause cause) {
        Float vVelocity;
        Entity entity = event.getCaught();
        if (!(entity instanceof Item)) {
            return;
        }
        Item itemEntity = (Item)entity;
        Location location = event.getHook().getLocation();
        Entity entity2 = loot.getEntity().spawnEntity(this.plugin, event.getHook().getLocation());
        if (entity2 == null) {
            return;
        }
        LootDropEvent dropEvent = new LootDropEvent(player, this.plugin.getUser(player).toApi(), entity2, event.getHook().getLocation(), cause);
        Bukkit.getPluginManager().callEvent((Event)dropEvent);
        if (dropEvent.isCancelled()) {
            loot.getEntity().removeEntity(entity2);
            return;
        }
        itemEntity.setItemStack(new ItemStack(Material.AIR));
        Float hVelocity = loot.getEntity().getEntityProperties().horizontalVelocity();
        if (hVelocity == null) {
            hVelocity = Float.valueOf(1.2f);
        }
        if ((vVelocity = loot.getEntity().getEntityProperties().verticalVelocity()) == null) {
            vVelocity = Float.valueOf(1.3f);
        }
        Vector vector = player.getLocation().subtract(location).toVector().multiply(hVelocity.floatValue() - 1.0f);
        vector.setY((vector.getY() + 0.2) * (double)vVelocity.floatValue());
        entity2.setVelocity(vector);
        this.attemptSendMessage(player, loot);
        this.giveXp(player, loot, source, skill);
    }

    @Nullable
    protected Loot selectLoot(LootPool pool, @NotNull LootContext providedContext, User user) {
        UUID uuid = user.getUuid();
        return pool.rollLoot(loot -> {
            Iterator<LootContext> iterator;
            boolean matched;
            EntityType providedType;
            if (!loot.checkRequirements(uuid)) {
                return false;
            }
            if (providedContext instanceof SourceContext) {
                Iterator<LootContext> iterator2;
                boolean matched2;
                XpSource providedSource;
                SourceContext $b$0 = (SourceContext)providedContext;
                try {
                    XpSource patt1$temp;
                    providedSource = patt1$temp = $b$0.source();
                    Set<LootContext> lootContexts = loot.getValues().getContexts().get("sources");
                    if (lootContexts == null) return true;
                    if (providedSource == null) return true;
                    matched2 = false;
                    iterator2 = lootContexts.iterator();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (iterator2.hasNext()) {
                    LootContext context = iterator2.next();
                    if (!(context instanceof SourceContext)) continue;
                    SourceContext $b$2 = (SourceContext)context;
                    {
                        // empty try
                    }
                    XpSource patt3$temp = $b$2.source();
                    XpSource configuredSource = patt3$temp;
                    if (configuredSource.equals(providedSource)) return true;
                }
                return matched2;
            }
            if (!(providedContext instanceof MobContext)) return true;
            MobContext $b$2 = (MobContext)providedContext;
            {
                EntityType patt3$temp;
                providedType = patt3$temp = $b$2.entityType();
                Set<LootContext> lootContexts = loot.getValues().getContexts().get("mobs");
                if (lootContexts == null) return true;
                if (providedType == null) return true;
                matched = false;
                iterator = lootContexts.iterator();
            }
            while (iterator.hasNext()) {
                LootContext context = iterator.next();
                if (!(context instanceof MobContext)) continue;
                MobContext $b$4 = (MobContext)context;
                {
                    // empty try
                }
                EntityType patt5$temp = $b$4.entityType();
                EntityType configuredType = patt5$temp;
                if (!configuredType.equals((Object)providedType)) continue;
                matched = true;
            }
            return matched;
        }).orElse(null);
    }

    private void giveXp(Player player, Loot loot, @Nullable XpSource source, Skill skill) {
        if (this.levelerContext.failsChecks(player, player.getLocation(), skill)) {
            return;
        }
        User user = this.plugin.getUser(player);
        Object xpObj = loot.getValues().getOptions().get("xp");
        double xp = xpObj instanceof Integer ? (double)((Integer)xpObj).intValue() : (xpObj instanceof Double ? (Double)xpObj : -1.0);
        if (xp == -1.0 && source != null) {
            this.plugin.getLevelManager().addXp(user, skill, source, source.getXp());
        } else if (xp > 0.0) {
            this.plugin.getLevelManager().addXp(user, skill, source, xp);
        }
    }

    private ItemStack generateDamaged(@Nullable ItemStack drop, double minDamage, double maxDamage) {
        if (minDamage == 0.0 && maxDamage == 0.0) {
            return drop;
        }
        if (minDamage >= 0.0 && minDamage <= 1.0 && maxDamage >= 0.0 && maxDamage <= 1.0 && minDamage <= maxDamage) {
            if (drop == null) {
                return null;
            }
            ItemMeta meta = drop.getItemMeta();
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                short durability = drop.getType().getMaxDurability();
                int minDamageValue = (int)((double)durability * minDamage);
                int maxDamageValue = (int)((double)durability * maxDamage);
                int damage = minDamage == maxDamage ? maxDamageValue : ThreadLocalRandom.current().nextInt(minDamageValue, maxDamageValue);
                damageable.setDamage(damage);
                drop.setItemMeta(meta);
            }
        }
        return drop;
    }

    private void attemptSendMessage(Player player, Loot loot) {
        String message = loot.getValues().getMessage();
        if (message == null || message.isEmpty()) {
            return;
        }
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        MessageKey messageKey = MessageKey.of(message);
        String keyedMessage = this.plugin.getMessageProvider().getOrNull(messageKey, locale);
        if (keyedMessage != null) {
            message = keyedMessage;
        }
        if (this.plugin.getHookManager().isRegistered(PlaceholderHook.class)) {
            message = this.plugin.getHookManager().getHook(PlaceholderHook.class).setPlaceholders(user, message);
        }
        user.sendMessage(this.tf.toComponent(message));
    }

    protected boolean failsChecks(Player player, Location location, boolean disableInCreative) {
        if (disableInCreative && player.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        if (this.plugin.getWorldManager().isInDisabledWorld(location)) {
            return true;
        }
        if (this.plugin.getHookManager().isRegistered(WorldGuardHook.class)) {
            return this.plugin.getHookManager().getHook(WorldGuardHook.class).isBlocked(location, player, WorldGuardFlags.FlagKey.CUSTOM_LOOT);
        }
        return false;
    }
}

