/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ref.BukkitItemRef;
import dev.aurelium.auraskills.common.loot.CustomItemParser;
import dev.aurelium.auraskills.common.loot.ItemSupplier;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import org.bukkit.inventory.ItemStack;

public class ItemKeyParser
implements CustomItemParser {
    private final AuraSkills plugin;

    public ItemKeyParser(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean shouldUseParser(ConfigurationNode config) {
        return !config.node("key").virtual();
    }

    @Override
    public ItemSupplier parseCustomItem(ConfigurationNode config) {
        NamespacedId itemKey = NamespacedId.fromDefaultWithColon(config.node("key").getString(""));
        ItemStack item = this.plugin.getItemRegistry().getItem(itemKey);
        if (item != null) {
            return new ItemSupplier(BukkitItemRef.wrap(item), null, null);
        }
        return new ItemSupplier(null, itemKey, null);
    }
}

