/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.level;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.event.skill.DamageXpGainEvent;
import dev.aurelium.auraskills.api.event.skill.EntityXpGainEvent;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.source.type.DamageXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.level.XpRequirementsLoader;
import dev.aurelium.auraskills.bukkit.source.AnvilLeveler;
import dev.aurelium.auraskills.bukkit.source.BlockLeveler;
import dev.aurelium.auraskills.bukkit.source.BrewingLeveler;
import dev.aurelium.auraskills.bukkit.source.DamageLeveler;
import dev.aurelium.auraskills.bukkit.source.EnchantingLeveler;
import dev.aurelium.auraskills.bukkit.source.EntityLeveler;
import dev.aurelium.auraskills.bukkit.source.FishingLeveler;
import dev.aurelium.auraskills.bukkit.source.GrindstoneLeveler;
import dev.aurelium.auraskills.bukkit.source.ItemConsumeLeveler;
import dev.aurelium.auraskills.bukkit.source.JumpingLeveler;
import dev.aurelium.auraskills.bukkit.source.ManaAbilityUseLeveler;
import dev.aurelium.auraskills.bukkit.source.PotionSplashLeveler;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.bukkit.source.StatisticLeveler;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.bukkit.util.SoundUtil;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.level.LevelManager;
import dev.aurelium.auraskills.common.user.User;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BukkitLevelManager
extends LevelManager {
    private final AuraSkills plugin;
    private final Set<SourceLeveler> levelers;

    public BukkitLevelManager(AuraSkills plugin) {
        super(plugin);
        this.plugin = plugin;
        this.levelers = Sets.newConcurrentHashSet();
    }

    public void loadXpRequirements() {
        XpRequirementsLoader loader = new XpRequirementsLoader(this.plugin, this.xpRequirements);
        loader.load();
    }

    public void registerLevelers() {
        this.levelers.clear();
        this.registerLeveler(new AnvilLeveler(this.plugin));
        this.registerLeveler(new BlockLeveler(this.plugin));
        this.registerLeveler(new BrewingLeveler(this.plugin));
        this.registerLeveler(new DamageLeveler(this.plugin));
        this.registerLeveler(new EnchantingLeveler(this.plugin));
        this.registerLeveler(new EntityLeveler(this.plugin));
        this.registerLeveler(new FishingLeveler(this.plugin));
        this.registerLeveler(new GrindstoneLeveler(this.plugin));
        this.registerLeveler(new ItemConsumeLeveler(this.plugin));
        this.registerLeveler(new JumpingLeveler(this.plugin));
        this.registerLeveler(new ManaAbilityUseLeveler(this.plugin));
        this.registerLeveler(new PotionSplashLeveler(this.plugin));
        this.registerLeveler(new StatisticLeveler(this.plugin));
    }

    private void registerLeveler(SourceLeveler leveler) {
        this.levelers.add(leveler);
        Bukkit.getPluginManager().registerEvents((Listener)leveler, (Plugin)this.plugin);
    }

    public <T extends SourceLeveler> T getLeveler(Class<T> levelerClass) {
        for (SourceLeveler leveler : this.levelers) {
            if (!levelerClass.isInstance(leveler)) continue;
            return (T)leveler;
        }
        throw new IllegalArgumentException("Leveler " + levelerClass.getSimpleName() + " is not registered!");
    }

    public void addEntityXp(User user, Skill skill, @NotNull XpSource source, double amount, LivingEntity attacked, Entity damager, EntityEvent originalEvent) {
        if (amount == 0.0) {
            return;
        }
        double amountToAdd = amount * this.calculateMultiplier(user, skill);
        EntityXpGainEvent event = new EntityXpGainEvent(BukkitUser.getPlayer(user.toApi()), user.toApi(), skill, source, amountToAdd, attacked, damager, originalEvent);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.addXpRaw(user, skill, event.getAmount(), source);
    }

    public void addDamageXp(User user, Skill skill, @NotNull XpSource source, double amount, DamageXpSource.DamageCause cause, Entity damager, EntityEvent originalEvent) {
        if (amount == 0.0) {
            return;
        }
        double amountToAdd = amount * this.calculateMultiplier(user, skill);
        DamageXpGainEvent event = new DamageXpGainEvent(BukkitUser.getPlayer(user.toApi()), user.toApi(), skill, source, amountToAdd, cause, damager, originalEvent);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.addXpRaw(user, skill, event.getAmount(), source);
    }

    @Override
    public void playLevelUpSound(@NotNull User user) {
        Player player = ((BukkitUser)user).getPlayer();
        if (player == null) {
            return;
        }
        String soundName = this.plugin.configString(Option.LEVELER_SOUND_TYPE);
        try {
            player.playSound(player.getLocation(), SoundUtil.getFromEitherName(soundName), SoundCategory.valueOf((String)this.plugin.configString(Option.LEVELER_SOUND_CATEGORY)), (float)this.plugin.configDouble(Option.LEVELER_SOUND_VOLUME), (float)this.plugin.configDouble(Option.LEVELER_SOUND_PITCH));
        }
        catch (Exception e) {
            this.plugin.logger().warn("Error playing level up sound: " + soundName + ", played the default sound instead");
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, SoundCategory.MASTER, 1.0f, 0.5f);
        }
    }
}

