/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.item;

import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class UserEquipment {
    @NotNull
    private ItemStack mainHand;
    @NotNull
    private ItemStack offHand;
    @NotNull
    private ItemStack head;
    @NotNull
    private ItemStack chest;
    @NotNull
    private ItemStack legs;
    @NotNull
    private ItemStack feet;

    private UserEquipment(@NotNull ItemStack mainHand, @NotNull ItemStack offHand, @NotNull ItemStack head, @NotNull ItemStack chest, @NotNull ItemStack legs, @NotNull ItemStack feet) {
        this.mainHand = mainHand;
        this.offHand = offHand;
        this.head = head;
        this.chest = chest;
        this.legs = legs;
        this.feet = feet;
    }

    public static UserEquipment empty() {
        return new UserEquipment(new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR));
    }

    @NotNull
    public ItemStack getSlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HAND -> this.mainHand;
            case EquipmentSlot.OFF_HAND -> this.offHand;
            case EquipmentSlot.HEAD -> this.head;
            case EquipmentSlot.CHEST -> this.chest;
            case EquipmentSlot.LEGS -> this.legs;
            case EquipmentSlot.FEET -> this.feet;
            default -> new ItemStack(Material.AIR);
        };
    }

    public void setSlot(EquipmentSlot slot, @NotNull ItemStack item) {
        this.validate(item);
        switch (slot) {
            case HAND: {
                this.mainHand = item;
                break;
            }
            case OFF_HAND: {
                this.offHand = item;
                break;
            }
            case HEAD: {
                this.head = item;
                break;
            }
            case CHEST: {
                this.chest = item;
                break;
            }
            case LEGS: {
                this.legs = item;
                break;
            }
            case FEET: {
                this.feet = item;
            }
        }
    }

    private void validate(ItemStack item) {
        if (item == null) {
            throw new IllegalArgumentException("Cannot set a UserEquipment ItemStack to null!");
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UserEquipment that = (UserEquipment)obj;
        return Objects.equals(this.mainHand, that.mainHand) && Objects.equals(this.offHand, that.offHand) && Objects.equals(this.head, that.head) && Objects.equals(this.chest, that.chest) && Objects.equals(this.legs, that.legs) && Objects.equals(this.feet, that.feet);
    }

    public int hashCode() {
        return Objects.hash(this.mainHand, this.offHand, this.head, this.chest, this.legs, this.feet);
    }

    public String toString() {
        return "UserEquipment[mainHand=" + String.valueOf(this.mainHand) + ", offHand=" + String.valueOf(this.offHand) + ", head=" + String.valueOf(this.head) + ", chest=" + String.valueOf(this.chest) + ", legs=" + String.valueOf(this.legs) + ", feet=" + String.valueOf(this.feet) + "]";
    }
}

