/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.item;

import dev.aurelium.auraskills.api.bukkit.BukkitTraitHandler;
import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.registry.NamespaceIdentified;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Multiplier;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.ReloadableIdentifier;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.Modifiers;
import dev.aurelium.auraskills.bukkit.item.Multipliers;
import dev.aurelium.auraskills.bukkit.requirement.GlobalRequirement;
import dev.aurelium.auraskills.bukkit.requirement.Requirements;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.nbtapi.iface.ReadWriteNBT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class SkillsItem {
    private final AuraSkills plugin;
    private final ItemStack item;
    private final ItemMeta meta;

    public SkillsItem(ItemStack item, AuraSkills plugin) {
        this.item = item.clone();
        this.meta = this.item.getItemMeta();
        this.plugin = plugin;
    }

    public ItemStack getItem() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }

    public List<StatModifier> getStatModifiers(ModifierType type) {
        return this.getStatModifiers(type, false);
    }

    public List<StatModifier> getStatModifiers(ModifierType type, boolean offhand) {
        ArrayList<StatModifier> modifiers = new ArrayList<StatModifier>();
        if (this.isContainerList(MetaType.MODIFIER, type)) {
            List<PersistentDataContainer> containers = this.getContainerList(MetaType.MODIFIER, type);
            for (PersistentDataContainer container : containers) {
                Stat stat;
                String statName;
                double value = (Double)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "value"), PersistentDataType.DOUBLE, (Object)0.0);
                if (value == 0.0 || (statName = (String)container.get(new NamespacedKey((Plugin)this.plugin, "stat"), PersistentDataType.STRING)) == null || (stat = (Stat)this.plugin.getStatRegistry().getOrNull(NamespacedId.fromDefault(statName))) == null) continue;
                String operationName = (String)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "operation"), PersistentDataType.STRING, (Object)AuraSkillsModifier.Operation.ADD.toString());
                AuraSkillsModifier.Operation operation = AuraSkillsModifier.Operation.parse(operationName);
                String modifierName = this.getModifierName(stat, type, offhand);
                StatModifier modifier = new StatModifier(modifierName, stat, value, operation);
                modifier.setNonPersistent();
                modifiers.add(modifier);
            }
        } else {
            PersistentDataContainer container = this.getContainer(MetaType.MODIFIER, type);
            for (NamespacedKey key : container.getKeys()) {
                Stat stat;
                double value = (Double)container.getOrDefault(key, PersistentDataType.DOUBLE, (Object)0.0);
                if (value == 0.0 || (stat = (Stat)this.plugin.getStatRegistry().getOrNull(NamespacedId.fromDefault(key.getKey()))) == null) continue;
                String modifierName = this.getModifierName(stat, type, offhand);
                StatModifier modifier = new StatModifier(modifierName, stat, value, AuraSkillsModifier.Operation.ADD);
                modifier.setNonPersistent();
                modifiers.add(modifier);
            }
        }
        return modifiers;
    }

    public List<TraitModifier> getTraitModifiers(ModifierType type) {
        return this.getTraitModifiers(type, false);
    }

    public List<TraitModifier> getTraitModifiers(ModifierType type, boolean offhand) {
        ArrayList<TraitModifier> modifiers = new ArrayList<TraitModifier>();
        if (this.isContainerList(MetaType.TRAIT_MODIFIER, type)) {
            List<PersistentDataContainer> containers = this.getContainerList(MetaType.TRAIT_MODIFIER, type);
            for (PersistentDataContainer container : containers) {
                Trait trait;
                String traitName;
                double value = (Double)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "value"), PersistentDataType.DOUBLE, (Object)0.0);
                if (value == 0.0 || (traitName = (String)container.get(new NamespacedKey((Plugin)this.plugin, "trait"), PersistentDataType.STRING)) == null || (trait = (Trait)this.plugin.getTraitRegistry().getOrNull(NamespacedId.fromDefault(traitName))) == null) continue;
                String operationName = (String)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "operation"), PersistentDataType.STRING, (Object)AuraSkillsModifier.Operation.ADD.toString());
                AuraSkillsModifier.Operation operation = AuraSkillsModifier.Operation.parse(operationName);
                String modifierName = this.getModifierName(trait, type, offhand);
                TraitModifier modifier = new TraitModifier(modifierName, trait, value, operation);
                modifier.setNonPersistent();
                modifiers.add(modifier);
            }
        } else {
            PersistentDataContainer container = this.getContainer(MetaType.TRAIT_MODIFIER, type);
            for (NamespacedKey key : container.getKeys()) {
                Trait trait;
                double value = (Double)container.getOrDefault(key, PersistentDataType.DOUBLE, (Object)0.0);
                if (value == 0.0 || (trait = (Trait)this.plugin.getTraitRegistry().getOrNull(NamespacedId.fromDefault(key.getKey()))) == null) continue;
                String modifierName = this.getModifierName(trait, type, offhand);
                TraitModifier modifier = new TraitModifier(modifierName, trait, value, AuraSkillsModifier.Operation.ADD);
                modifier.setNonPersistent();
                modifiers.add(modifier);
            }
        }
        return modifiers;
    }

    private String getModifierName(ReloadableIdentifier identifier, ModifierType type, boolean offhand) {
        String prefix;
        String string = prefix = identifier instanceof Stat ? "AuraSkills.Modifiers." : "AuraSkills.TraitModifiers.";
        if (type == ModifierType.ITEM) {
            return prefix + "Item." + this.getName(identifier) + (offhand ? ".Offhand" : "");
        }
        return prefix + "Armor." + this.getSlotName() + "." + this.getName(identifier);
    }

    public void addModifier(MetaType metaType, ModifierType modifierType, NamespaceIdentified identified, double value, AuraSkillsModifier.Operation operation) {
        if (this.isTagContainer(metaType, modifierType)) {
            this.convertModifiersToContainerList();
        }
        List<PersistentDataContainer> containers = this.getContainerList(metaType, modifierType);
        PersistentDataContainer container = this.meta.getPersistentDataContainer().getAdapterContext().newPersistentDataContainer();
        container.set(this.getTypeKey(metaType), PersistentDataType.STRING, (Object)identified.getId().toString());
        container.set(new NamespacedKey((Plugin)this.plugin, "value"), PersistentDataType.DOUBLE, (Object)value);
        container.set(new NamespacedKey((Plugin)this.plugin, "operation"), PersistentDataType.STRING, (Object)operation.toString().toLowerCase(Locale.ROOT));
        containers.add(container);
        this.saveContainerList(containers, metaType, modifierType);
    }

    public void removeModifier(MetaType metaType, ModifierType modifierType, NamespaceIdentified identified) {
        if (this.isTagContainer(metaType, modifierType)) {
            this.convertModifiersToContainerList();
        }
        List<PersistentDataContainer> containers = this.getContainerList(metaType, modifierType);
        containers.removeIf(c -> {
            @Nullable String typeName = (String)c.get(this.getTypeKey(metaType), PersistentDataType.STRING);
            return typeName == null || typeName.equals(identified.getId().toString());
        });
        this.saveContainerList(containers, metaType, modifierType);
        this.removeEmpty(containers, metaType, modifierType);
    }

    private void convertModifiersToContainerList() {
        for (MetaType metaType : new MetaType[]{MetaType.MODIFIER, MetaType.TRAIT_MODIFIER}) {
            for (ModifierType modifierType : ModifierType.values()) {
                String name;
                NamespacedKey metaKey;
                PersistentDataContainer oldContainer;
                PersistentDataContainer metaContainer;
                if (this.isContainerList(metaType, modifierType) || (metaContainer = (PersistentDataContainer)(oldContainer = this.meta.getPersistentDataContainer()).get(metaKey = new NamespacedKey((Plugin)this.plugin, name = this.getContainerName(metaType, modifierType)), PersistentDataType.TAG_CONTAINER)) == null) continue;
                List<PersistentDataContainer> migratedList = this.convertContainerToList(metaContainer, metaType);
                this.saveContainerList(migratedList, metaType, modifierType);
                this.removeEmpty(migratedList, metaType, modifierType);
            }
        }
    }

    private List<PersistentDataContainer> convertContainerToList(PersistentDataContainer oldContainer, MetaType metaType) {
        ArrayList<PersistentDataContainer> list = new ArrayList<PersistentDataContainer>();
        for (NamespacedKey key : oldContainer.getKeys()) {
            NamespaceIdentified identified;
            double value = (Double)oldContainer.getOrDefault(key, PersistentDataType.DOUBLE, (Object)0.0);
            if (value == 0.0 || (identified = metaType == MetaType.MODIFIER ? (NamespaceIdentified)this.plugin.getStatRegistry().getOrNull(NamespacedId.fromDefault(key.getKey())) : (NamespaceIdentified)this.plugin.getTraitRegistry().getOrNull(NamespacedId.fromDefault(key.getKey()))) == null) continue;
            PersistentDataContainer created = this.meta.getPersistentDataContainer().getAdapterContext().newPersistentDataContainer();
            created.set(this.getTypeKey(metaType), PersistentDataType.STRING, (Object)identified.getId().toString());
            created.set(new NamespacedKey((Plugin)this.plugin, "value"), PersistentDataType.DOUBLE, (Object)value);
            created.set(new NamespacedKey((Plugin)this.plugin, "operation"), PersistentDataType.STRING, (Object)AuraSkillsModifier.Operation.ADD.toString().toLowerCase(Locale.ROOT));
            list.add(created);
        }
        return list;
    }

    private NamespacedKey getTypeKey(MetaType metaType) {
        String key = "stat";
        if (metaType == MetaType.MODIFIER) {
            key = "stat";
        } else if (metaType == MetaType.TRAIT_MODIFIER) {
            key = "trait";
        }
        return new NamespacedKey((Plugin)this.plugin, key);
    }

    public void removeAll(MetaType metaType, ModifierType modifierType) {
        PersistentDataContainer parent = this.meta.getPersistentDataContainer();
        parent.remove(new NamespacedKey((Plugin)this.plugin, this.getContainerName(metaType, modifierType)));
    }

    public List<Multiplier> getMultipliers(ModifierType type) {
        return this.getMultipliers(type, false);
    }

    public List<Multiplier> getMultipliers(ModifierType type, boolean offhand) {
        PersistentDataContainer container = this.getContainer(MetaType.MULTIPLIER, type);
        ArrayList<Multiplier> multipliers = new ArrayList<Multiplier>();
        for (NamespacedKey key : container.getKeys()) {
            double value = (Double)container.getOrDefault(key, PersistentDataType.DOUBLE, (Object)0.0);
            if (value == 0.0) continue;
            Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(key.getKey()));
            if (type == ModifierType.ITEM) {
                multipliers.add(new Multiplier("AuraSkills.Modifiers.Item." + this.getMultiplierName(skill) + (offhand ? ".Offhand" : ""), skill, value));
                continue;
            }
            if (type != ModifierType.ARMOR) continue;
            multipliers.add(new Multiplier("AuraSkills.Modifiers.Armor." + this.getSlotName() + "." + this.getMultiplierName(skill), skill, value));
        }
        return multipliers;
    }

    public void addMultiplier(ModifierType type, @Nullable Skill skill, double value) {
        PersistentDataContainer container = this.getContainer(MetaType.MULTIPLIER, type);
        container.set(this.getSkillKey(skill), PersistentDataType.DOUBLE, (Object)value);
        this.saveTagContainer(container, MetaType.MULTIPLIER, type);
    }

    public void removeMultiplier(ModifierType type, Skill skill) {
        PersistentDataContainer container = this.getContainer(MetaType.MULTIPLIER, type);
        container.remove(this.getSkillKey(skill));
        this.saveTagContainer(container, MetaType.MULTIPLIER, type);
        this.removeEmpty(container, MetaType.MULTIPLIER, type);
    }

    public Map<Skill, Integer> getRequirements(ModifierType type) {
        PersistentDataContainer container = this.getContainer(MetaType.REQUIREMENT, type);
        ConcurrentHashMap<Skill, Integer> requirements = new ConcurrentHashMap<Skill, Integer>();
        for (NamespacedKey key : container.getKeys()) {
            Skill skill;
            int value = (Integer)container.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
            if (value == 0 || (skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(key.getKey()))) == null) continue;
            requirements.put(skill, value);
        }
        return requirements;
    }

    public void addRequirement(ModifierType type, Skill skill, int level) {
        PersistentDataContainer container = this.getContainer(MetaType.REQUIREMENT, type);
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, skill.getId().toString());
        container.set(key, PersistentDataType.INTEGER, (Object)level);
        this.saveTagContainer(container, MetaType.REQUIREMENT, type);
    }

    public void removeRequirement(ModifierType type, Skill skill) {
        PersistentDataContainer container = this.getContainer(MetaType.REQUIREMENT, type);
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, skill.getId().toString());
        container.remove(key);
        this.saveTagContainer(container, MetaType.REQUIREMENT, type);
        this.removeEmpty(container, MetaType.REQUIREMENT, type);
    }

    public void addIgnore() {
        PersistentDataContainer container = this.meta.getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "ignore_interact");
        container.set(key, PersistentDataType.BYTE, (Object)1);
    }

    public void removeIgnore() {
        PersistentDataContainer container = this.meta.getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "ignore_interact");
        container.remove(key);
    }

    public void convertFromLegacy(ReadWriteNBT nbt) {
        if (this.plugin.isNbtApiDisabled()) {
            return;
        }
        Modifiers modifiers = new Modifiers(this.plugin);
        for (ModifierType type : ModifierType.values()) {
            List<StatModifier> legacy = modifiers.getLegacyModifiers(type, nbt);
            if (legacy.isEmpty()) continue;
            for (StatModifier statModifier : legacy) {
                this.addModifier(MetaType.MODIFIER, type, statModifier.stat(), statModifier.value(), AuraSkillsModifier.Operation.ADD);
            }
        }
        Multipliers multipliers = new Multipliers(this.plugin);
        for (ModifierType type : ModifierType.values()) {
            List<Multiplier> legacy = multipliers.getLegacyMultipliers(type, nbt);
            if (legacy.isEmpty()) continue;
            for (Multiplier multiplier : legacy) {
                this.addMultiplier(type, multiplier.skill(), multiplier.value());
            }
        }
        Requirements requirements = new Requirements(this.plugin);
        for (ModifierType type : ModifierType.values()) {
            Map<Skill, Integer> map = requirements.getLegacyRequirements(type, nbt);
            if (map.isEmpty()) continue;
            for (Map.Entry<Skill, Integer> entry : map.entrySet()) {
                this.addRequirement(type, entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean meetsRequirements(ModifierType type, Player player) {
        if (!this.plugin.configBoolean(Option.REQUIREMENT_ENABLED)) {
            return true;
        }
        if (player.hasMetadata("NPC")) {
            return true;
        }
        User user = this.plugin.getUser(player);
        Map<Skill, Integer> itemRequirements = this.getRequirements(type);
        if (!this.plugin.configBoolean(Option.REQUIREMENT_OVERRIDE_GLOBAL) || itemRequirements.isEmpty()) {
            for (Map.Entry<Skill, Integer> entry : this.getGlobalRequirements(type).entrySet()) {
                if (user.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
                return false;
            }
        }
        for (Map.Entry<Skill, Integer> entry : this.getRequirements(type).entrySet()) {
            if (user.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public Map<Skill, Integer> getGlobalRequirements(ModifierType type) {
        ConcurrentHashMap<Skill, Integer> requirements = new ConcurrentHashMap<Skill, Integer>();
        for (GlobalRequirement global : this.plugin.getRequirementManager().getGlobalRequirementsType(type)) {
            if (global.getMaterial() != this.item.getType()) continue;
            requirements.putAll(global.getRequirements());
        }
        return requirements;
    }

    public void addModifierLore(ModifierType type, NamespaceIdentified identified, double value, AuraSkillsModifier.Operation operation, Locale locale) {
        List lore = this.meta.getLore() != null ? (!this.meta.getLore().isEmpty() ? this.meta.getLore() : new LinkedList()) : new LinkedList();
        CommandMessage message = operation == AuraSkillsModifier.Operation.ADD_PERCENT ? (value >= 0.0 ? CommandMessage.valueOf(type.name() + "_MODIFIER_ADD_LORE_ADD_PERCENT") : CommandMessage.valueOf(type.name() + "_MODIFIER_ADD_LORE_SUBTRACT_PERCENT")) : (operation == AuraSkillsModifier.Operation.MULTIPLY ? CommandMessage.valueOf(type.name() + "_MODIFIER_ADD_LORE_MULTIPLY") : (value >= 0.0 ? CommandMessage.valueOf(type.name() + "_MODIFIER_ADD_LORE") : CommandMessage.valueOf(type.name() + "_MODIFIER_ADD_LORE_SUBTRACT")));
        if (identified instanceof Stat) {
            Stat stat = (Stat)identified;
            lore.add(0, this.plugin.getMessageProvider().applyFormatting(TextUtil.replace(this.plugin.getMsg(message, locale), "{stat}", stat.getDisplayName(locale), "{value}", NumberUtil.format2(Math.abs(value)), "{color}", stat.getColor(locale), "{symbol}", stat.getSymbol(locale))));
        } else if (identified instanceof Trait) {
            Trait trait = (Trait)identified;
            @Nullable Stat stat = this.plugin.getTraitManager().getLinkedStats(trait).stream().findFirst().orElse(null);
            BukkitTraitHandler impl = this.plugin.getTraitManager().getTraitImpl(trait);
            String formatValue = impl != null && !trait.getId().getKey().contains("_luck") && operation == AuraSkillsModifier.Operation.ADD ? impl.getMenuDisplay(value, trait, locale) : NumberUtil.format2(Math.abs(value));
            if (formatValue.startsWith("+")) {
                formatValue = formatValue.substring(1);
            }
            lore.add(0, this.plugin.getMessageProvider().applyFormatting(TextUtil.replace(this.plugin.getMsg(message, locale), "{stat}", trait.getDisplayName(locale), "{value}", formatValue, "{color}", stat != null ? stat.getColor(locale) : "")));
        }
        this.meta.setLore(lore);
    }

    public void removeModifierLore(Stat stat, Locale locale) {
        List lore = this.meta.getLore();
        if (lore != null && !lore.isEmpty()) {
            lore.removeIf(line -> line.contains(stat.getDisplayName(locale)));
        }
        this.meta.setLore(lore);
    }

    public void addMultiplierLore(ModifierType type, Skill skill, double value, Locale locale) {
        List lore = this.meta.getLore() != null ? (!this.meta.getLore().isEmpty() ? this.meta.getLore() : new LinkedList()) : new LinkedList();
        if (skill != null) {
            CommandMessage message = value >= 0.0 ? CommandMessage.valueOf(type.name() + "_MULTIPLIER_ADD_SKILL_LORE") : CommandMessage.valueOf(type.name() + "_MULTIPLIER_ADD_SKILL_LORE_SUBTRACT");
            if (!lore.isEmpty()) {
                lore.add(" ");
            }
            lore.add(TextUtil.replace(this.plugin.getMsg(message, locale), "{skill}", skill.getDisplayName(locale), "{value}", NumberUtil.format1(Math.abs(value))));
        } else {
            CommandMessage message = value >= 0.0 ? CommandMessage.valueOf(type.name() + "_MULTIPLIER_ADD_GLOBAL_LORE") : CommandMessage.valueOf(type.name() + "_MULTIPLIER_ADD_GLOBAL_LORE_SUBTRACT");
            if (!lore.isEmpty()) {
                lore.add(" ");
            }
            lore.add(TextUtil.replace(this.plugin.getMsg(message, locale), "{value}", NumberUtil.format1(Math.abs(value))));
        }
        this.meta.setLore(lore);
    }

    public void addRequirementLore(ModifierType type, Skill skill, int level, Locale locale) {
        String text = TextUtil.replace(this.plugin.getMsg(CommandMessage.valueOf(type.name() + "_REQUIREMENT_ADD_LORE"), locale), "{skill}", skill.getDisplayName(locale), "{level}", String.valueOf(level));
        ArrayList<String> lore = this.meta.hasLore() ? this.meta.getLore() : new ArrayList<String>();
        if (lore != null) {
            lore.add(text);
            this.meta.setLore(lore);
        }
    }

    public void removeRequirementLore(Skill skill) {
        List lore = this.meta.getLore();
        if (lore != null) {
            for (int i = 0; i < lore.size(); ++i) {
                String line = (String)lore.get(i);
                if (!line.contains("Requires") || !line.contains(TextUtil.capitalize(skill.name().toLowerCase(Locale.ROOT)))) continue;
                lore.remove(line);
            }
            this.meta.setLore(lore);
        }
    }

    private NamespacedKey getSkillKey(@Nullable Skill skill) {
        if (skill != null) {
            return new NamespacedKey((Plugin)this.plugin, skill.getId().toString());
        }
        return new NamespacedKey((Plugin)this.plugin, "global");
    }

    private PersistentDataContainer getContainer(MetaType metaType, ModifierType modifierType) {
        String name;
        NamespacedKey metaKey;
        PersistentDataContainer container = this.meta.getPersistentDataContainer();
        if (!container.has(metaKey = new NamespacedKey((Plugin)this.plugin, name = this.getContainerName(metaType, modifierType)), PersistentDataType.TAG_CONTAINER)) {
            return container.getAdapterContext().newPersistentDataContainer();
        }
        PersistentDataContainer metaContainer = (PersistentDataContainer)container.get(metaKey, PersistentDataType.TAG_CONTAINER);
        if (metaContainer == null) {
            metaContainer = container.getAdapterContext().newPersistentDataContainer();
        }
        return metaContainer;
    }

    private List<PersistentDataContainer> getContainerList(MetaType metaType, ModifierType modifierType) {
        PersistentDataContainer[] tagContainerArray;
        ArrayList<Object> metaContainerList;
        PersistentDataContainer container = this.meta.getPersistentDataContainer();
        String name = this.getContainerName(metaType, modifierType);
        NamespacedKey metaKey = new NamespacedKey((Plugin)this.plugin, name);
        metaContainerList = VersionUtils.isAtLeastVersion(20, 4) ? ((metaContainerList = (ArrayList<PersistentDataContainer>)container.get(metaKey, (PersistentDataType)PersistentDataType.LIST.dataContainers())) == null ? new ArrayList() : new ArrayList(metaContainerList)) : ((tagContainerArray = (PersistentDataContainer[])container.get(metaKey, PersistentDataType.TAG_CONTAINER_ARRAY)) == null ? new ArrayList<PersistentDataContainer>() : new ArrayList<PersistentDataContainer>(Arrays.asList(tagContainerArray)));
        return metaContainerList;
    }

    private boolean isContainerList(MetaType metaType, ModifierType modifierType) {
        PersistentDataContainer container = this.meta.getPersistentDataContainer();
        String name = this.getContainerName(metaType, modifierType);
        NamespacedKey metaKey = new NamespacedKey((Plugin)this.plugin, name);
        if (VersionUtils.isAtLeastVersion(20, 4)) {
            return container.has(metaKey, (PersistentDataType)PersistentDataType.LIST.dataContainers());
        }
        return container.has(metaKey, PersistentDataType.TAG_CONTAINER_ARRAY);
    }

    private boolean isTagContainer(MetaType metaType, ModifierType modifierType) {
        PersistentDataContainer container = this.meta.getPersistentDataContainer();
        String name = this.getContainerName(metaType, modifierType);
        NamespacedKey metaKey = new NamespacedKey((Plugin)this.plugin, name);
        return container.has(metaKey, PersistentDataType.TAG_CONTAINER);
    }

    private void saveTagContainer(PersistentDataContainer container, MetaType metaType, ModifierType modifierType) {
        PersistentDataContainer parent = this.meta.getPersistentDataContainer();
        String name = this.getContainerName(metaType, modifierType);
        parent.set(new NamespacedKey((Plugin)this.plugin, name), PersistentDataType.TAG_CONTAINER, (Object)container);
    }

    private void saveContainerList(List<PersistentDataContainer> containers, MetaType metaType, ModifierType modifierType) {
        PersistentDataContainer parent = this.meta.getPersistentDataContainer();
        String name = this.getContainerName(metaType, modifierType);
        if (VersionUtils.isAtLeastVersion(20, 4)) {
            parent.set(new NamespacedKey((Plugin)this.plugin, name), (PersistentDataType)PersistentDataType.LIST.dataContainers(), containers);
        } else {
            parent.set(new NamespacedKey((Plugin)this.plugin, name), PersistentDataType.TAG_CONTAINER_ARRAY, (Object)containers.toArray(new PersistentDataContainer[0]));
        }
    }

    private void removeEmpty(PersistentDataContainer container, MetaType metaType, ModifierType modifierType) {
        if (!container.isEmpty()) {
            return;
        }
        PersistentDataContainer parent = this.meta.getPersistentDataContainer();
        NamespacedKey metaKey = new NamespacedKey((Plugin)this.plugin, this.getContainerName(metaType, modifierType));
        parent.remove(metaKey);
    }

    private void removeEmpty(List<PersistentDataContainer> containers, MetaType metaType, ModifierType modifierType) {
        if (!containers.isEmpty()) {
            return;
        }
        PersistentDataContainer parent = this.meta.getPersistentDataContainer();
        NamespacedKey metaKey = new NamespacedKey((Plugin)this.plugin, this.getContainerName(metaType, modifierType));
        parent.remove(metaKey);
    }

    private String getContainerName(MetaType metaType, ModifierType modifierType) {
        return modifierType.toString().toLowerCase(Locale.ROOT) + "_" + metaType.getKey();
    }

    private String getName(ReloadableIdentifier identifier) {
        return TextUtil.capitalize(identifier.name().toLowerCase(Locale.ROOT));
    }

    private String getMultiplierName(@Nullable Skill skill) {
        if (skill != null) {
            return TextUtil.capitalize(skill.toString().toLowerCase(Locale.ROOT));
        }
        return "Global";
    }

    private String getSlotName() {
        String slot = "Helmet";
        String mat = this.item.getType().toString();
        if (mat.contains("CHESTPLATE") || this.item.getType() == Material.ELYTRA) {
            slot = "Chestplate";
        } else if (mat.contains("LEGGINGS")) {
            slot = "Leggings";
        } else if (mat.contains("BOOTS")) {
            slot = "Boots";
        }
        return slot;
    }

    public static enum MetaType {
        MODIFIER("modifiers"),
        TRAIT_MODIFIER("trait_modifiers"),
        REQUIREMENT("requirements"),
        MULTIPLIER("multipliers");

        private final String key;

        private MetaType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

