/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.item;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.event.item.ItemDisableEvent;
import dev.aurelium.auraskills.api.event.item.ItemEnableEvent;
import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.skill.Multiplier;
import dev.aurelium.auraskills.api.stat.ReloadableIdentifier;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.SkillsItem;
import dev.aurelium.auraskills.bukkit.item.UserEquipment;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.nbtapi.NBT;
import dev.aurelium.auraskills.nbtapi.NBTType;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStateManager {
    private final AuraSkills plugin;

    public ItemStateManager(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void changeItemInSlot(User userObj, Player player, @NotNull ItemStack afterItem, @NotNull EquipmentSlot slot) {
        this.changeItemInSlot(userObj, player, afterItem, slot, true, false, false);
    }

    public Set<ReloadableIdentifier> changeItemInSlot(User userObj, Player player, @NotNull ItemStack afterItem, @NotNull EquipmentSlot slot, boolean reloadIds, boolean force, boolean modify) {
        Result result;
        if (!(userObj instanceof BukkitUser)) {
            return Set.of();
        }
        BukkitUser user = (BukkitUser)userObj;
        UserEquipment equipment = user.getEquipment();
        ItemStack beforeItem = equipment.getSlot(slot);
        if (!force && afterItem.equals((Object)beforeItem)) {
            return Set.of();
        }
        Set toReload = Sets.newConcurrentHashSet();
        ItemStack modifiedItem = afterItem;
        if (!beforeItem.getType().equals((Object)Material.AIR)) {
            result = this.removeItem(beforeItem, user, player, slot);
            toReload.addAll(result.toReload);
        }
        if (!afterItem.getType().equals((Object)Material.AIR)) {
            result = this.addItem(afterItem, user, player, slot);
            toReload.addAll(result.toReload);
            modifiedItem = result.item;
        }
        equipment.setSlot(slot, modifiedItem.clone());
        if (!modifiedItem.equals((Object)afterItem) && modify) {
            player.getInventory().setItem(slot, modifiedItem);
        }
        if (reloadIds) {
            this.reloadIdentifiers(user, toReload);
        }
        return toReload;
    }

    public void reloadIdentifiers(User user, Set<ReloadableIdentifier> toReload) {
        for (ReloadableIdentifier identifier : toReload) {
            this.plugin.getStatManager().reload(user, identifier);
        }
    }

    private Result removeItem(ItemStack item, BukkitUser user, Player player, @NotNull EquipmentSlot slot) {
        ModifierType type = this.getModifierType(slot);
        Set toReload = Sets.newConcurrentHashSet();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (StatModifier statModifier : skillsItem.getStatModifiers(type, slot == EquipmentSlot.OFF_HAND)) {
            user.removeStatModifier(statModifier.name(), false);
            toReload.add(statModifier.stat());
        }
        for (TraitModifier traitModifier : skillsItem.getTraitModifiers(type, slot == EquipmentSlot.OFF_HAND)) {
            user.removeTraitModifier(traitModifier.name(), false);
            toReload.add(traitModifier.trait());
        }
        for (Multiplier multiplier : skillsItem.getMultipliers(type, slot == EquipmentSlot.OFF_HAND)) {
            user.removeMultiplier(multiplier.name());
        }
        ItemDisableEvent event = new ItemDisableEvent(player, user.toApi(), item, type, slot, toReload);
        Bukkit.getPluginManager().callEvent((Event)event);
        return new Result(item, event.getToReload());
    }

    private Result addItem(ItemStack item, BukkitUser user, Player player, @NotNull EquipmentSlot slot) {
        Set toReload = Sets.newConcurrentHashSet();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        ModifierType type = this.getModifierType(slot);
        if (skillsItem.meetsRequirements(type, player)) {
            for (StatModifier statModifier : skillsItem.getStatModifiers(type, slot == EquipmentSlot.OFF_HAND)) {
                user.addStatModifier(statModifier, false);
                toReload.add(statModifier.stat());
            }
            for (TraitModifier traitModifier : skillsItem.getTraitModifiers(type, slot == EquipmentSlot.OFF_HAND)) {
                user.addTraitModifier(traitModifier, false);
                toReload.add(traitModifier.trait());
            }
            for (Multiplier multiplier : skillsItem.getMultipliers(type, slot == EquipmentSlot.OFF_HAND)) {
                user.addMultiplier(multiplier);
            }
        }
        ItemEnableEvent event = new ItemEnableEvent(player, user.toApi(), item, type, slot, toReload);
        Bukkit.getPluginManager().callEvent((Event)event);
        return new Result(item, event.getToReload());
    }

    private ItemStack convertLegacyItem(ItemStack item) {
        if (this.plugin.isNbtApiDisabled()) {
            return item;
        }
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        NBT.modify(item, skillsItem::convertFromLegacy);
        item = skillsItem.getItem();
        NBT.modify(item, nbt -> {
            if (nbt.hasTag("AureliumSkills", NBTType.NBTTagCompound)) {
                nbt.removeKey("AureliumSkills");
            }
        });
        return item;
    }

    private ModifierType getModifierType(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HAND, EquipmentSlot.OFF_HAND -> ModifierType.ITEM;
            default -> ModifierType.ARMOR;
        };
    }

    private record Result(ItemStack item, Set<ReloadableIdentifier> toReload) {
    }
}

