/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.hooks.mythicmobs;

import dev.aurelium.auraskills.api.damage.DamageType;
import dev.aurelium.auraskills.api.event.damage.DamageEvent;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.damage.DamageHandler;
import dev.aurelium.auraskills.bukkit.hooks.mythicmobs.GiveSkillXpMechanic;
import dev.aurelium.auraskills.bukkit.hooks.mythicmobs.HasManaCondition;
import dev.aurelium.auraskills.bukkit.hooks.mythicmobs.TakeManaMechanic;
import dev.aurelium.auraskills.bukkit.hooks.mythicmobs.loot.MythicEntityLootParser;
import dev.aurelium.auraskills.common.damage.DamageResult;
import dev.aurelium.auraskills.common.hooks.Hook;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.conditions.ISkillCondition;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicConditionLoadEvent;
import io.lumine.mythic.bukkit.events.MythicDamageEvent;
import io.lumine.mythic.bukkit.events.MythicMechanicLoadEvent;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;

public class MythicMobsHook
extends Hook
implements Listener {
    private final AuraSkills plugin;
    private final DamageHandler damageHandler;

    public MythicMobsHook(AuraSkills plugin, ConfigurationNode config) {
        super(plugin, config);
        this.plugin = plugin;
        this.damageHandler = new DamageHandler();
        this.registerItemProvider();
        plugin.getScheduler().executeSync(() -> plugin.getLootManager().registerCustomEntityParser(new MythicEntityLootParser(plugin)));
    }

    private void registerItemProvider() {
        this.plugin.getItemRegistry().registerExternalItemProvider("mythicmobs", id -> MythicBukkit.inst().getItemManager().getItemStack(id));
    }

    @EventHandler
    public void onMythicSkillDamage(MythicDamageEvent event) {
        DamageResult result;
        Player player;
        if (!this.getConfig().node("handle_damage_increase").getBoolean() && !this.getConfig().node("handle_damage_reduction").getBoolean()) {
            return;
        }
        AbstractEntity attacker = event.getCaster().getEntity();
        AbstractEntity target = event.getTarget();
        if (attacker.isPlayer()) {
            player = BukkitAdapter.adapt((AbstractPlayer)attacker.asPlayer());
            if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
                return;
            }
            if (player.hasMetadata("NPC")) {
                return;
            }
            if (event.getDamageMetadata().getDamageCause() == EntityDamageEvent.DamageCause.THORNS) {
                return;
            }
        }
        if (target.isPlayer()) {
            player = BukkitAdapter.adapt((AbstractPlayer)target.asPlayer());
            if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
                return;
            }
            if (target.hasMetadata("NPC")) {
                return;
            }
        }
        if ((result = this.damageHandler.handleDamage(BukkitAdapter.adapt((AbstractEntity)attacker), BukkitAdapter.adapt((AbstractEntity)target), this.getDamageType(attacker), event.getDamageMetadata().getDamageCause(), event.getDamage(), "mythicmobs")).cancel()) {
            event.setCancelled(true);
        } else {
            event.setDamage(result.damage());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void damageListener(DamageEvent event) {
        if (!event.getDamageMeta().getSource().equals("mythicmobs")) {
            return;
        }
        if (!this.getConfig().node("handle_damage_increase").getBoolean()) {
            event.getDamageMeta().clearAttackModifiers();
        }
        if (!this.getConfig().node("handle_damage_reduction").getBoolean()) {
            event.getDamageMeta().clearDefenseModifiers();
        }
    }

    public boolean shouldPreventEntityXp(Entity entity) {
        if (!this.getConfig().node("prevent_regular_xp").getBoolean()) {
            return false;
        }
        return MythicBukkit.inst().getMobManager().isMythicMob(entity);
    }

    @EventHandler
    public void onMechanicLoad(MythicMechanicLoadEvent event) {
        if (event.getMechanicName().equalsIgnoreCase("takeMana")) {
            event.register((ISkillMechanic)new TakeManaMechanic(this.plugin, event));
        } else if (event.getMechanicName().equalsIgnoreCase("giveSkillXP")) {
            event.register((ISkillMechanic)new GiveSkillXpMechanic(this.plugin, event));
        }
    }

    @EventHandler
    public void onConditionLoad(MythicConditionLoadEvent event) {
        if (event.getConditionName().equalsIgnoreCase("hasMana")) {
            event.register((ISkillCondition)new HasManaCondition(this.plugin, event));
        }
    }

    @Override
    public Class<? extends Hook> getTypeClass() {
        return MythicMobsHook.class;
    }

    private DamageType getDamageType(AbstractEntity attacker) {
        if (!attacker.isPlayer()) {
            return DamageType.OTHER;
        }
        Material material = BukkitAdapter.adapt((AbstractPlayer)attacker.asPlayer()).getInventory().getItemInMainHand().getType();
        if (material.name().contains("SWORD")) {
            return DamageType.SWORD;
        }
        if (material.name().contains("_AXE")) {
            return DamageType.AXE;
        }
        if (material.name().contains("PICKAXE")) {
            return DamageType.PICKAXE;
        }
        if (material.name().contains("SHOVEL") || material.name().contains("SPADE")) {
            return DamageType.SHOVEL;
        }
        if (material.name().contains("HOE")) {
            return DamageType.HOE;
        }
        if (material.equals((Object)Material.AIR)) {
            return DamageType.HAND;
        }
        if (material.equals((Object)Material.BOW) || material.equals((Object)Material.TRIDENT)) {
            return DamageType.BOW;
        }
        return DamageType.OTHER;
    }
}

