/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.hooks;

import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.hooks.Hook;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public abstract class HologramsHook
extends Hook
implements Listener {
    private final Random random = new Random();
    private NumberFormat numberFormat;
    private ChatColor defaultColor = ChatColor.GRAY;
    private List<ChatColor> criticalColors = new ArrayList<ChatColor>();

    public HologramsHook(AuraSkillsPlugin plugin, ConfigurationNode config) {
        super(plugin, config);
        this.loadConfig();
    }

    public void loadConfig() {
        this.defaultColor = ChatColor.valueOf((String)this.plugin.configString(Option.DAMAGE_HOLOGRAMS_COLORS_DEFAULT).toUpperCase(Locale.ROOT));
        this.criticalColors = this.plugin.configStringList(Option.DAMAGE_HOLOGRAMS_COLORS_CRITICAL_DIGITS).stream().map(s -> ChatColor.valueOf((String)s.toUpperCase(Locale.ROOT))).toList();
        this.numberFormat = new DecimalFormat("#." + TextUtil.repeat('#', this.plugin.configInt(Option.DAMAGE_HOLOGRAMS_DECIMAL_MAX)));
    }

    public abstract void createHologram(Location var1, String var2, Player var3);

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!this.plugin.getHookManager().isRegistered(HologramsHook.class)) {
            return;
        }
        if (!this.plugin.configBoolean(Option.DAMAGE_HOLOGRAMS_ENABLED)) {
            return;
        }
        if (this.plugin.getWorldManager().isDisabledWorld(event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            player = (Player)event.getDamager();
        } else {
            Projectile projectile;
            Entity entity = event.getDamager();
            if (entity instanceof Projectile && (projectile = (Projectile)entity).getShooter() instanceof Player) {
                player = (Player)projectile.getShooter();
                if (player.equals((Object)event.getEntity())) {
                    return;
                }
                if (event.getFinalDamage() <= 0.0) {
                    return;
                }
            } else {
                return;
            }
        }
        boolean critical = player.hasMetadata("skillsCritical");
        this.createHologram(this.getLocation(event.getEntity()), this.getText(event.getFinalDamage(), critical), player);
    }

    private Location getLocation(Entity entity) {
        Location location = entity.getLocation();
        if (this.plugin.configBoolean(Option.DAMAGE_HOLOGRAMS_OFFSET_RANDOM_ENABLED)) {
            double xMin = this.plugin.configDouble(Option.DAMAGE_HOLOGRAMS_OFFSET_RANDOM_X_MIN);
            double xMax = this.plugin.configDouble(Option.DAMAGE_HOLOGRAMS_OFFSET_RANDOM_X_MAX);
            double x = xMin + (xMax - xMin) * this.random.nextDouble();
            double yMin = this.plugin.configDouble(Option.DAMAGE_HOLOGRAMS_OFFSET_RANDOM_Y_MIN);
            double yMax = this.plugin.configDouble(Option.DAMAGE_HOLOGRAMS_OFFSET_RANDOM_Y_MAX);
            double y = yMin + (yMax - yMin) * this.random.nextDouble();
            double zMin = this.plugin.configDouble(Option.DAMAGE_HOLOGRAMS_OFFSET_RANDOM_Z_MIN);
            double zMax = this.plugin.configDouble(Option.DAMAGE_HOLOGRAMS_OFFSET_RANDOM_Z_MAX);
            double z = zMin + (zMax - zMin) * this.random.nextDouble();
            location.add(x, entity.getHeight() - entity.getHeight() * 0.1 + y, z);
        } else {
            double x = this.plugin.configDouble(Option.DAMAGE_HOLOGRAMS_OFFSET_X);
            double y = entity.getHeight() - entity.getHeight() * 0.1 + this.plugin.configDouble(Option.DAMAGE_HOLOGRAMS_OFFSET_Y);
            double z = this.plugin.configDouble(Option.DAMAGE_HOLOGRAMS_OFFSET_Z);
            location.add(x, y, z);
        }
        return location;
    }

    private String getText(double damage, boolean critical) {
        double damageScaling;
        damage = Math.max(0.0, damage);
        StringBuilder text = new StringBuilder(String.valueOf(this.defaultColor));
        Object damageText = this.plugin.configBoolean(Option.DAMAGE_HOLOGRAMS_SCALING) ? ((damageScaling = damage * Traits.HP.optionDouble("action_bar_scaling")) < this.plugin.configDouble(Option.DAMAGE_HOLOGRAMS_DECIMAL_LESS_THAN) ? this.numberFormat.format(damageScaling) : "" + Math.round(damageScaling)) : (damage < this.plugin.configDouble(Option.DAMAGE_HOLOGRAMS_DECIMAL_LESS_THAN) ? this.numberFormat.format(damage) : "" + Math.round(damage));
        if (critical) {
            text.append(this.getCriticalText((String)damageText));
        } else {
            text.append((String)damageText);
        }
        return text.toString();
    }

    private String getCriticalText(String damageText) {
        StringBuilder text = new StringBuilder(String.valueOf(this.defaultColor));
        block0: for (int i = 0; i < damageText.length(); ++i) {
            int j = Math.abs(i - (damageText.length() - 1));
            for (int k = 0; k < this.criticalColors.size(); ++k) {
                if (k == j) {
                    text.append(this.criticalColors.get(k)).append(damageText.charAt(i));
                    continue block0;
                }
                if (k != this.criticalColors.size() - 1) continue;
                text.append(this.criticalColors.get(k)).append(damageText.charAt(i));
            }
        }
        return text.toString();
    }
}

