/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Default;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="%skills_alias")
@Subcommand(value="xp")
public class XpCommand
extends BaseCommand {
    private final AuraSkills plugin;

    public XpCommand(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="add")
    @CommandCompletion(value="@players @skills")
    @CommandPermission(value="auraskills.command.xp.add")
    @Description(value="%desc_xp_add")
    public void onXpAdd(CommandSender sender, @Flags(value="other") Player player, Skill skill, double amount, @Default(value="false") boolean silent) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (skill.isEnabled()) {
            this.plugin.getLevelManager().addXp(user, skill, null, amount);
            if (!silent) {
                sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.XP_ADD_ADDED, locale), "{amount}", String.valueOf(amount), "{skill}", skill.getDisplayName(locale), "{player}", player.getName()));
            }
        } else {
            sender.sendMessage(this.plugin.getPrefix(locale) + String.valueOf(ChatColor.YELLOW) + this.plugin.getMsg(CommandMessage.UNKNOWN_SKILL, locale));
        }
    }

    @Subcommand(value="set")
    @CommandCompletion(value="@players @skills")
    @CommandPermission(value="auraskills.command.xp.set")
    @Description(value="%desc_xp_set")
    public void onXpSet(CommandSender sender, @Flags(value="other") Player player, Skill skill, double amount, @Default(value="false") boolean silent) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (skill.isEnabled()) {
            this.plugin.getLevelManager().setXp(user, skill, amount);
            if (!silent) {
                sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.XP_SET_SET, locale), "{amount}", String.valueOf(amount), "{skill}", skill.getDisplayName(locale), "{player}", player.getName()));
            }
        } else {
            sender.sendMessage(this.plugin.getPrefix(locale) + String.valueOf(ChatColor.YELLOW) + this.plugin.getMsg(CommandMessage.UNKNOWN_SKILL, locale));
        }
    }

    @Subcommand(value="remove")
    @CommandCompletion(value="@players @skills")
    @CommandPermission(value="auraskills.command.xp.remove")
    @Description(value="%desc_xp_remove")
    public void onXpRemove(CommandSender sender, @Flags(value="other") Player player, Skill skill, double amount, @Default(value="false") boolean silent) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (skill.isEnabled()) {
            if (user.getSkillXp(skill) - amount >= 0.0) {
                this.plugin.getLevelManager().setXp(user, skill, user.getSkillXp(skill) - amount);
                if (!silent) {
                    sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.XP_REMOVE_REMOVED, locale), "{amount}", String.valueOf(amount), "{skill}", skill.getDisplayName(locale), "{player}", player.getName()));
                }
            } else {
                if (!silent) {
                    sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.XP_REMOVE_REMOVED, locale), "{amount}", String.valueOf(user.getSkillXp(skill)), "{skill}", skill.getDisplayName(locale), "{player}", player.getName()));
                }
                this.plugin.getLevelManager().setXp(user, skill, 0.0);
            }
        } else {
            sender.sendMessage(this.plugin.getPrefix(locale) + String.valueOf(ChatColor.YELLOW) + this.plugin.getMsg(CommandMessage.UNKNOWN_SKILL, locale));
        }
    }
}

