/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Optional;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.message.MessageBuilder;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="%skills_alias")
@Subcommand(value="skill")
public class SkillCommand
extends BaseCommand {
    private final AuraSkills plugin;

    public SkillCommand(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="setlevel")
    @CommandCompletion(value="@players @skills")
    @CommandPermission(value="auraskills.command.skill.setlevel")
    @Description(value="%desc_skill_setlevel")
    public void onSkillSetlevel(CommandSender sender, @Flags(value="other") Player player, Skill skill, int level) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (skill.isEnabled()) {
            int startLevel = this.plugin.config().getStartLevel();
            if (level >= startLevel) {
                int oldLevel = user.getSkillLevel(skill);
                user.setSkillLevel(skill, level);
                user.setSkillXp(skill, 0.0);
                this.plugin.getStatManager().recalculateStats(user);
                this.plugin.getRewardManager().updatePermissions(user);
                this.plugin.getRewardManager().applyRevertCommands(user, skill, oldLevel, level);
                this.plugin.getRewardManager().applyLevelUpCommands(user, skill, oldLevel, level);
                this.plugin.getModifierManager().applyModifiers(player, true);
                sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.SKILL_SETLEVEL_SET, locale).replace("{skill}", skill.getDisplayName(locale)).replace("{level}", String.valueOf(level)).replace("{player}", player.getName()));
            } else {
                sender.sendMessage(MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.SKILL_AT_LEAST, "level", String.valueOf(startLevel)).toString());
            }
        } else {
            sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.UNKNOWN_SKILL, locale));
        }
    }

    @Subcommand(value="addlevel")
    @CommandCompletion(value="@players @skills")
    @CommandPermission(value="auraskills.command.skill.setlevel")
    @Description(value="%desc_skill_addlevel")
    public void onSkillAddlevel(CommandSender sender, @Flags(value="other") Player player, Skill skill, int level) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (skill.isEnabled()) {
            int oldLevel = user.getSkillLevel(skill);
            level = oldLevel + level;
            this.onSkillSetlevel(sender, player, skill, level);
        } else {
            sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.UNKNOWN_SKILL, locale));
        }
    }

    @Subcommand(value="setall")
    @CommandCompletion(value="@players")
    @CommandPermission(value="auraskills.command.skill.setlevel")
    @Description(value="%desc_skill_setall")
    public void onSkillSetall(CommandSender sender, @Flags(value="other") Player player, int level) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        int startLevel = this.plugin.config().getStartLevel();
        if (level >= startLevel) {
            for (Skill skill : this.plugin.getSkillRegistry().getValues()) {
                if (!skill.isEnabled()) continue;
                int oldLevel = user.getSkillLevel(skill);
                user.setSkillLevel(skill, level);
                user.setSkillXp(skill, 0.0);
                this.plugin.getRewardManager().applyRevertCommands(user, skill, oldLevel, level);
                this.plugin.getRewardManager().applyLevelUpCommands(user, skill, oldLevel, level);
            }
            this.plugin.getStatManager().recalculateStats(user);
            this.plugin.getModifierManager().applyModifiers(player, true);
            this.plugin.getRewardManager().updatePermissions(user);
            sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.SKILL_SETALL_SET, locale).replace("{level}", String.valueOf(level)).replace("{player}", player.getName()));
        } else {
            sender.sendMessage(MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.SKILL_AT_LEAST, "level", String.valueOf(startLevel)).toString());
        }
    }

    @Subcommand(value="reset")
    @CommandCompletion(value="@players @skills")
    @CommandPermission(value="auraskills.command.skill.reset")
    @Description(value="%desc_skill_reset")
    public void onSkillReset(CommandSender sender, @Flags(value="other") Player player, @Optional Skill skill) {
        User user = this.plugin.getUser(player);
        Locale locale = user.getLocale();
        if (skill != null) {
            if (skill.isEnabled()) {
                int level = user.resetSkill(skill);
                this.plugin.getModifierManager().applyModifiers(player, true);
                sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.SKILL_SETLEVEL_SET, locale).replace("{skill}", skill.getDisplayName(locale)).replace("{level}", String.valueOf(level)).replace("{player}", player.getName()));
            } else {
                sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.UNKNOWN_SKILL, locale));
            }
        } else {
            int level = this.plugin.config().getStartLevel();
            for (Skill s : this.plugin.getSkillRegistry().getValues()) {
                level = user.resetSkill(s);
            }
            this.plugin.getModifierManager().applyModifiers(player, true);
            sender.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.SKILL_SETALL_SET, locale).replace("{level}", String.valueOf(level)).replace("{player}", player.getName()));
        }
    }
}

