/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.CommandIssuer;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.message.MessageBuilder;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.storage.StorageProvider;
import dev.aurelium.auraskills.common.storage.backup.BackupProvider;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;

@CommandAlias(value="%skills_alias")
@Subcommand(value="backup")
public class BackupCommand
extends BaseCommand {
    private final AuraSkills plugin;

    public BackupCommand(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="save")
    @CommandPermission(value="auraskills.command.backup.save")
    @Description(value="%desc_backup_save")
    public void onBackupSave(CommandIssuer issuer) {
        BackupProvider backupProvider = this.plugin.getBackupProvider();
        Locale locale = this.plugin.getLocale(issuer);
        issuer.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.BACKUP_SAVE_SAVING, locale));
        CompletableFuture<File> future = backupProvider.saveBackupAsync(true);
        future.whenComplete((file, exception) -> this.plugin.getScheduler().executeSync(() -> {
            if (file != null) {
                MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.BACKUP_SAVE_SAVED, "type", this.plugin.getStorageProvider().getClass().getSimpleName(), "file", file.getName()).send(issuer);
            } else {
                issuer.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.BACKUP_SAVE_ERROR, locale), "{type}", this.plugin.getStorageProvider().getClass().getSimpleName()));
                if (exception != null) {
                    exception.printStackTrace();
                }
            }
        }));
    }

    @Subcommand(value="load")
    @CommandPermission(value="auraskills.command.backup.load")
    @Description(value="%desc_backup_load")
    public void onBackupLoad(CommandIssuer issuer, String fileName) {
        StorageProvider storageProvider = this.plugin.getStorageProvider();
        Locale locale = this.plugin.getLocale(issuer);
        if (storageProvider == null) {
            return;
        }
        File file = new File(String.valueOf(this.plugin.getDataFolder()) + "/backups/" + fileName);
        if (!file.exists()) {
            issuer.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.BACKUP_LOAD_FILE_NOT_FOUND, locale));
            return;
        }
        if (!file.getName().endsWith(".yml")) {
            issuer.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.BACKUP_LOAD_MUST_BE_YAML, locale));
            return;
        }
        if (this.plugin.getConfirmManager().requiresConfirmation(issuer, fileName)) {
            issuer.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.BACKUP_LOAD_CONFIRM, locale));
            return;
        }
        this.loadBackup(file, issuer, locale);
        this.plugin.getConfirmManager().remove(issuer);
    }

    private void loadBackup(File file, CommandIssuer issuer, Locale locale) {
        issuer.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.BACKUP_LOAD_LOADING, locale));
        long start = System.currentTimeMillis();
        this.plugin.getBackupProvider().loadBackupAsync(file, () -> {
            long end = System.currentTimeMillis();
            this.plugin.getScheduler().executeSync(() -> {
                MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.BACKUP_LOAD_LOADED, new String[0]).send(issuer);
                issuer.sendMessage("Loaded backup in " + (end - start) + "ms");
            });
        }, e -> {
            this.plugin.getScheduler().executeSync(() -> issuer.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.BACKUP_LOAD_ERROR, locale), "{error}", e.getMessage())));
            e.printStackTrace();
        });
    }
}

