/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.MessageType;
import dev.aurelium.auraskills.acf.MinecraftMessageKeys;
import dev.aurelium.auraskills.acf.PaperCommandManager;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Conditions;
import dev.aurelium.auraskills.acf.annotation.Default;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.AntiAfkLog;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="%skills_alias")
@Subcommand(value="antiafk")
public class AntiAfkCommand
extends BaseCommand {
    private final AuraSkills plugin;

    public AntiAfkCommand(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="logs")
    @CommandPermission(value="auraskills.command.antiafk.logs")
    @CommandCompletion(value="@players")
    @Description(value="%desc_antiafk_logs")
    public void onLogs(CommandSender sender, @Flags(value="other") String player, @Default(value="1") @Conditions(value="limits:min=1") Integer page, @Default(value="10") @Conditions(value="limits:min=1") Integer perPage) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)player);
        PaperCommandManager manager = this.plugin.getCommandManager();
        if (!offlinePlayer.hasPlayedBefore()) {
            sender.sendMessage(manager.formatMessage(manager.getCommandIssuer(sender), MessageType.ERROR, MinecraftMessageKeys.NO_PLAYER_FOUND, "{search}", player));
            return;
        }
        int offset = (page - 1) * perPage;
        Player bukkitPlayer = offlinePlayer.getPlayer();
        if (offlinePlayer.isOnline() && bukkitPlayer != null) {
            User user = this.plugin.getUser(bukkitPlayer);
            if (user.getStoredAntiAfkLogs().isEmpty()) {
                this.plugin.getScheduler().executeAsync(() -> {
                    List<AntiAfkLog> loaded = this.plugin.getStorageProvider().loadAntiAfkLogs(offlinePlayer.getUniqueId());
                    user.setStoredAntiAfkLogs(new ArrayList<AntiAfkLog>(loaded));
                    loaded.addAll(user.getSessionAntiAfkLogs());
                    List<AntiAfkLog> logs = this.getMostRecent(loaded, offset, perPage);
                    this.plugin.getScheduler().executeSync(() -> this.sendLogsMessage(sender, offlinePlayer, logs, page, perPage, loaded.size()));
                });
            } else {
                List<AntiAfkLog> allLogs = user.getStoredAntiAfkLogs().get();
                allLogs.addAll(user.getSessionAntiAfkLogs());
                List<AntiAfkLog> logs = this.getMostRecent(allLogs, offset, perPage);
                this.sendLogsMessage(sender, (OfflinePlayer)bukkitPlayer, logs, page, perPage, allLogs.size());
            }
        } else {
            this.plugin.getScheduler().executeAsync(() -> {
                List<AntiAfkLog> loaded = this.plugin.getStorageProvider().loadAntiAfkLogs(offlinePlayer.getUniqueId());
                List<AntiAfkLog> logs = this.getMostRecent(loaded, offset, perPage);
                this.plugin.getScheduler().executeSync(() -> this.sendLogsMessage(sender, offlinePlayer, logs, page, perPage, loaded.size()));
            });
        }
    }

    private void sendLogsMessage(CommandSender recipient, OfflinePlayer target, List<AntiAfkLog> logs, int page, int perPage, int total) {
        Locale locale = this.plugin.getLocale(recipient);
        int pages = (total - 1) / perPage + 1;
        StringBuilder sb = new StringBuilder();
        sb.append(TextUtil.replace(this.plugin.getMsg(CommandMessage.ANTIAFK_LOGS_HEADER, locale), "{player}", target.getName(), "{count}", String.valueOf(total), "{page}", String.valueOf(page), "{total_pages}", String.valueOf(pages)));
        sb.append("\n");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH:mm:ss");
        for (AntiAfkLog log : logs) {
            String formattedTime = Instant.ofEpochMilli(log.timestamp()).atZone(ZoneId.systemDefault()).toLocalDateTime().format(formatter);
            sb.append(TextUtil.replace(this.plugin.getMsg(CommandMessage.ANTIAFK_LOGS_ENTRY, locale), "{timestamp}", formattedTime, "{message}", log.message()));
            sb.append("\n");
        }
        if (sb.length() >= 2) {
            sb.delete(sb.length() - 2, sb.length());
        }
        recipient.sendMessage(sb.toString());
    }

    private List<AntiAfkLog> getMostRecent(List<AntiAfkLog> logs, int offset, int limit) {
        ArrayList<AntiAfkLog> copied = new ArrayList<AntiAfkLog>(logs);
        copied.sort(Comparator.comparingLong(AntiAfkLog::timestamp).reversed());
        ArrayList<AntiAfkLog> limited = new ArrayList<AntiAfkLog>();
        for (int i = offset; i < offset + limit && i < copied.size(); ++i) {
            limited.add((AntiAfkLog)copied.get(i));
        }
        return limited;
    }
}

