/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.loot;

import dev.aurelium.auraskills.api.loot.LootRequirements;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class LootOptioned {
    protected final Map<String, Object> options;
    private final LootRequirements requirements;

    public LootOptioned(Map<String, Object> options, LootRequirements requirements) {
        this.options = options;
        this.requirements = requirements;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Nullable
    public <T> T getOption(String key, Class<T> type) {
        Object o = this.options.get(key);
        if (o == null) {
            return null;
        }
        return type.cast(o);
    }

    public <T> T getOption(String key, Class<T> type, T def) {
        Object o = this.options.get(key);
        if (o == null) {
            return def;
        }
        return type.cast(o);
    }

    public boolean checkRequirements(UUID uuid) {
        return this.requirements.checkByUuid(uuid);
    }
}

