/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.damage;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.damage.DamageModifier;
import dev.aurelium.auraskills.api.damage.DamageType;
import dev.aurelium.auraskills.api.user.SkillsUser;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;

public class DamageMeta {
    private final DamageType damageType;
    private final EntityDamageEvent.DamageCause damageCause;
    private final List<DamageModifier> attackModifiers = new ArrayList<DamageModifier>();
    private final List<DamageModifier> defenseModifiers = new ArrayList<DamageModifier>();
    private final Entity attacker;
    private final Entity target;
    private final String source;
    private double damage;

    public DamageMeta(@Nullable Entity attacker, Entity target, DamageType damageType, EntityDamageEvent.DamageCause damageCause, double damage, String source) {
        this.attacker = attacker;
        this.target = target;
        this.damageType = damageType;
        this.damageCause = damageCause;
        this.damage = damage;
        this.source = source;
    }

    public double getBaseDamage() {
        return this.damage;
    }

    public EntityDamageEvent.DamageCause getDamageCause() {
        return this.damageCause;
    }

    public List<DamageModifier> getAttackModifiers() {
        return this.attackModifiers;
    }

    public void addAttackModifier(DamageModifier modifier) {
        this.attackModifiers.add(modifier);
    }

    public List<DamageModifier> getDefenseModifiers() {
        return this.defenseModifiers;
    }

    public void addDefenseModifier(DamageModifier modifier) {
        this.defenseModifiers.add(modifier);
    }

    public DamageType getDamageType() {
        return this.damageType;
    }

    @Nullable
    public Entity getAttacker() {
        return this.attacker;
    }

    public Entity getTarget() {
        return this.target;
    }

    @Nullable
    public Player getAttackerAsPlayer() {
        ProjectileSource shooter;
        if (this.attacker instanceof Player) {
            return (Player)this.attacker;
        }
        if (this.attacker instanceof Projectile && (shooter = ((Projectile)this.attacker).getShooter()) instanceof Player) {
            return (Player)shooter;
        }
        return null;
    }

    @Nullable
    public Player getTargetAsPlayer() {
        if (this.target instanceof Player) {
            return (Player)this.target;
        }
        return null;
    }

    @Nullable
    public SkillsUser getAttackerAsUser() {
        Player player = this.getAttackerAsPlayer();
        if (player != null) {
            return AuraSkillsApi.get().getUser(player.getUniqueId());
        }
        return null;
    }

    @Nullable
    public SkillsUser getTargetAsUser() {
        Player player = this.getTargetAsPlayer();
        if (player != null) {
            return AuraSkillsApi.get().getUser(player.getUniqueId());
        }
        return null;
    }

    public void clearAttackModifiers() {
        this.attackModifiers.clear();
    }

    public void clearDefenseModifiers() {
        this.defenseModifiers.clear();
    }

    public String getSource() {
        return this.source;
    }
}

