/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.option;

import dev.aurelium.auraskills.slate.function.ItemMetaParser;
import dev.aurelium.auraskills.slate.item.provider.KeyedItemProvider;
import dev.aurelium.auraskills.slate.option.SlateOptions;
import dev.aurelium.auraskills.slate.util.Validate;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlateOptionsBuilder {
    private File mainDirectory;
    private List<File> mergeDirectories = new ArrayList<File>();
    private int loreWrappingWidth = 40;
    private KeyedItemProvider keyedItemProvider = k -> null;
    private final Map<String, ItemMetaParser> itemMetaParsers = new HashMap<String, ItemMetaParser>();

    public SlateOptionsBuilder mainDirectory(File mainDirectory) {
        this.mainDirectory = mainDirectory;
        return this;
    }

    public SlateOptionsBuilder mergeDirectories(List<File> mergeDirectories) {
        this.mergeDirectories = mergeDirectories;
        return this;
    }

    public SlateOptionsBuilder loreWrappingWidth(int loreWrappingWidth) {
        this.loreWrappingWidth = loreWrappingWidth;
        return this;
    }

    public SlateOptionsBuilder keyedItemProvider(KeyedItemProvider keyedItemProvider) {
        this.keyedItemProvider = keyedItemProvider;
        return this;
    }

    public SlateOptionsBuilder itemMetaParser(String name, ItemMetaParser parser) {
        this.itemMetaParsers.put(name, parser);
        return this;
    }

    public SlateOptionsBuilder itemMetaParsers(Map<String, ItemMetaParser> parsers) {
        this.itemMetaParsers.putAll(parsers);
        return this;
    }

    public SlateOptions build() {
        Validate.notNull(this.mainDirectory, "mainDirectory not defined in SlateOptions");
        return new SlateOptions(this.mainDirectory, this.mergeDirectories, this.loreWrappingWidth, this.keyedItemProvider, this.itemMetaParsers);
    }
}

