/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.item.parser;

import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.action.condition.ItemConditions;
import dev.aurelium.auraskills.slate.context.ContextGroup;
import dev.aurelium.auraskills.slate.context.ContextProvider;
import dev.aurelium.auraskills.slate.context.GroupAlign;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.item.MenuItem;
import dev.aurelium.auraskills.slate.item.builder.TemplateItemBuilder;
import dev.aurelium.auraskills.slate.item.parser.MenuItemParser;
import dev.aurelium.auraskills.slate.lore.LoreLine;
import dev.aurelium.auraskills.slate.position.FixedPosition;
import dev.aurelium.auraskills.slate.position.GroupPosition;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;

public class TemplateItemParser<C>
extends MenuItemParser {
    @NotNull
    private final ContextProvider<C> contextProvider;

    public TemplateItemParser(Slate slate, @NotNull ContextProvider<C> contextProvider) {
        super(slate);
        this.contextProvider = contextProvider;
    }

    @Override
    public MenuItem parse(ConfigurationNode section, String menuName) {
        TemplateItemBuilder<Object> builder = new TemplateItemBuilder<Object>(this.slate);
        String name = (String)Objects.requireNonNull(section.key());
        builder.name(name);
        builder.contextClass(this.contextProvider.getType());
        Map<String, ContextGroup> groups = this.loadGroups(section);
        builder.contextGroups(groups);
        HashMap<C, ItemStack> baseItems = new HashMap<C, ItemStack>();
        HashMap<C, Record> positions = new HashMap<C, Record>();
        HashMap<C, String> contextualDisplayNames = new HashMap<C, String>();
        HashMap<C, List<LoreLine>> contextualLore = new HashMap<C, List<LoreLine>>();
        HashMap<C, ItemConditions> contextualConditions = new HashMap<C, ItemConditions>();
        for (ConfigurationNode configurationNode : section.node("contexts").childrenMap().values()) {
            List<LoreLine> contextualLoreList;
            String positionString;
            String key = configurationNode.key() instanceof String ? (String)Objects.requireNonNull(configurationNode.key()) : String.valueOf(configurationNode.key());
            C context = this.contextProvider.parse(menuName, key);
            if (context == null) continue;
            if (!configurationNode.node("material").virtual() || !configurationNode.node("key").virtual()) {
                baseItems.put(context, this.itemParser.parseBaseItem(configurationNode));
            }
            if ((positionString = configurationNode.node("pos").getString()) != null) {
                positions.put(context, new FixedPosition(this.parsePosition(positionString)));
            } else if (!configurationNode.node("group").virtual()) {
                String groupName = configurationNode.node("group").getString();
                ContextGroup group = groups.get(groupName);
                if (group == null) {
                    positions.put(context, new FixedPosition(this.parsePosition("0,0")));
                } else {
                    int order = configurationNode.node("order").getInt(1);
                    positions.put(context, new GroupPosition(group, order));
                }
            }
            String contextualDisplayName = this.itemParser.parseDisplayName(configurationNode);
            if (contextualDisplayName != null) {
                contextualDisplayNames.put(context, contextualDisplayName);
            }
            if (!(contextualLoreList = this.itemParser.parseLore(configurationNode)).isEmpty()) {
                contextualLore.put(context, contextualLoreList);
            }
            contextualConditions.put(context, this.getConditions(configurationNode, menuName));
        }
        builder.contextualDisplayNames(contextualDisplayNames);
        builder.contextualLore(contextualLore);
        builder.contextualConditions(contextualConditions);
        String defaultPos = section.node("pos").getString();
        if (positions.isEmpty() && defaultPos != null) {
            SlotPos slotPos = this.parsePosition(defaultPos);
            builder.defaultPosition(slotPos);
        }
        builder.baseItems(baseItems);
        builder.positions(positions);
        if (!section.node("material").virtual() || !section.node("key").virtual()) {
            builder.defaultBaseItem(this.itemParser.parseBaseItem(section));
        }
        this.parseCommonOptions(builder, section, menuName);
        return builder.build();
    }

    private Map<String, ContextGroup> loadGroups(ConfigurationNode section) {
        HashMap<String, ContextGroup> groups = new HashMap<String, ContextGroup>();
        for (ConfigurationNode configurationNode : section.node("groups").childrenMap().values()) {
            String groupName = (String)configurationNode.key();
            if (groupName == null) continue;
            SlotPos start = this.parsePosition(configurationNode.node("start").getString("0,0"));
            SlotPos end = this.parsePosition(configurationNode.node("end").getString("0,0"));
            GroupAlign align = GroupAlign.valueOf(configurationNode.node("align").getString("CENTER").toUpperCase(Locale.ROOT));
            groups.put(groupName, new ContextGroup(start, end, align));
        }
        return groups;
    }
}

