/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.item.builder;

import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.action.condition.ItemConditions;
import dev.aurelium.auraskills.slate.context.ContextGroup;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.item.MenuItem;
import dev.aurelium.auraskills.slate.item.TemplateData;
import dev.aurelium.auraskills.slate.item.TemplateItem;
import dev.aurelium.auraskills.slate.item.builder.MenuItemBuilder;
import dev.aurelium.auraskills.slate.lore.LoreLine;
import dev.aurelium.auraskills.slate.position.PositionProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class TemplateItemBuilder<C>
extends MenuItemBuilder {
    private Class<C> contextClass;
    private Map<C, PositionProvider> positions;
    private Map<C, ItemStack> baseItems;
    private Map<C, String> contextualDisplayNames;
    private Map<C, List<LoreLine>> contextualLore;
    private Map<C, ItemConditions> contextualConditions;
    private ItemStack defaultBaseItem;
    private SlotPos defaultPosition;
    private Map<String, ContextGroup> contextGroups = new HashMap<String, ContextGroup>();

    public TemplateItemBuilder(Slate slate) {
        super(slate);
    }

    public TemplateItemBuilder<C> contextClass(Class<C> contextClass) {
        this.contextClass = contextClass;
        return this;
    }

    public TemplateItemBuilder<C> positions(Map<C, PositionProvider> positions) {
        this.positions = positions;
        return this;
    }

    public TemplateItemBuilder<C> baseItems(Map<C, ItemStack> baseItems) {
        this.baseItems = baseItems;
        return this;
    }

    public TemplateItemBuilder<C> defaultBaseItem(ItemStack defaultBaseItem) {
        this.defaultBaseItem = defaultBaseItem;
        return this;
    }

    public TemplateItemBuilder<C> defaultPosition(SlotPos defaultPosition) {
        this.defaultPosition = defaultPosition;
        return this;
    }

    public TemplateItemBuilder<C> contextualDisplayNames(Map<C, String> contextualDisplayNames) {
        this.contextualDisplayNames = contextualDisplayNames;
        return this;
    }

    public TemplateItemBuilder<C> contextualLore(Map<C, List<LoreLine>> contextualLore) {
        this.contextualLore = contextualLore;
        return this;
    }

    public TemplateItemBuilder<C> contextGroups(Map<String, ContextGroup> contextGroups) {
        this.contextGroups = contextGroups;
        return this;
    }

    public TemplateItemBuilder<C> contextualConditions(Map<C, ItemConditions> contextualConditions) {
        this.contextualConditions = contextualConditions;
        return this;
    }

    @Override
    public MenuItem build() {
        TemplateData<C> templateData = new TemplateData<C>(this.positions, this.baseItems, this.contextualDisplayNames, this.contextualLore, this.contextualConditions);
        return new TemplateItem<C>(this.slate, this.name, this.contextClass, templateData, this.defaultBaseItem, this.displayName, this.lore, this.actions, this.conditions, this.defaultPosition, this.options, this.contextGroups);
    }
}

