/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.item;

import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.action.Action;
import dev.aurelium.auraskills.slate.action.condition.Condition;
import dev.aurelium.auraskills.slate.action.condition.ItemConditions;
import dev.aurelium.auraskills.slate.action.trigger.ClickTrigger;
import dev.aurelium.auraskills.slate.lore.LoreLine;
import dev.aurelium.auraskills.slate.menu.MenuInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public abstract class MenuItem {
    protected final Slate slate;
    private final String name;
    private final String displayName;
    private final List<LoreLine> lore;
    private final Map<ClickTrigger, List<Action>> actions;
    private final ItemConditions conditions;
    private final Map<String, Object> options;

    public MenuItem(Slate slate, String name, String displayName, List<LoreLine> lore, Map<ClickTrigger, List<Action>> actions, ItemConditions conditions, Map<String, Object> options) {
        this.slate = slate;
        this.name = name;
        this.displayName = displayName;
        this.lore = lore;
        this.actions = actions;
        this.conditions = conditions;
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public List<LoreLine> getLore() {
        return this.lore;
    }

    public Map<ClickTrigger, List<Action>> getActions() {
        return this.actions;
    }

    public ItemConditions getConditions() {
        return this.conditions;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public boolean failsViewConditions(Player player, MenuInventory inventory) {
        return this.failsConditions(player, inventory, this.conditions.viewConditions());
    }

    public boolean failsClickConditions(ClickTrigger trigger, Player player, MenuInventory inventory) {
        return this.failsConditions(player, inventory, this.conditions.clickConditions().getOrDefault((Object)trigger, new ArrayList()));
    }

    protected boolean failsConditions(Player player, MenuInventory inventory, List<Condition> conditions) {
        for (Condition condition : conditions) {
            if (condition.isMet(player, inventory)) continue;
            return true;
        }
        return false;
    }
}

