/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.inv.content;

import com.google.common.base.Preconditions;
import dev.aurelium.auraskills.slate.inv.ClickableItem;
import dev.aurelium.auraskills.slate.inv.SmartInventory;
import dev.aurelium.auraskills.slate.inv.content.InventoryContents;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.inv.util.Pattern;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public interface SlotIterator {
    public Optional<ClickableItem> get();

    public SlotIterator set(ClickableItem var1);

    public SlotIterator previous();

    public SlotIterator next();

    public SlotIterator blacklist(int var1);

    public SlotIterator blacklist(int var1, int var2);

    public SlotIterator blacklist(SlotPos var1);

    public int row();

    public SlotIterator row(int var1);

    public int column();

    public SlotIterator column(int var1);

    public SlotIterator reset();

    public boolean started();

    public boolean ended();

    public SlotIterator endPosition(int var1, int var2);

    public SlotIterator endPosition(SlotPos var1);

    public boolean doesAllowOverride();

    public SlotIterator allowOverride(boolean var1);

    public SlotIterator withPattern(Pattern<Boolean> var1);

    public SlotIterator withPattern(Pattern<Boolean> var1, int var2, int var3);

    public SlotIterator blacklistPattern(Pattern<Boolean> var1);

    public SlotIterator blacklistPattern(Pattern<Boolean> var1, int var2, int var3);

    public static class Impl
    implements SlotIterator {
        private InventoryContents contents;
        private final SmartInventory inv;
        private final Type type;
        private boolean started = false;
        private boolean allowOverride = true;
        private int endRow;
        private int endColumn;
        private int startRow;
        private int startColumn;
        private int row;
        private int column;
        private Set<SlotPos> blacklisted = new HashSet<SlotPos>();
        private int patternRowOffset;
        private int patternColumnOffset;
        private Pattern<Boolean> pattern;
        private int blacklistPatternRowOffset;
        private int blacklistPatternColumnOffset;
        private Pattern<Boolean> blacklistPattern;

        public Impl(InventoryContents contents, SmartInventory inv, Type type, int startRow, int startColumn) {
            this.contents = contents;
            this.inv = inv;
            this.type = type;
            this.endRow = this.inv.getRows() - 1;
            this.endColumn = this.inv.getColumns() - 1;
            this.startRow = this.row = startRow;
            this.startColumn = this.column = startColumn;
        }

        public Impl(InventoryContents contents, SmartInventory inv, Type type) {
            this(contents, inv, type, 0, 0);
        }

        @Override
        public Optional<ClickableItem> get() {
            return this.contents.get(this.row, this.column);
        }

        @Override
        public SlotIterator set(ClickableItem item) {
            if (this.canPlace()) {
                this.contents.set(this.row, this.column, item);
            }
            return this;
        }

        @Override
        public SlotIterator previous() {
            if (this.row == 0 && this.column == 0) {
                this.started = true;
                return this;
            }
            do {
                if (!this.started) {
                    this.started = true;
                    continue;
                }
                switch (this.type) {
                    case HORIZONTAL: {
                        --this.column;
                        if (this.column != 0) break;
                        this.column = this.inv.getColumns() - 1;
                        --this.row;
                        break;
                    }
                    case VERTICAL: {
                        --this.row;
                        if (this.row != 0) break;
                        this.row = this.inv.getRows() - 1;
                        --this.column;
                    }
                }
            } while (!this.canPlace() && (this.row != 0 || this.column != 0));
            return this;
        }

        @Override
        public SlotIterator next() {
            if (this.ended()) {
                this.started = true;
                return this;
            }
            do {
                if (!this.started) {
                    this.started = true;
                    continue;
                }
                switch (this.type) {
                    case HORIZONTAL: {
                        ++this.column;
                        this.column %= this.inv.getColumns();
                        if (this.column != 0) break;
                        ++this.row;
                        break;
                    }
                    case VERTICAL: {
                        ++this.row;
                        this.row %= this.inv.getRows();
                        if (this.row != 0) break;
                        ++this.column;
                    }
                }
            } while (!this.canPlace() && !this.ended());
            return this;
        }

        @Override
        public SlotIterator blacklist(int index) {
            int columnCount = this.inv.getColumns();
            this.blacklisted.add(SlotPos.of(index / columnCount, index % columnCount));
            return this;
        }

        @Override
        public SlotIterator blacklist(int row, int column) {
            this.blacklisted.add(SlotPos.of(row, column));
            return this;
        }

        @Override
        public SlotIterator blacklist(SlotPos slotPos) {
            return this.blacklist(slotPos.getRow(), slotPos.getColumn());
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public SlotIterator row(int row) {
            this.row = row;
            return this;
        }

        @Override
        public int column() {
            return this.column;
        }

        @Override
        public SlotIterator column(int column) {
            this.column = column;
            return this;
        }

        @Override
        public SlotIterator reset() {
            this.started = false;
            this.row = this.startRow;
            this.column = this.startColumn;
            return this;
        }

        @Override
        public boolean started() {
            return this.started;
        }

        @Override
        public boolean ended() {
            return this.row == this.endRow && this.column == this.endColumn;
        }

        @Override
        public SlotIterator endPosition(int row, int column) {
            if (row < 0) {
                row = this.inv.getRows() - 1;
            }
            if (column < 0) {
                column = this.inv.getColumns() - 1;
            }
            Preconditions.checkArgument((row * column >= this.startRow * this.startColumn ? 1 : 0) != 0, (Object)"The end position needs to be after the start of the slot iterator");
            this.endRow = row;
            this.endColumn = column;
            return this;
        }

        @Override
        public SlotIterator endPosition(SlotPos endPosition) {
            return this.endPosition(endPosition.getRow(), endPosition.getColumn());
        }

        @Override
        public boolean doesAllowOverride() {
            return this.allowOverride;
        }

        @Override
        public SlotIterator allowOverride(boolean override) {
            this.allowOverride = override;
            return this;
        }

        @Override
        public SlotIterator withPattern(Pattern<Boolean> pattern) {
            return this.withPattern(pattern, 0, 0);
        }

        @Override
        public SlotIterator withPattern(Pattern<Boolean> pattern, int rowOffset, int columnOffset) {
            this.patternRowOffset = rowOffset;
            this.patternColumnOffset = columnOffset;
            if (pattern.getDefault() == null) {
                pattern.setDefault(false);
            }
            this.pattern = pattern;
            return this;
        }

        @Override
        public SlotIterator blacklistPattern(Pattern<Boolean> pattern) {
            return this.blacklistPattern(pattern, 0, 0);
        }

        @Override
        public SlotIterator blacklistPattern(Pattern<Boolean> pattern, int rowOffset, int columnOffset) {
            this.blacklistPatternRowOffset = rowOffset;
            this.blacklistPatternColumnOffset = columnOffset;
            if (pattern.getDefault() == null) {
                pattern.setDefault(false);
            }
            this.blacklistPattern = pattern;
            return this;
        }

        private boolean canPlace() {
            boolean patternAllows = true;
            boolean blacklistPatternAllows = true;
            if (this.pattern != null) {
                patternAllows = this.checkPattern(this.pattern, this.patternRowOffset, this.patternColumnOffset);
            }
            if (this.blacklistPattern != null) {
                blacklistPatternAllows = !this.checkPattern(this.blacklistPattern, this.blacklistPatternRowOffset, this.blacklistPatternColumnOffset);
            }
            return !this.blacklisted.contains(SlotPos.of(this.row, this.column)) && (this.allowOverride || !this.get().isPresent()) && patternAllows && blacklistPatternAllows;
        }

        private boolean checkPattern(Pattern<Boolean> pattern, int rowOffset, int columnOffset) {
            if (pattern.isWrapAround()) {
                return pattern.getObject(this.row - rowOffset, this.column - columnOffset);
            }
            return this.row >= rowOffset && this.column >= columnOffset && this.row < pattern.getRowCount() + rowOffset && this.column < pattern.getColumnCount() + columnOffset && pattern.getObject(this.row - rowOffset, this.column - columnOffset) != false;
        }
    }

    public static enum Type {
        HORIZONTAL,
        VERTICAL;

    }
}

