/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.inv.content;

import com.google.common.base.Preconditions;
import dev.aurelium.auraskills.slate.inv.ClickableItem;
import dev.aurelium.auraskills.slate.inv.SmartInventory;
import dev.aurelium.auraskills.slate.inv.content.Pagination;
import dev.aurelium.auraskills.slate.inv.content.SlotIterator;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.inv.util.Pattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public interface InventoryContents {
    public SmartInventory inventory();

    public Pagination pagination();

    public Optional<SlotIterator> iterator(String var1);

    public SlotIterator newIterator(String var1, SlotIterator.Type var2, int var3, int var4);

    public SlotIterator newIterator(SlotIterator.Type var1, int var2, int var3);

    public SlotIterator newIterator(String var1, SlotIterator.Type var2, SlotPos var3);

    public SlotIterator newIterator(SlotIterator.Type var1, SlotPos var2);

    public ClickableItem[][] all();

    public List<SlotPos> slots();

    public Optional<SlotPos> firstEmpty();

    public Optional<ClickableItem> get(int var1);

    public Optional<ClickableItem> get(int var1, int var2);

    public Optional<ClickableItem> get(SlotPos var1);

    public InventoryContents applyRect(int var1, int var2, int var3, int var4, BiConsumer<Integer, Integer> var5);

    public InventoryContents applyRect(int var1, int var2, int var3, int var4, Consumer<ClickableItem> var5);

    public InventoryContents set(int var1, ClickableItem var2);

    public InventoryContents set(int var1, int var2, ClickableItem var3);

    public InventoryContents set(SlotPos var1, ClickableItem var2);

    public InventoryContents add(ClickableItem var1);

    public InventoryContents updateItem(int var1, ItemStack var2);

    public InventoryContents updateItem(int var1, int var2, ItemStack var3);

    public InventoryContents updateItem(SlotPos var1, ItemStack var2);

    public Optional<SlotPos> findItem(ItemStack var1);

    public Optional<SlotPos> findItem(ClickableItem var1);

    public InventoryContents fill(ClickableItem var1);

    public InventoryContents fillRow(int var1, ClickableItem var2);

    public InventoryContents fillColumn(int var1, ClickableItem var2);

    public InventoryContents fillBorders(ClickableItem var1);

    public InventoryContents fillRect(int var1, int var2, ClickableItem var3);

    public InventoryContents fillRect(int var1, int var2, int var3, int var4, ClickableItem var5);

    public InventoryContents fillRect(SlotPos var1, SlotPos var2, ClickableItem var3);

    public InventoryContents fillSquare(int var1, int var2, ClickableItem var3);

    public InventoryContents fillSquare(int var1, int var2, int var3, int var4, ClickableItem var5);

    public InventoryContents fillSquare(SlotPos var1, SlotPos var2, ClickableItem var3);

    public InventoryContents fillPattern(Pattern<ClickableItem> var1);

    public InventoryContents fillPattern(Pattern<ClickableItem> var1, int var2);

    public InventoryContents fillPattern(Pattern<ClickableItem> var1, int var2, int var3);

    public InventoryContents fillPattern(Pattern<ClickableItem> var1, SlotPos var2);

    public InventoryContents fillPatternRepeating(Pattern<ClickableItem> var1);

    public InventoryContents fillPatternRepeating(Pattern<ClickableItem> var1, int var2, int var3);

    public InventoryContents fillPatternRepeating(Pattern<ClickableItem> var1, int var2, int var3, int var4, int var5);

    public InventoryContents fillPatternRepeating(Pattern<ClickableItem> var1, SlotPos var2, SlotPos var3);

    public <T> T property(String var1);

    public <T> T property(String var1, T var2);

    public InventoryContents setProperty(String var1, Object var2);

    public void setEditable(SlotPos var1, boolean var2);

    public boolean isEditable(SlotPos var1);

    public static class Impl
    implements InventoryContents {
        private final SmartInventory inv;
        private final UUID player;
        private final ClickableItem[][] contents;
        private Pagination pagination = new Pagination.Impl();
        private Map<String, SlotIterator> iterators = new HashMap<String, SlotIterator>();
        private Map<String, Object> properties = new HashMap<String, Object>();
        private Set<SlotPos> editableSlots = new HashSet<SlotPos>();

        public Impl(SmartInventory inv, UUID player) {
            this.inv = inv;
            this.player = player;
            this.contents = new ClickableItem[inv.getRows()][inv.getColumns()];
        }

        @Override
        public SmartInventory inventory() {
            return this.inv;
        }

        @Override
        public Pagination pagination() {
            return this.pagination;
        }

        @Override
        public Optional<SlotIterator> iterator(String id) {
            return Optional.ofNullable(this.iterators.get(id));
        }

        @Override
        public SlotIterator newIterator(String id, SlotIterator.Type type, int startRow, int startColumn) {
            SlotIterator.Impl iterator = new SlotIterator.Impl(this, this.inv, type, startRow, startColumn);
            this.iterators.put(id, iterator);
            return iterator;
        }

        @Override
        public SlotIterator newIterator(String id, SlotIterator.Type type, SlotPos startPos) {
            return this.newIterator(id, type, startPos.getRow(), startPos.getColumn());
        }

        @Override
        public SlotIterator newIterator(SlotIterator.Type type, int startRow, int startColumn) {
            return new SlotIterator.Impl(this, this.inv, type, startRow, startColumn);
        }

        @Override
        public SlotIterator newIterator(SlotIterator.Type type, SlotPos startPos) {
            return this.newIterator(type, startPos.getRow(), startPos.getColumn());
        }

        @Override
        public ClickableItem[][] all() {
            return this.contents;
        }

        @Override
        public List<SlotPos> slots() {
            ArrayList<SlotPos> slotPos = new ArrayList<SlotPos>();
            for (int row = 0; row < this.contents.length; ++row) {
                for (int column = 0; column < this.contents[0].length; ++column) {
                    slotPos.add(SlotPos.of(row, column));
                }
            }
            return slotPos;
        }

        @Override
        public Optional<SlotPos> firstEmpty() {
            for (int row = 0; row < this.contents.length; ++row) {
                for (int column = 0; column < this.contents[0].length; ++column) {
                    if (this.get(row, column).isPresent()) continue;
                    return Optional.of(new SlotPos(row, column));
                }
            }
            return Optional.empty();
        }

        @Override
        public Optional<ClickableItem> get(int index) {
            int columnCount = this.inv.getColumns();
            return this.get(index / columnCount, index % columnCount);
        }

        @Override
        public Optional<ClickableItem> get(int row, int column) {
            if (row < 0 || row >= this.contents.length) {
                return Optional.empty();
            }
            if (column < 0 || column >= this.contents[row].length) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.contents[row][column]);
        }

        @Override
        public Optional<ClickableItem> get(SlotPos slotPos) {
            return this.get(slotPos.getRow(), slotPos.getColumn());
        }

        @Override
        public InventoryContents applyRect(int fromRow, int fromColumn, int toRow, int toColumn, BiConsumer<Integer, Integer> apply) {
            for (int row = fromRow; row <= toRow; ++row) {
                for (int column = fromColumn; column <= toColumn; ++column) {
                    apply.accept(row, column);
                }
            }
            return this;
        }

        @Override
        public InventoryContents applyRect(int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickableItem> apply) {
            this.applyRect(fromRow, fromColumn, toRow, toColumn, (Integer row, Integer column) -> this.get((int)row, (int)column).ifPresent(apply));
            return this;
        }

        @Override
        public InventoryContents set(int index, ClickableItem item) {
            int columnCount = this.inv.getColumns();
            return this.set(index / columnCount, index % columnCount, item);
        }

        @Override
        public InventoryContents set(int row, int column, ClickableItem item) {
            Player bukkitPlayer;
            if (row < 0 || row >= this.contents.length) {
                return this;
            }
            if (column < 0 || column >= this.contents[row].length) {
                return this;
            }
            this.contents[row][column] = item;
            if (this.player != null && (bukkitPlayer = Bukkit.getPlayer((UUID)this.player)) != null) {
                this.update(row, column, item == null ? null : item.getItem(bukkitPlayer));
            }
            return this;
        }

        @Override
        public InventoryContents set(SlotPos slotPos, ClickableItem item) {
            return this.set(slotPos.getRow(), slotPos.getColumn(), item);
        }

        @Override
        public InventoryContents add(ClickableItem item) {
            for (int row = 0; row < this.contents.length; ++row) {
                for (int column = 0; column < this.contents[0].length; ++column) {
                    if (this.contents[row][column] != null) continue;
                    this.set(row, column, item);
                    return this;
                }
            }
            return this;
        }

        @Override
        public InventoryContents updateItem(int index, ItemStack itemStack) {
            int columnCount = this.inv.getColumns();
            return this.updateItem(index / columnCount, index % columnCount, itemStack);
        }

        @Override
        public InventoryContents updateItem(int row, int column, ItemStack itemStack) {
            Optional<ClickableItem> optional = this.get(row, column);
            if (!optional.isPresent()) {
                this.set(row, column, ClickableItem.empty(itemStack));
                return this;
            }
            ClickableItem newClickableItem = optional.get().cloneWithNewItem(itemStack);
            this.set(row, column, newClickableItem);
            return this;
        }

        @Override
        public InventoryContents updateItem(SlotPos slotPos, ItemStack itemStack) {
            return this.updateItem(slotPos.getRow(), slotPos.getColumn(), itemStack);
        }

        @Override
        public Optional<SlotPos> findItem(ItemStack itemStack) {
            Preconditions.checkNotNull((Object)itemStack, (Object)"The itemstack to look for cannot be null!");
            Player bukkitPlayer = Bukkit.getPlayer((UUID)this.player);
            if (bukkitPlayer != null) {
                for (int row = 0; row < this.contents.length; ++row) {
                    for (int column = 0; column < this.contents[0].length; ++column) {
                        if (this.contents[row][column] == null || !itemStack.isSimilar(this.contents[row][column].getItem(bukkitPlayer))) continue;
                        return Optional.of(SlotPos.of(row, column));
                    }
                }
            }
            return Optional.empty();
        }

        @Override
        public Optional<SlotPos> findItem(ClickableItem clickableItem) {
            Preconditions.checkNotNull((Object)clickableItem, (Object)"The clickable item to look for cannot be null!");
            Player bukkitPlayer = Bukkit.getPlayer((UUID)this.player);
            return bukkitPlayer != null ? this.findItem(clickableItem.getItem(bukkitPlayer)) : Optional.empty();
        }

        @Override
        public InventoryContents fill(ClickableItem item) {
            for (int row = 0; row < this.contents.length; ++row) {
                for (int column = 0; column < this.contents[row].length; ++column) {
                    this.set(row, column, item);
                }
            }
            return this;
        }

        @Override
        public InventoryContents fillRow(int row, ClickableItem item) {
            if (row < 0 || row >= this.contents.length) {
                return this;
            }
            for (int column = 0; column < this.contents[row].length; ++column) {
                this.set(row, column, item);
            }
            return this;
        }

        @Override
        public InventoryContents fillColumn(int column, ClickableItem item) {
            if (column < 0 || column >= this.contents[0].length) {
                return this;
            }
            for (int row = 0; row < this.contents.length; ++row) {
                this.set(row, column, item);
            }
            return this;
        }

        @Override
        public InventoryContents fillBorders(ClickableItem item) {
            this.fillRect(0, 0, this.inv.getRows() - 1, this.inv.getColumns() - 1, item);
            return this;
        }

        @Override
        public InventoryContents fillRect(int fromIndex, int toIndex, ClickableItem item) {
            int columnCount = this.inv.getColumns();
            return this.fillRect(fromIndex / columnCount, fromIndex % columnCount, toIndex / columnCount, toIndex % columnCount, item);
        }

        @Override
        public InventoryContents fillRect(int fromRow, int fromColumn, int toRow, int toColumn, ClickableItem item) {
            this.applyRect(fromRow, fromColumn, toRow, toColumn, (Integer row, Integer column) -> {
                if (row != fromRow && row != toRow && column != fromColumn && column != toColumn) {
                    return;
                }
                this.set((int)row, (int)column, item);
            });
            return this;
        }

        @Override
        public InventoryContents fillRect(SlotPos fromPos, SlotPos toPos, ClickableItem item) {
            return this.fillRect(fromPos.getRow(), fromPos.getColumn(), toPos.getRow(), toPos.getColumn(), item);
        }

        @Override
        public InventoryContents fillSquare(int fromIndex, int toIndex, ClickableItem item) {
            int columnCount = this.inv.getColumns();
            return this.fillSquare(fromIndex / columnCount, fromIndex % columnCount, toIndex / columnCount, toIndex % columnCount, item);
        }

        @Override
        public InventoryContents fillSquare(int fromRow, int fromColumn, int toRow, int toColumn, ClickableItem item) {
            Preconditions.checkArgument((fromRow < toRow ? 1 : 0) != 0, (Object)"The start row needs to be lower than the end row");
            Preconditions.checkArgument((fromColumn < toColumn ? 1 : 0) != 0, (Object)"The start column needs to be lower than the end column");
            for (int row = fromRow; row <= toRow; ++row) {
                for (int column = fromColumn; column <= toColumn; ++column) {
                    this.set(row, column, item);
                }
            }
            return this;
        }

        @Override
        public InventoryContents fillSquare(SlotPos fromPos, SlotPos toPos, ClickableItem item) {
            return this.fillSquare(fromPos.getRow(), fromPos.getColumn(), toPos.getRow(), toPos.getColumn(), item);
        }

        @Override
        public InventoryContents fillPattern(Pattern<ClickableItem> pattern) {
            return this.fillPattern(pattern, 0, 0);
        }

        @Override
        public InventoryContents fillPattern(Pattern<ClickableItem> pattern, int startIndex) {
            int columnCount = this.inv.getColumns();
            return this.fillPattern(pattern, startIndex / columnCount, startIndex % columnCount);
        }

        @Override
        public InventoryContents fillPattern(Pattern<ClickableItem> pattern, SlotPos startPos) {
            return this.fillPattern(pattern, startPos.getRow(), startPos.getColumn());
        }

        @Override
        public InventoryContents fillPatternRepeating(Pattern<ClickableItem> pattern) {
            return this.fillPatternRepeating(pattern, 0, 0, -1, -1);
        }

        @Override
        public InventoryContents fillPatternRepeating(Pattern<ClickableItem> pattern, int startIndex, int endIndex) {
            int columnCount = this.inv.getColumns();
            boolean maxSize = endIndex < 0;
            return this.fillPatternRepeating(pattern, startIndex / columnCount, startIndex % columnCount, maxSize ? -1 : endIndex / columnCount, maxSize ? -1 : endIndex % columnCount);
        }

        @Override
        public InventoryContents fillPatternRepeating(Pattern<ClickableItem> pattern, int startRow, int startColumn, int endRow, int endColumn) {
            Preconditions.checkArgument((boolean)pattern.isWrapAround(), (Object)"To fill in a repeating pattern wrapAround needs to be enabled for the pattern to work!");
            if (endRow < 0) {
                endRow = this.inv.getRows();
            }
            if (endColumn < 0) {
                endColumn = this.inv.getColumns();
            }
            Preconditions.checkArgument((startRow < endRow ? 1 : 0) != 0, (Object)"The start row needs to be lower than the end row");
            Preconditions.checkArgument((startColumn < endColumn ? 1 : 0) != 0, (Object)"The start column needs to be lower than the end column");
            int rowDelta = endRow - startRow;
            int columnDelta = endColumn - startColumn;
            for (int row = 0; row <= rowDelta; ++row) {
                for (int column = 0; column <= columnDelta; ++column) {
                    ClickableItem item = pattern.getObject(row, column);
                    if (item == null) continue;
                    this.set(startRow + row, startColumn + column, item);
                }
            }
            return this;
        }

        @Override
        public InventoryContents fillPatternRepeating(Pattern<ClickableItem> pattern, SlotPos startPos, SlotPos endPos) {
            return this.fillPatternRepeating(pattern, startPos.getRow(), startPos.getColumn(), endPos.getRow(), endPos.getColumn());
        }

        @Override
        public InventoryContents fillPattern(Pattern<ClickableItem> pattern, int startRow, int startColumn) {
            for (int row = 0; row < pattern.getRowCount(); ++row) {
                for (int column = 0; column < pattern.getColumnCount(); ++column) {
                    ClickableItem item = pattern.getObject(row, column);
                    if (item == null) continue;
                    this.set(startRow + row, startColumn + column, item);
                }
            }
            return this;
        }

        @Override
        public <T> T property(String name) {
            return (T)this.properties.get(name);
        }

        @Override
        public <T> T property(String name, T def) {
            return (T)(this.properties.containsKey(name) ? this.properties.get(name) : def);
        }

        @Override
        public InventoryContents setProperty(String name, Object value) {
            this.properties.put(name, value);
            return this;
        }

        private void update(int row, int column, ItemStack item) {
            Player currentPlayer = Bukkit.getPlayer((UUID)this.player);
            if (!this.inv.getManager().getOpenedPlayers(this.inv).contains(currentPlayer)) {
                return;
            }
            Inventory topInventory = currentPlayer.getOpenInventory().getTopInventory();
            topInventory.setItem(this.inv.getColumns() * row + column, item);
        }

        @Override
        public void setEditable(SlotPos slot, boolean editable) {
            if (editable) {
                this.editableSlots.add(slot);
            } else {
                this.editableSlots.remove(slot);
            }
        }

        @Override
        public boolean isEditable(SlotPos slot) {
            return this.editableSlots.contains(slot);
        }
    }
}

