/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.inv;

import com.google.common.base.Preconditions;
import dev.aurelium.auraskills.slate.inv.InventoryListener;
import dev.aurelium.auraskills.slate.inv.InventoryManager;
import dev.aurelium.auraskills.slate.inv.SmartInvsPlugin;
import dev.aurelium.auraskills.slate.inv.content.InventoryContents;
import dev.aurelium.auraskills.slate.inv.content.InventoryProvider;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.inv.opener.InventoryOpener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class SmartInventory {
    private String id;
    private String title;
    private InventoryType type;
    private int rows;
    private int columns;
    private boolean closeable;
    private int updateFrequency;
    private InventoryProvider provider;
    private SmartInventory parent;
    private List<InventoryListener<? extends Event>> listeners;
    private final InventoryManager manager;

    private SmartInventory(InventoryManager manager) {
        this.manager = manager;
    }

    public Inventory open(Player player) {
        return this.open(player, 0, Collections.EMPTY_MAP);
    }

    public Inventory open(Player player, int page) {
        return this.open(player, page, Collections.EMPTY_MAP);
    }

    public Inventory open(Player player, Map<String, Object> properties) {
        return this.open(player, 0, properties);
    }

    public Inventory open(Player player, int page, Map<String, Object> properties) {
        Optional<SmartInventory> oldInv = this.manager.getInventory(player);
        oldInv.ifPresent(inv -> {
            inv.getListeners().stream().filter(listener -> listener.getType() == InventoryCloseEvent.class).forEach(listener -> listener.accept(new InventoryCloseEvent(player.getOpenInventory())));
            this.manager.setInventory(player, null);
        });
        InventoryContents.Impl contents = new InventoryContents.Impl(this, player.getUniqueId());
        contents.pagination().page(page);
        properties.forEach(contents::setProperty);
        this.manager.setContents(player, contents);
        try {
            this.provider.init(player, contents);
            if (!this.manager.getContents(player).equals(Optional.of(contents))) {
                return null;
            }
            InventoryOpener opener = this.manager.findOpener(this.type).orElseThrow(() -> new IllegalStateException("No opener found for the inventory type " + this.type.name()));
            Inventory handle = opener.open(this, player);
            this.manager.setInventory(player, this);
            this.manager.scheduleUpdateTask(player, this);
            return handle;
        }
        catch (Exception e) {
            this.manager.handleInventoryOpenError(this, player, e);
            return null;
        }
    }

    public void close(Player player) {
        this.listeners.stream().filter(listener -> listener.getType() == InventoryCloseEvent.class).forEach(listener -> listener.accept(new InventoryCloseEvent(player.getOpenInventory())));
        this.manager.setInventory(player, null);
        player.closeInventory();
        this.manager.setContents(player, null);
        this.manager.cancelUpdateTask(player);
    }

    public boolean checkBounds(int row, int col) {
        if (row < 0 || col < 0) {
            return false;
        }
        return row < this.rows && col < this.columns;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public InventoryType getType() {
        return this.type;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    public int getUpdateFrequency() {
        return this.updateFrequency;
    }

    public InventoryProvider getProvider() {
        return this.provider;
    }

    public Optional<SmartInventory> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public InventoryManager getManager() {
        return this.manager;
    }

    List<InventoryListener<? extends Event>> getListeners() {
        return this.listeners;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id = "unknown";
        private String title = "";
        private InventoryType type = InventoryType.CHEST;
        private Optional<Integer> rows = Optional.empty();
        private Optional<Integer> columns = Optional.empty();
        private boolean closeable = true;
        private int updateFrequency = 1;
        private InventoryManager manager;
        private InventoryProvider provider;
        private SmartInventory parent;
        private List<InventoryListener<? extends Event>> listeners = new ArrayList<InventoryListener<? extends Event>>();

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder type(InventoryType type) {
            this.type = type;
            return this;
        }

        public Builder size(int rows, int columns) {
            this.rows = Optional.of(rows);
            this.columns = Optional.of(columns);
            return this;
        }

        public Builder closeable(boolean closeable) {
            this.closeable = closeable;
            return this;
        }

        public Builder updateFrequency(int frequency) {
            Preconditions.checkArgument((frequency > 0 ? 1 : 0) != 0, (Object)"frequency must be > 0");
            this.updateFrequency = frequency;
            return this;
        }

        public Builder provider(InventoryProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder parent(SmartInventory parent) {
            this.parent = parent;
            return this;
        }

        public Builder listener(InventoryListener<? extends Event> listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder manager(InventoryManager manager) {
            this.manager = manager;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public InventoryType getType() {
            return this.type;
        }

        public Optional<Integer> getRows() {
            return this.rows;
        }

        public Optional<Integer> getColumns() {
            return this.columns;
        }

        public boolean isCloseable() {
            return this.closeable;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public InventoryManager getManager() {
            return this.manager;
        }

        public InventoryProvider getProvider() {
            return this.provider;
        }

        public SmartInventory getParent() {
            return this.parent;
        }

        public List<InventoryListener<? extends Event>> getListeners() {
            return Collections.unmodifiableList(this.listeners);
        }

        public SmartInventory build() {
            if (this.provider == null) {
                throw new IllegalStateException("The provider of the SmartInventory.Builder must be set.");
            }
            if (this.manager == null) {
                this.manager = SmartInvsPlugin.manager();
                if (this.manager == null) {
                    throw new IllegalStateException("Manager of the SmartInventory.Builder must be set, or SmartInvs should be loaded as a plugin.");
                }
            }
            SmartInventory inv = new SmartInventory(this.manager);
            inv.id = this.id;
            inv.title = this.title;
            inv.type = this.type;
            inv.rows = this.rows.orElseGet(() -> this.getDefaultDimensions(this.type).getRow());
            inv.columns = this.columns.orElseGet(() -> this.getDefaultDimensions(this.type).getColumn());
            inv.closeable = this.closeable;
            inv.updateFrequency = this.updateFrequency;
            inv.provider = this.provider;
            inv.parent = this.parent;
            inv.listeners = this.listeners;
            return inv;
        }

        private SlotPos getDefaultDimensions(InventoryType type) {
            InventoryOpener opener = this.manager.findOpener(type).orElse(null);
            if (opener == null) {
                throw new IllegalStateException("Cannot find InventoryOpener for type " + type);
            }
            SlotPos size = opener.defaultSize(type);
            if (size == null) {
                throw new IllegalStateException(String.format("%s returned null for input InventoryType %s", opener.getClass().getSimpleName(), type));
            }
            return size;
        }
    }
}

