/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.inv;

import dev.aurelium.auraskills.slate.inv.ItemClickData;
import dev.aurelium.auraskills.slate.inv.SmartInventory;
import dev.aurelium.auraskills.slate.inv.content.InventoryContents;
import dev.aurelium.auraskills.slate.inv.content.InventoryProvider;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import dev.aurelium.auraskills.slate.inv.opener.ChestInventoryOpener;
import dev.aurelium.auraskills.slate.inv.opener.InventoryOpener;
import dev.aurelium.auraskills.slate.inv.opener.SpecialInventoryOpener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InventoryManager {
    private final JavaPlugin plugin;
    private final PluginManager pluginManager;
    private final Map<UUID, SmartInventory> inventories;
    private final Map<UUID, InventoryContents> contents;
    private final Map<UUID, BukkitRunnable> updateTasks;
    private final List<InventoryOpener> defaultOpeners;
    private final List<InventoryOpener> openers;

    public InventoryManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.pluginManager = Bukkit.getPluginManager();
        this.inventories = new HashMap<UUID, SmartInventory>();
        this.contents = new HashMap<UUID, InventoryContents>();
        this.updateTasks = new HashMap<UUID, BukkitRunnable>();
        this.defaultOpeners = Arrays.asList(new ChestInventoryOpener(), new SpecialInventoryOpener());
        this.openers = new ArrayList<InventoryOpener>();
    }

    public void init() {
        this.pluginManager.registerEvents((Listener)new InvListener(), (Plugin)this.plugin);
    }

    public Optional<InventoryOpener> findOpener(InventoryType type) {
        Optional<InventoryOpener> opInv = this.openers.stream().filter(opener -> opener.supports(type)).findAny();
        if (!opInv.isPresent()) {
            opInv = this.defaultOpeners.stream().filter(opener -> opener.supports(type)).findAny();
        }
        return opInv;
    }

    public void registerOpeners(InventoryOpener ... openers) {
        this.openers.addAll(Arrays.asList(openers));
    }

    public List<Player> getOpenedPlayers(SmartInventory inv) {
        ArrayList<Player> list = new ArrayList<Player>();
        this.inventories.forEach((player, playerInv) -> {
            if (inv.equals(playerInv)) {
                list.add(Bukkit.getPlayer((UUID)player));
            }
        });
        return list;
    }

    public Optional<SmartInventory> getInventory(Player p) {
        return Optional.ofNullable(this.inventories.get(p.getUniqueId()));
    }

    protected void setInventory(Player p, SmartInventory inv) {
        if (inv == null) {
            this.inventories.remove(p.getUniqueId());
        } else {
            this.inventories.put(p.getUniqueId(), inv);
        }
    }

    public Optional<InventoryContents> getContents(Player p) {
        return Optional.ofNullable(this.contents.get(p.getUniqueId()));
    }

    protected void setContents(Player p, InventoryContents contents) {
        if (contents == null) {
            this.contents.remove(p.getUniqueId());
        } else {
            this.contents.put(p.getUniqueId(), contents);
        }
    }

    public void handleInventoryOpenError(SmartInventory inventory, Player player, Exception exception) {
        inventory.close(player);
        Bukkit.getLogger().log(Level.SEVERE, "Error while opening SmartInventory:", exception);
    }

    public void handleInventoryUpdateError(SmartInventory inventory, Player player, Exception exception) {
        inventory.close(player);
        Bukkit.getLogger().log(Level.SEVERE, "Error while updating SmartInventory:", exception);
    }

    protected void scheduleUpdateTask(Player p, SmartInventory inv) {
        PlayerInvTask task = new PlayerInvTask(p, inv.getProvider(), this.contents.get(p.getUniqueId()));
        task.runTaskTimer((Plugin)this.plugin, 1L, inv.getUpdateFrequency());
        this.updateTasks.put(p.getUniqueId(), task);
    }

    protected void cancelUpdateTask(Player p) {
        if (this.updateTasks.containsKey(p.getUniqueId())) {
            int bukkitTaskId = this.updateTasks.get(p.getUniqueId()).getTaskId();
            Bukkit.getScheduler().cancelTask(bukkitTaskId);
            this.updateTasks.remove(p.getUniqueId());
        }
    }

    class InvListener
    implements Listener {
        InvListener() {
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onInventoryClick(InventoryClickEvent e) {
            Player p = (Player)e.getWhoClicked();
            SmartInventory inv = InventoryManager.this.inventories.get(p.getUniqueId());
            if (inv == null) {
                return;
            }
            Inventory clickedInventory = e.getClickedInventory();
            if (clickedInventory == p.getOpenInventory().getBottomInventory()) {
                if (e.getAction() == InventoryAction.COLLECT_TO_CURSOR || e.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                    e.setCancelled(true);
                    return;
                }
                if (e.getAction() == InventoryAction.NOTHING && e.getClick() != ClickType.MIDDLE) {
                    e.setCancelled(true);
                    return;
                }
            }
            if (clickedInventory == p.getOpenInventory().getTopInventory()) {
                SlotPos slot;
                e.setCancelled(true);
                int row = e.getSlot() / 9;
                int column = e.getSlot() % 9;
                if (!inv.checkBounds(row, column)) {
                    return;
                }
                InventoryContents invContents = InventoryManager.this.contents.get(p.getUniqueId());
                if (!invContents.isEditable(slot = SlotPos.of(row, column))) {
                    e.setCancelled(true);
                }
                inv.getListeners().stream().filter(listener -> listener.getType() == InventoryClickEvent.class).forEach(listener -> listener.accept(e));
                invContents.get(slot).ifPresent(item -> item.run(new ItemClickData((Event)e, p, e.getCurrentItem(), slot)));
                if (!invContents.isEditable(slot)) {
                    p.updateInventory();
                }
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onInventoryDrag(InventoryDragEvent e) {
            Player p = (Player)e.getWhoClicked();
            if (!InventoryManager.this.inventories.containsKey(p.getUniqueId())) {
                return;
            }
            SmartInventory inv = InventoryManager.this.inventories.get(p.getUniqueId());
            InventoryContents content = InventoryManager.this.contents.get(p.getUniqueId());
            Iterator iterator = e.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                SlotPos pos = SlotPos.of(slot / 9, slot % 9);
                if (slot >= p.getOpenInventory().getTopInventory().getSize() || content.isEditable(pos)) continue;
                e.setCancelled(true);
                break;
            }
            inv.getListeners().stream().filter(listener -> listener.getType() == InventoryDragEvent.class).forEach(listener -> listener.accept(e));
        }

        @EventHandler(priority=EventPriority.LOW)
        public void onInventoryOpen(InventoryOpenEvent e) {
            Player p = (Player)e.getPlayer();
            if (!InventoryManager.this.inventories.containsKey(p.getUniqueId())) {
                return;
            }
            SmartInventory inv = InventoryManager.this.inventories.get(p.getUniqueId());
            inv.getListeners().stream().filter(listener -> listener.getType() == InventoryOpenEvent.class).forEach(listener -> listener.accept(e));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @EventHandler(priority=EventPriority.LOW)
        public void onInventoryClose(InventoryCloseEvent e) {
            Player p = (Player)e.getPlayer();
            if (!InventoryManager.this.inventories.containsKey(p.getUniqueId())) {
                return;
            }
            SmartInventory inv = InventoryManager.this.inventories.get(p.getUniqueId());
            try {
                inv.getListeners().stream().filter(listener -> listener.getType() == InventoryCloseEvent.class).forEach(listener -> listener.accept(e));
            }
            finally {
                if (inv.isCloseable()) {
                    e.getInventory().clear();
                    InventoryManager.this.cancelUpdateTask(p);
                    InventoryManager.this.inventories.remove(p.getUniqueId());
                    InventoryManager.this.contents.remove(p.getUniqueId());
                } else {
                    Bukkit.getScheduler().runTask((Plugin)InventoryManager.this.plugin, () -> p.openInventory(e.getInventory()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @EventHandler(priority=EventPriority.LOW)
        public void onPlayerQuit(PlayerQuitEvent e) {
            Player p = e.getPlayer();
            if (!InventoryManager.this.inventories.containsKey(p.getUniqueId())) {
                return;
            }
            SmartInventory inv = InventoryManager.this.inventories.get(p.getUniqueId());
            try {
                inv.getListeners().stream().filter(listener -> listener.getType() == PlayerQuitEvent.class).forEach(listener -> listener.accept(e));
            }
            finally {
                InventoryManager.this.inventories.remove(p.getUniqueId());
                InventoryManager.this.contents.remove(p.getUniqueId());
                p.updateInventory();
            }
        }

        @EventHandler(priority=EventPriority.LOW)
        public void onPluginDisable(PluginDisableEvent e) {
            new HashMap<UUID, SmartInventory>(InventoryManager.this.inventories).forEach((player, inv) -> {
                try {
                    inv.getListeners().stream().filter(listener -> listener.getType() == PluginDisableEvent.class).forEach(listener -> listener.accept(e));
                }
                finally {
                    inv.close(Bukkit.getPlayer((UUID)player));
                }
            });
            InventoryManager.this.inventories.clear();
            InventoryManager.this.contents.clear();
        }
    }

    class PlayerInvTask
    extends BukkitRunnable {
        private Player player;
        private InventoryProvider provider;
        private InventoryContents contents;

        public PlayerInvTask(Player player, InventoryProvider provider, InventoryContents contents) {
            this.player = Objects.requireNonNull(player);
            this.provider = Objects.requireNonNull(provider);
            this.contents = Objects.requireNonNull(contents);
        }

        public void run() {
            this.provider.update(this.player, this.contents);
        }
    }

    class InvTask
    extends BukkitRunnable {
        InvTask() {
        }

        public void run() {
            new HashMap<UUID, SmartInventory>(InventoryManager.this.inventories).forEach((uuid, inv) -> {
                Player player = Bukkit.getPlayer((UUID)uuid);
                try {
                    inv.getProvider().update(player, InventoryManager.this.contents.get(uuid));
                }
                catch (Exception e) {
                    InventoryManager.this.handleInventoryUpdateError((SmartInventory)inv, player, e);
                }
            });
        }
    }
}

