/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.builder;

import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.builder.GlobalBehaviorBuilder;
import dev.aurelium.auraskills.slate.function.ItemReplacer;
import dev.aurelium.auraskills.slate.function.LocaleProvider;
import dev.aurelium.auraskills.slate.info.PlaceholderInfo;
import dev.aurelium.auraskills.slate.item.provider.PlaceholderData;
import dev.aurelium.auraskills.slate.item.provider.PlaceholderType;
import dev.aurelium.auraskills.slate.lore.ListData;
import dev.aurelium.auraskills.slate.lore.LoreInterpreter;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import dev.aurelium.auraskills.slate.util.LoreUtil;
import dev.aurelium.auraskills.slate.util.Pair;
import dev.aurelium.auraskills.slate.util.TextUtil;
import java.util.Set;
import org.bukkit.entity.Player;

public record GlobalBehavior(Set<ItemReplacer> globalReplacers, LocaleProvider localeProvider) {
    public static GlobalBehaviorBuilder builder() {
        return GlobalBehaviorBuilder.builder();
    }

    public String applyGlobalReplacers(String input, Slate slate, Player player, ActiveMenu activeMenu, PlaceholderType type) {
        String[] placeholders = TextUtil.substringsBetween(input, "{", "}");
        if (placeholders != null) {
            String style = LoreUtil.getStyle(input);
            for (String placeholder : placeholders) {
                Pair<String, ListData> pair = LoreInterpreter.detectListPlaceholder(placeholder);
                PlaceholderData data = new PlaceholderData(type, style, pair.second());
                for (ItemReplacer replacer : this.globalReplacers) {
                    String replaced = replacer.replace(new PlaceholderInfo(slate, player, pair.first(), activeMenu, data));
                    if (replaced == null) continue;
                    input = TextUtil.replace(input, "{" + placeholder + "}", replaced);
                }
            }
        }
        return input;
    }
}

