/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.slate.builder;

import dev.aurelium.auraskills.slate.Slate;
import dev.aurelium.auraskills.slate.builder.BuiltComponent;
import dev.aurelium.auraskills.slate.builder.BuiltItem;
import dev.aurelium.auraskills.slate.builder.BuiltTemplate;
import dev.aurelium.auraskills.slate.function.ItemModifier;
import dev.aurelium.auraskills.slate.function.ItemReplacer;
import dev.aurelium.auraskills.slate.function.MenuListener;
import dev.aurelium.auraskills.slate.function.PageProvider;
import dev.aurelium.auraskills.slate.function.PropertyProvider;
import dev.aurelium.auraskills.slate.info.PlaceholderInfo;
import dev.aurelium.auraskills.slate.item.provider.PlaceholderData;
import dev.aurelium.auraskills.slate.item.provider.PlaceholderType;
import dev.aurelium.auraskills.slate.menu.ActiveMenu;
import dev.aurelium.auraskills.slate.util.LoreUtil;
import dev.aurelium.auraskills.slate.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public record BuiltMenu(Map<String, BuiltItem> items, Map<String, BuiltTemplate<?>> templates, Map<String, BuiltComponent<?>> components, Map<String, ItemReplacer> titleReplacers, ItemReplacer titleAnyReplacer, PageProvider pageProvider, PropertyProvider propertyProvider, ItemModifier fillItem, MenuListener openListener, MenuListener updateListener, Map<String, Object> defaultOptions) {
    public static BuiltMenu createEmpty() {
        return new BuiltMenu(new HashMap<String, BuiltItem>(), new HashMap(), new HashMap(), new HashMap<String, ItemReplacer>(), p -> null, m -> 1, m -> new HashMap(), i -> null, m -> {}, m -> {}, new HashMap<String, Object>());
    }

    @NotNull
    public BuiltItem getBackingItem(String name) {
        String backingName;
        BuiltItem backing;
        BuiltItem direct = this.items.get(name);
        if (direct != null) {
            return direct;
        }
        if (this.isDuplicateItemName(name) && (backing = this.items.get(backingName = name.substring(0, name.lastIndexOf("(")))) != null) {
            return backing;
        }
        return BuiltItem.createEmpty();
    }

    public <T> BuiltTemplate<T> getTemplate(String name, Class<T> contextType) {
        BuiltTemplate<?> template = this.templates.get(name);
        if (template != null && template.contextType().equals(contextType)) {
            return template;
        }
        return BuiltTemplate.createEmpty(contextType);
    }

    public <T> BuiltComponent<T> getComponent(String name, Class<T> contextType) {
        BuiltComponent<?> component = this.components.get(name);
        if (component != null && component.contextType().equals(contextType)) {
            return component;
        }
        return BuiltComponent.createEmpty(contextType);
    }

    public String applyTitleReplacers(String input, Slate slate, Player player, ActiveMenu activeMenu) {
        PlaceholderType type = PlaceholderType.TITLE;
        input = slate.getGlobalBehavior().applyGlobalReplacers(input, slate, player, activeMenu, type);
        for (Map.Entry<String, ItemReplacer> entry : this.titleReplacers.entrySet()) {
            String placeholder = entry.getKey();
            PlaceholderData data = new PlaceholderData(type, LoreUtil.getStyle(input), null);
            String replaced = entry.getValue().replace(new PlaceholderInfo(slate, player, placeholder, activeMenu, data));
            if (replaced == null) continue;
            input = TextUtil.replace(input, "{" + placeholder + "}", replaced);
        }
        String[] placeholders = TextUtil.substringsBetween(input, "{", "}");
        if (placeholders != null) {
            PlaceholderData data = new PlaceholderData(type, LoreUtil.getStyle(input), null);
            for (String placeholder : placeholders) {
                String replaced = this.titleAnyReplacer.replace(new PlaceholderInfo(slate, player, placeholder, activeMenu, data));
                if (replaced == null) continue;
                input = TextUtil.replace(input, "{" + placeholder + "}", replaced);
            }
        }
        return input;
    }

    private boolean isDuplicateItemName(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        int len = str.length();
        int i = len - 1;
        if (str.charAt(i) != ')') {
            return false;
        }
        if (--i < 0 || !Character.isDigit(str.charAt(i))) {
            return false;
        }
        while (i >= 0 && Character.isDigit(str.charAt(i))) {
            --i;
        }
        return i >= 0 && str.charAt(i) == '(';
    }
}

