/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.util.text;

import dev.aurelium.auraskills.common.util.text.Replacer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class TextUtil {
    public static String replace(String source, String os, String ns) {
        if (source == null) {
            return null;
        }
        int i = 0;
        if ((i = source.indexOf(os, i)) >= 0) {
            char[] sourceArray = source.toCharArray();
            char[] nsArray = ns.toCharArray();
            int oLength = os.length();
            StringBuilder buf = new StringBuilder(sourceArray.length);
            buf.append(sourceArray, 0, i).append(nsArray);
            int j = i += oLength;
            while ((i = source.indexOf(os, i)) > 0) {
                buf.append(sourceArray, j, i - j).append(nsArray);
                j = i += oLength;
            }
            buf.append(sourceArray, j, sourceArray.length - j);
            source = buf.toString();
            buf.setLength(0);
        }
        return source;
    }

    public static String replace(String source, String ... rep) {
        if (source == null) {
            return null;
        }
        if (rep.length % 2 != 0) {
            throw new IllegalArgumentException("The number of arguments must be even!");
        }
        for (int i = 0; i < rep.length; i += 2) {
            source = TextUtil.replace(source, rep[i], rep[i + 1]);
        }
        return source;
    }

    public static String replace(String source, String os1, String ns1, String os2, String ns2) {
        return TextUtil.replace(TextUtil.replace(source, os1, ns1), os2, ns2);
    }

    public static String replace(String source, String os1, String ns1, String os2, String ns2, String os3, String ns3) {
        return TextUtil.replace(TextUtil.replace(TextUtil.replace(source, os1, ns1), os2, ns2), os3, ns3);
    }

    public static String replace(String source, String os1, String ns1, String os2, String ns2, String os3, String ns3, String os4, String ns4) {
        return TextUtil.replace(TextUtil.replace(TextUtil.replace(TextUtil.replace(source, os1, ns1), os2, ns2), os3, ns3), os4, ns4);
    }

    public static String replace(String source, String os1, String ns1, String os2, String ns2, String os3, String ns3, String os4, String ns4, String os5, String ns5) {
        return TextUtil.replace(TextUtil.replace(TextUtil.replace(TextUtil.replace(TextUtil.replace(source, os1, ns1), os2, ns2), os3, ns3), os4, ns4), os5, ns5);
    }

    public static String replace(String source, String os1, String ns1, String os2, String ns2, String os3, String ns3, String os4, String ns4, String os5, String ns5, String os6, String ns6) {
        return TextUtil.replace(TextUtil.replace(TextUtil.replace(TextUtil.replace(TextUtil.replace(TextUtil.replace(source, os1, ns1), os2, ns2), os3, ns3), os4, ns4), os5, ns5), os6, ns6);
    }

    public static String replace(String source, Replacer rep) {
        if (source == null) {
            return null;
        }
        for (Map.Entry<String, Supplier<String>> entry : rep.getReplacements().entrySet()) {
            source = TextUtil.replace(source, entry.getKey(), entry.getValue());
        }
        return source;
    }

    public static String replace(String input, String target, Supplier<String> replacement) {
        if (input == null || target == null || replacement == null) {
            throw new IllegalArgumentException("Input, target or replacement cannot be null");
        }
        if (target.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        while (index < input.length()) {
            int next = input.indexOf(target, index);
            if (next == -1) {
                result.append(input.substring(index));
                break;
            }
            result.append(input, index, next);
            result.append(replacement.get());
            index = next + target.length();
        }
        return result.toString();
    }

    public static String replaceNonEscaped(String source, String os, String ns) {
        String replaced = TextUtil.replace(source, "\\" + os, "\ue000");
        replaced = TextUtil.replace(replaced, os, ns);
        return TextUtil.replace(replaced, "\ue000", os);
    }

    public static String removeEnd(String str, String remove) {
        if (TextUtil.isEmpty(str) || TextUtil.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.isEmpty();
    }

    public static String capitalize(String str) {
        int codepoint;
        int newCodePoint;
        int strLen = TextUtil.length(str);
        if (strLen == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return "";
        }
        char[] buf = new char[repeat];
        Arrays.fill(buf, ch);
        return new String(buf);
    }

    private static Set<Integer> generateDelimiterSet(char[] delimiters) {
        HashSet<Integer> delimiterHashSet = new HashSet<Integer>();
        if (delimiters == null || delimiters.length == 0) {
            if (delimiters == null) {
                delimiterHashSet.add(Character.codePointAt(new char[]{' '}, 0));
            }
            return delimiterHashSet;
        }
        for (int index = 0; index < delimiters.length; ++index) {
            delimiterHashSet.add(Character.codePointAt(delimiters, index));
        }
        return delimiterHashSet;
    }

    public static String capitalizeWord(String str, char ... delimiters) {
        if (TextUtil.isEmpty(str)) {
            return str;
        }
        Set<Integer> delimiterSet = TextUtil.generateDelimiterSet(delimiters);
        int strLen = str.length();
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        boolean capitalizeNext = true;
        int index = 0;
        while (index < strLen) {
            int codePoint = str.codePointAt(index);
            if (delimiterSet.contains(codePoint)) {
                capitalizeNext = true;
                newCodePoints[outOffset++] = codePoint;
                index += Character.charCount(codePoint);
                continue;
            }
            if (capitalizeNext) {
                int titleCaseCodePoint = Character.toTitleCase(codePoint);
                newCodePoints[outOffset++] = titleCaseCodePoint;
                index += Character.charCount(titleCaseCodePoint);
                capitalizeNext = false;
                continue;
            }
            newCodePoints[outOffset++] = codePoint;
            index += Character.charCount(codePoint);
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String capitalizeWord(String str) {
        return TextUtil.capitalizeWord(str, null);
    }

    public static boolean contains(String[] source, String target) {
        boolean matches = false;
        for (String str : source) {
            if (!str.equalsIgnoreCase(target)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public static List<String> getPlaceholders(String text) {
        int closeIndex;
        int openIndex;
        ArrayList<String> placeholders = new ArrayList<String>();
        int index = 0;
        while (index < text.length() && (openIndex = text.indexOf(123, index)) != -1 && (closeIndex = text.indexOf(125, openIndex)) != -1) {
            String placeholder = text.substring(openIndex + 1, closeIndex);
            placeholders.add(placeholder);
            index = closeIndex + 1;
        }
        return placeholders;
    }

    public static String wrapText(String input, int maxLength, String insertion) {
        StringBuilder sb = new StringBuilder(input);
        int i = 0;
        ArrayList<String> lines = new ArrayList<String>();
        while (i < input.length()) {
            String sub = TextUtil.substringIgnoreFormatting(sb.toString(), i, Math.min(i + maxLength, input.length()));
            int addedLength = 0;
            if (!sub.equals(" ")) {
                String added = TextUtil.substringIgnoreFormatting(sub, 0, Math.min(maxLength, sub.length()));
                int lastSpace = added.lastIndexOf(" ");
                if (lastSpace != -1) {
                    if (sb.charAt(Math.min(i + added.length(), sb.length() - 1)) == ' ' || i + added.length() == sb.length()) {
                        lines.add(added);
                        addedLength = added.length();
                    } else {
                        String addedCutOff = added.substring(0, lastSpace);
                        addedLength = addedCutOff.length();
                        lines.add(addedCutOff);
                    }
                } else {
                    lines.add(added);
                    addedLength = added.length();
                }
            }
            if ((i += addedLength) >= sb.length() || sb.charAt(i) != ' ') continue;
            ++i;
        }
        StringBuilder output = new StringBuilder();
        String lastInsertion = "";
        for (String line : lines) {
            lastInsertion = insertion;
            output.append(line).append(insertion);
        }
        output.replace(output.length() - lastInsertion.length(), output.length(), "");
        return output.toString();
    }

    private static String substringIgnoreFormatting(String input, int start, int end) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        if (start < 0 || end > input.length() || start > end) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean insideBrackets = false;
        int count = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '<') {
                insideBrackets = true;
            }
            if (c == '>') {
                insideBrackets = false;
            }
            if (!insideBrackets || count <= start) {
                ++count;
            }
            if (count > start && count <= end) {
                result.append(c);
            }
            if (count > end) break;
        }
        return result.toString();
    }
}

