/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.util.file;

import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class FileUtil {
    @Nullable
    public static String renameNoDuplicates(File file, String resultName, File directory) {
        Object renamedName;
        int duplicates = 0;
        File[] subFiles = directory.listFiles();
        if (subFiles != null) {
            for (File subFile : subFiles) {
                int fileNameNumber;
                if (subFile.getName().equals(resultName)) {
                    if (1 <= duplicates) break;
                    duplicates = 1;
                    break;
                }
                String baseName = FileUtil.getBaseName(resultName);
                if (!subFile.getName().startsWith(baseName + " (") || (fileNameNumber = NumberUtil.toInt(subFile.getName().substring(baseName.length() + 2, baseName.length() + 3)) + 1) <= duplicates) continue;
                duplicates = fileNameNumber;
            }
        }
        if (duplicates == 0) {
            renamedName = resultName;
        } else {
            String resultBase = FileUtil.getBaseName(resultName);
            String resultExtension = FileUtil.getExtension(resultName);
            renamedName = resultBase + " (" + duplicates + ")." + resultExtension;
        }
        if (file.renameTo(new File(file.getParent(), (String)renamedName))) {
            return renamedName;
        }
        return null;
    }

    public static String getBaseName(String fileName) {
        return fileName.split("\\.(?=[^.]+$)")[0];
    }

    public static String getExtension(String fileName) {
        try {
            return fileName.split("\\.(?=[^.]+$)")[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return fileName;
        }
    }

    public static ConfigurationNode loadYamlFile(File file) throws IOException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(file)).nodeStyle(NodeStyle.BLOCK).build();
        return loader.load();
    }

    public static void saveYamlFile(File file, @NotNull ConfigurationNode config) throws IOException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(file)).nodeStyle(NodeStyle.BLOCK).indent(2).build();
        loader.save(config);
    }

    public static ConfigurationNode loadEmbeddedYamlFile(String fileName, AuraSkillsPlugin plugin) throws IOException {
        URI uri = FileUtil.getEmbeddedURI(fileName, plugin);
        if (uri == null) {
            throw new IllegalArgumentException("File " + fileName + " does not exist");
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        try (FileSystem ignored = FileSystems.newFileSystem(uri, env);){
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(Path.of(uri))).build();
            Object n = loader.load();
            return n;
        }
    }

    private static URI getEmbeddedURI(String fileName, AuraSkillsPlugin plugin) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName cannot be null");
        }
        try {
            URL url = plugin.getClass().getClassLoader().getResource(fileName);
            if (url == null) {
                return null;
            }
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

