/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.trait;

import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitHandler;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.trait.LoadedTrait;
import dev.aurelium.auraskills.common.trait.TraitSupplier;
import dev.aurelium.auraskills.common.user.User;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class TraitManager {
    private final AuraSkillsPlugin plugin;
    private final Map<Trait, LoadedTrait> traitMap;
    private final TraitSupplier supplier;

    public TraitManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.traitMap = new HashMap<Trait, LoadedTrait>();
        this.supplier = new TraitSupplier(this, plugin.getMessageProvider());
    }

    public TraitSupplier getSupplier() {
        return this.supplier;
    }

    public abstract double getBaseLevel(User var1, Trait var2);

    @NotNull
    public LoadedTrait getTrait(Trait trait) {
        LoadedTrait loadedTrait = this.traitMap.get(trait);
        if (loadedTrait == null) {
            throw new IllegalArgumentException("Trait " + trait + " is not loaded!");
        }
        return loadedTrait;
    }

    public void register(Trait trait, LoadedTrait loadedTrait) {
        this.traitMap.put(trait, loadedTrait);
    }

    public void unregisterAll() {
        this.traitMap.clear();
    }

    public Set<Trait> getEnabledTraits() {
        HashSet<Trait> skills = new HashSet<Trait>();
        for (LoadedTrait loaded : this.traitMap.values()) {
            if (!loaded.trait().isEnabled()) continue;
            skills.add(loaded.trait());
        }
        return skills;
    }

    public Set<Stat> getLinkedStats(Trait trait) {
        HashSet<Stat> set = new HashSet<Stat>();
        for (Stat stat : this.plugin.getStatManager().getEnabledStats()) {
            if (!stat.getTraits().contains(trait)) continue;
            set.add(stat);
        }
        return set;
    }

    public boolean isLoaded(Trait trait) {
        return this.traitMap.containsKey(trait);
    }

    public abstract void registerTraitHandler(TraitHandler var1);

    public abstract String getMenuDisplay(Trait var1, double var2, Locale var4);
}

