/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.trait;

import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.trait.LoadedTrait;
import dev.aurelium.auraskills.common.trait.TraitOptions;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class TraitLoader {
    private static final String FILE_NAME = "stats.yml";
    private final AuraSkillsPlugin plugin;
    private final ConfigurateLoader configurateLoader;
    private ConfigurationNode root;

    public TraitLoader(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        TypeSerializerCollection traitSerializers = TypeSerializerCollection.builder().build();
        this.configurateLoader = new ConfigurateLoader(plugin, traitSerializers);
    }

    public void init() {
        try {
            ConfigurationNode embedded = this.configurateLoader.loadEmbeddedFile(FILE_NAME);
            ConfigurationNode user = this.configurateLoader.loadUserFile(FILE_NAME);
            ConfigurationNode defined = this.plugin.getTraitRegistry().getDefinedConfig();
            this.root = this.configurateLoader.loadContentAndMerge(defined, FILE_NAME, embedded, user);
        }
        catch (Exception e) {
            this.plugin.logger().warn("Error loading stats.yml file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public LoadedTrait loadTrait(Trait trait) throws SerializationException {
        ConfigurationNode traitNode = this.root.node("traits", trait.getId().toString());
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        for (Object key : traitNode.childrenMap().keySet()) {
            configMap.put((String)key, traitNode.node(key).raw());
        }
        this.applyConfigOverrides(trait, configMap);
        TraitOptions traitOptions = new TraitOptions(configMap);
        return new LoadedTrait(trait, traitOptions);
    }

    private void applyConfigOverrides(Trait trait, Map<String, Object> configMap) {
        if (this.plugin.configBoolean(Option.MANA_ENABLED)) {
            return;
        }
        if (trait == Traits.MANA_REGEN || trait == Traits.MAX_MANA) {
            configMap.put("enabled", false);
        }
    }
}

