/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage.sql.pool;

import dev.aurelium.auraskills.common.storage.sql.DatabaseCredentials;
import dev.aurelium.auraskills.hikari.HikariConfig;
import dev.aurelium.auraskills.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class ConnectionPool {
    private final DatabaseCredentials credentials;
    private HikariDataSource dataSource;

    public ConnectionPool(DatabaseCredentials credentials) {
        this.credentials = credentials;
    }

    public String getDatabaseName() {
        return this.credentials.database();
    }

    public abstract void configure(HikariConfig var1, DatabaseCredentials var2);

    public void enable() {
        HikariConfig config = new HikariConfig();
        config.setPoolName("auraskills-hikari");
        config.setConnectionTimeout(5000L);
        this.configure(config, this.credentials);
        this.dataSource = new HikariDataSource(config);
    }

    public void disable() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new SQLException("Failed to get a connection from the pool (dataSource is null).");
        }
        Connection connection = this.dataSource.getConnection();
        if (connection == null) {
            throw new SQLException("Failed to get a connection from the pool (getConnection returned null).");
        }
        return connection;
    }
}

