/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage.sql;

import dev.aurelium.auraskills.api.ability.AbstractAbility;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.ability.AbilityData;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.mana.ManaAbilityData;
import dev.aurelium.auraskills.common.storage.StorageProvider;
import dev.aurelium.auraskills.common.storage.sql.TableCreator;
import dev.aurelium.auraskills.common.storage.sql.pool.ConnectionPool;
import dev.aurelium.auraskills.common.ui.ActionBarType;
import dev.aurelium.auraskills.common.user.SkillLevelMaps;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserState;
import dev.aurelium.auraskills.common.util.data.KeyIntPair;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class SqlStorageProvider
extends StorageProvider {
    private final ConnectionPool pool;
    private final String tablePrefix = "auraskills_";
    public final int STAT_MODIFIER_ID = 1;
    public final int TRAIT_MODIFIER_ID = 2;
    public final int ABILITY_DATA_ID = 3;
    public final int UNCLAIMED_ITEMS_ID = 4;
    public final int ACTION_BAR_ID = 5;
    public final int JOBS_ID = 6;

    public SqlStorageProvider(AuraSkillsPlugin plugin, ConnectionPool pool) {
        super(plugin);
        this.pool = pool;
        this.attemptTableCreation();
    }

    public ConnectionPool getPool() {
        return this.pool;
    }

    public void attemptTableCreation() {
        TableCreator tableCreator = new TableCreator(this.plugin, this.pool, "auraskills_");
        tableCreator.createTables();
    }

    /*
     * Exception decompiling
     */
    @Override
    protected User loadRaw(UUID uuid) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SkillLevelMaps loadSkillLevels(Connection connection, UUID uuid, int userId) throws SQLException {
        HashMap<Skill, Double> xpMap;
        HashMap<Skill, Integer> levelsMap;
        block16: {
            levelsMap = new HashMap<Skill, Integer>();
            xpMap = new HashMap<Skill, Double>();
            String loadQuery = "SELECT * FROM auraskills_skill_levels WHERE user_id=?;";
            try (PreparedStatement statement = connection.prepareStatement(loadQuery);){
                statement.setInt(1, userId);
                ResultSet resultSet = statement.executeQuery();
                block12: while (true) {
                    while (resultSet.next()) {
                        String skillName = resultSet.getString("skill_name");
                        NamespacedId skillId = NamespacedId.fromString(skillName);
                        try {
                            Skill skill = (Skill)this.plugin.getSkillRegistry().get(skillId);
                            int level = resultSet.getInt("skill_level");
                            double xp = resultSet.getDouble("skill_xp");
                            levelsMap.put(skill, level);
                            xpMap.put(skill, xp);
                            continue block12;
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.logger().warn("Failed to load skill level for player " + uuid + " because " + skillName + " is not a registered skill");
                        }
                    }
                    break block16;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        return new SkillLevelMaps(levelsMap, xpMap);
    }

    private Map<String, StatModifier> loadStatModifiers(Connection connection, UUID uuid, int userId) throws SQLException {
        HashMap<String, StatModifier> modifiers;
        block16: {
            modifiers = new HashMap<String, StatModifier>();
            String query = "SELECT category_id, key_name, value FROM auraskills_key_values WHERE user_id=? AND data_id=?;";
            try (PreparedStatement statement = connection.prepareStatement(query);){
                statement.setInt(1, userId);
                statement.setInt(2, 1);
                ResultSet resultSet = statement.executeQuery();
                block12: while (true) {
                    while (resultSet.next()) {
                        String categoryId = resultSet.getString("category_id");
                        try {
                            Stat stat = (Stat)this.plugin.getStatRegistry().get(NamespacedId.fromString(categoryId));
                            String keyName = resultSet.getString("key_name");
                            double value = resultSet.getDouble("value");
                            StatModifier modifier = new StatModifier(keyName, stat, value);
                            modifiers.put(keyName, modifier);
                            continue block12;
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.logger().warn("Failed to load stat modifier for player " + uuid + " because " + categoryId + " is not a registered stat");
                        }
                    }
                    break block16;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        return modifiers;
    }

    private Map<String, TraitModifier> loadTraitModifiers(Connection connection, UUID uuid, int userId) throws SQLException {
        HashMap<String, TraitModifier> modifiers;
        block16: {
            modifiers = new HashMap<String, TraitModifier>();
            String query = "SELECT category_id, key_name, value FROM auraskills_key_values WHERE user_id=? AND data_id=?;";
            try (PreparedStatement statement = connection.prepareStatement(query);){
                statement.setInt(1, userId);
                statement.setInt(2, 2);
                ResultSet resultSet = statement.executeQuery();
                block12: while (true) {
                    while (resultSet.next()) {
                        String categoryId = resultSet.getString("category_id");
                        try {
                            Trait trait = (Trait)this.plugin.getTraitRegistry().get(NamespacedId.fromString(categoryId));
                            String keyName = resultSet.getString("key_name");
                            double value = resultSet.getDouble("value");
                            TraitModifier modifier = new TraitModifier(keyName, trait, value);
                            modifiers.put(keyName, modifier);
                            continue block12;
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.logger().warn("Failed to load trait modifier for player " + uuid + " because " + categoryId + " is not a registered trait");
                        }
                    }
                    break block16;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        return modifiers;
    }

    private void loadAbilityData(Connection connection, User user, int userId) throws SQLException {
        String query = "SELECT category_id, key_name, value FROM auraskills_key_values WHERE user_id=? AND data_id=?;";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setInt(2, 3);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String categoryId = resultSet.getString("category_id");
                    AbstractAbility ability = this.plugin.getAbilityManager().getAbstractAbility(NamespacedId.fromString(categoryId));
                    if (ability == null) {
                        this.plugin.logger().warn("Failed to load ability data for player " + user.getUuid() + " because " + categoryId + " is not a registered ability");
                        continue;
                    }
                    String keyName = resultSet.getString("key_name");
                    String value = resultSet.getString("value");
                    Object parsed = this.castValue(value);
                    if (keyName.equals("cooldown") && ability instanceof ManaAbility) {
                        ManaAbility manaAbility = (ManaAbility)ability;
                        user.getManaAbilityData(manaAbility).setCooldown(NumberUtil.toInt(value));
                        continue;
                    }
                    user.getAbilityData(ability).setData(keyName, parsed);
                }
            }
        }
    }

    private void loadJobs(Connection connection, User user, int userId) throws SQLException {
        String query = "SELECT key_name, value FROM auraskills_key_values WHERE user_id=? AND data_id=?;";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setInt(2, 6);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String[] splitValue;
                    String keyName = resultSet.getString("key_name");
                    String value = resultSet.getString("value");
                    if (!keyName.equals("jobs")) continue;
                    user.clearAllJobs();
                    for (String skillName : splitValue = value.split(",")) {
                        if (skillName.isEmpty()) continue;
                        NamespacedId id = NamespacedId.fromString(skillName);
                        Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(id);
                        if (skill == null) continue;
                        user.addJob(skill);
                    }
                    break;
                }
            }
        }
    }

    @NotNull
    private Object castValue(String value) {
        Object parsed = value;
        if (value.equals("true")) {
            parsed = true;
        } else if (value.equals("false")) {
            parsed = false;
        } else {
            try {
                parsed = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                try {
                    parsed = Double.parseDouble(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return parsed;
    }

    private List<KeyIntPair> loadUnclaimedItems(Connection connection, int userId) throws SQLException {
        ArrayList<KeyIntPair> unclaimedItems = new ArrayList<KeyIntPair>();
        String query = "SELECT key_name, value FROM auraskills_key_values WHERE user_id=? AND data_id=?;";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setInt(2, 4);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String keyName = resultSet.getString("key_name");
                    String value = resultSet.getString("value");
                    unclaimedItems.add(new KeyIntPair(keyName, NumberUtil.toInt(value, 1)));
                }
            }
        }
        return unclaimedItems;
    }

    private void loadActionBar(Connection connection, User user, int userId) throws SQLException {
        block16: {
            String query = "SELECT key_name, value FROM auraskills_key_values WHERE user_id=? AND data_id=?;";
            try (PreparedStatement statement = connection.prepareStatement(query);){
                statement.setInt(1, userId);
                statement.setInt(2, 5);
                ResultSet resultSet = statement.executeQuery();
                block12: while (true) {
                    while (resultSet.next()) {
                        String keyName = resultSet.getString("key_name");
                        String value = resultSet.getString("value");
                        try {
                            ActionBarType type = ActionBarType.valueOf(keyName.toUpperCase(Locale.ROOT));
                            boolean enabled = !value.equals("false");
                            user.setActionBarSetting(type, enabled);
                            continue block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                    break block16;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public UserState loadState(UUID uuid) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void applyState(UserState state) throws Exception {
        String usersQuery = "INSERT INTO auraskills_users (player_uuid, mana) VALUES (?, ?) ON DUPLICATE KEY UPDATE mana=?;";
        try (Connection connection = this.pool.getConnection();){
            try (PreparedStatement statement = connection.prepareStatement(usersQuery);){
                statement.setString(1, state.uuid().toString());
                statement.setDouble(2, state.mana());
                statement.setDouble(3, state.mana());
                statement.executeUpdate();
            }
            int userId = this.getUserId(connection, state.uuid());
            String skillLevelsQuery = "INSERT INTO auraskills_skill_levels (user_id, skill_name, skill_level, skill_xp) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE skill_level=?, skill_xp=?;";
            try (PreparedStatement statement = connection.prepareStatement(skillLevelsQuery);){
                statement.setInt(1, userId);
                for (Map.Entry<Skill, Integer> entry : state.skillLevels().entrySet()) {
                    String skillName = entry.getKey().getId().toString();
                    int level = entry.getValue();
                    double xp = state.skillXp().get(entry.getKey());
                    statement.setString(2, skillName);
                    statement.setInt(3, level);
                    statement.setDouble(4, xp);
                    statement.setInt(5, level);
                    statement.setDouble(6, xp);
                    statement.executeUpdate();
                }
            }
            this.saveStatModifiers(connection, userId, state.statModifiers());
            this.saveTraitModifiers(connection, userId, state.traitModifiers());
        }
    }

    public int getUserId(Connection connection, UUID uuid) throws SQLException {
        String query = "SELECT user_id FROM auraskills_users WHERE player_uuid=?;";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, uuid.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    int n = resultSet.getInt("user_id");
                    return n;
                }
                throw new RuntimeException("Failed to get user_id for player " + uuid);
            }
        }
    }

    @Override
    public void save(@NotNull User user) throws Exception {
        if (user.shouldNotSave()) {
            return;
        }
        if (!this.plugin.configBoolean(Option.SAVE_BLANK_PROFILES) && user.isBlankProfile()) {
            try (Connection connection = this.pool.getConnection();){
                this.deleteUser(connection, user);
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                this.plugin.logger().severe("Error deleting blank profile of user with UUID " + user.getUuid());
                throw e;
            }
            return;
        }
        try (Connection connection = this.pool.getConnection();){
            this.saveUsersTable(connection, user);
            this.saveSkillLevelsTable(connection, user);
            this.saveKeyValuesTable(connection, user);
        }
    }

    private void saveUsersTable(Connection connection, User user) throws SQLException {
        String usersQuery = "INSERT INTO auraskills_users (player_uuid, locale, mana) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE locale=?, mana=?;";
        try (PreparedStatement statement = connection.prepareStatement(usersQuery);){
            statement.setString(1, user.getUuid().toString());
            int curr = 2;
            for (int i = 0; i < 2; ++i) {
                if (user.hasLocale()) {
                    statement.setString(curr++, user.getLocale().toString());
                } else {
                    statement.setNull(curr++, 0);
                }
                statement.setDouble(curr++, user.getMana());
            }
            statement.executeUpdate();
        }
    }

    private void saveSkillLevelsTable(Connection connection, User user) throws SQLException {
        int userId = this.getUserId(connection, user.getUuid());
        String skillLevelsQuery = "INSERT INTO auraskills_skill_levels (user_id, skill_name, skill_level, skill_xp) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE skill_level=?, skill_xp=?;";
        try (PreparedStatement statement = connection.prepareStatement(skillLevelsQuery);){
            statement.setInt(1, userId);
            for (Map.Entry<Skill, Integer> entry : user.getSkillLevelMap().entrySet()) {
                String skillName = entry.getKey().getId().toString();
                int level = entry.getValue();
                double xp = user.getSkillXpMap().get(entry.getKey());
                statement.setString(2, skillName);
                statement.setInt(3, level);
                statement.setDouble(4, xp);
                statement.setInt(5, level);
                statement.setDouble(6, xp);
                statement.executeUpdate();
            }
        }
    }

    private void saveKeyValuesTable(Connection connection, User user) throws SQLException {
        int userId = this.getUserId(connection, user.getUuid());
        this.deleteKeyValues(connection, userId);
        this.saveStatModifiers(connection, userId, user.getStatModifiers());
        this.saveTraitModifiers(connection, userId, user.getTraitModifiers());
        this.saveAbilityData(connection, userId, user.getAbilityDataMap(), user.getManaAbilityDataMap());
        this.saveUnclaimedItems(connection, userId, user.getUnclaimedItems());
        this.saveActionBar(connection, userId, user);
        this.saveJobs(connection, userId, user.getJobs());
    }

    private void deleteUser(Connection connection, User user) throws SQLException {
        block39: {
            connection.setAutoCommit(false);
            String getUserIdQuery = "SELECT user_id FROM auraskills_users WHERE player_uuid=?;";
            try (PreparedStatement statement = connection.prepareStatement(getUserIdQuery);){
                statement.setString(1, user.getUuid().toString());
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        int userId = rs.getInt("user_id");
                        String deleteKeyValuesQuery = "DELETE FROM auraskills_key_values WHERE user_id=?;";
                        try (PreparedStatement delStatement = connection.prepareStatement(deleteKeyValuesQuery);){
                            delStatement.setInt(1, userId);
                            delStatement.executeUpdate();
                        }
                        String deleteSkillLevelsQuery = "DELETE FROM auraskills_skill_levels WHERE user_id=?;";
                        try (PreparedStatement delStatement = connection.prepareStatement(deleteSkillLevelsQuery);){
                            delStatement.setInt(1, userId);
                            delStatement.executeUpdate();
                        }
                        String deleteUsersQuery = "DELETE FROM auraskills_users WHERE user_id=?;";
                        try (PreparedStatement delStatement = connection.prepareStatement(deleteUsersQuery);){
                            delStatement.setInt(1, userId);
                            delStatement.executeUpdate();
                        }
                        connection.commit();
                        break block39;
                    }
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
    }

    private void deleteKeyValues(Connection connection, int userId) throws SQLException {
        String query = "DELETE FROM auraskills_key_values WHERE user_id=?;";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.executeUpdate();
        }
    }

    private void saveStatModifiers(Connection connection, int userId, Map<String, StatModifier> modifiers) throws SQLException {
        if (modifiers.isEmpty()) {
            return;
        }
        String query = "INSERT INTO auraskills_key_values (user_id, data_id, category_id, key_name, value) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE value=?;";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setInt(2, 1);
            for (StatModifier modifier : modifiers.values()) {
                String categoryId = modifier.stat().getId().toString();
                statement.setString(3, categoryId);
                statement.setString(4, modifier.name());
                statement.setString(5, String.valueOf(modifier.value()));
                statement.setString(6, String.valueOf(modifier.value()));
                statement.executeUpdate();
            }
        }
    }

    private void saveTraitModifiers(Connection connection, int userId, Map<String, TraitModifier> modifiers) throws SQLException {
        if (modifiers.isEmpty()) {
            return;
        }
        String query = "INSERT INTO auraskills_key_values (user_id, data_id, category_id, key_name, value) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE value=?;";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setInt(2, 2);
            for (TraitModifier modifier : modifiers.values()) {
                String categoryId = modifier.trait().getId().toString();
                statement.setString(3, categoryId);
                statement.setString(4, modifier.name());
                statement.setString(5, String.valueOf(modifier.value()));
                statement.setString(6, String.valueOf(modifier.value()));
                statement.executeUpdate();
            }
        }
    }

    private void saveAbilityData(Connection connection, int userId, Map<AbstractAbility, AbilityData> abilityDataMap, Map<ManaAbility, ManaAbilityData> manaAbilityDataMap) throws SQLException {
        if (abilityDataMap.isEmpty()) {
            return;
        }
        String query = "INSERT INTO auraskills_key_values (user_id, data_id, category_id, key_name, value) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE value=?;";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            String categoryId;
            statement.setInt(1, userId);
            statement.setInt(2, 3);
            for (AbilityData abilityData : abilityDataMap.values()) {
                categoryId = abilityData.getAbility().getId().toString();
                statement.setString(3, categoryId);
                for (Map.Entry<String, Object> dataEntry : abilityData.getDataMap().entrySet()) {
                    statement.setString(4, dataEntry.getKey());
                    statement.setString(5, String.valueOf(dataEntry.getValue()));
                    statement.setString(6, String.valueOf(dataEntry.getValue()));
                    statement.executeUpdate();
                }
            }
            for (ManaAbilityData data : manaAbilityDataMap.values()) {
                if (data.getCooldown() <= 0) continue;
                categoryId = data.getManaAbility().getId().toString();
                statement.setString(3, categoryId);
                statement.setString(4, "cooldown");
                statement.setString(5, String.valueOf(data.getCooldown()));
                statement.setString(6, String.valueOf(data.getCooldown()));
                statement.executeUpdate();
            }
        }
    }

    private void saveUnclaimedItems(Connection connection, int userId, List<KeyIntPair> unclaimedItems) throws SQLException {
        if (unclaimedItems.isEmpty()) {
            return;
        }
        String query = "INSERT INTO auraskills_key_values (user_id, data_id, category_id, key_name, value) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE value=?;";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setInt(2, 4);
            for (KeyIntPair unclaimedItem : unclaimedItems) {
                statement.setNull(3, 0);
                statement.setString(4, unclaimedItem.getKey());
                statement.setString(5, String.valueOf(unclaimedItem.getValue()));
                statement.setString(6, String.valueOf(unclaimedItem.getValue()));
                statement.executeUpdate();
            }
        }
    }

    private void saveActionBar(Connection connection, int userId, User user) throws SQLException {
        boolean shouldSave = false;
        for (ActionBarType type : ActionBarType.values()) {
            if (user.isActionBarEnabled(type)) continue;
            shouldSave = true;
        }
        if (!shouldSave) {
            return;
        }
        String query = "INSERT INTO auraskills_key_values (user_id, data_id, category_id, key_name, value) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE value=?;";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setInt(2, 5);
            statement.setNull(3, 0);
            ActionBarType type = ActionBarType.IDLE;
            statement.setString(4, type.toString().toLowerCase(Locale.ROOT));
            String value = String.valueOf(user.isActionBarEnabled(type));
            statement.setString(5, value);
            statement.setString(6, value);
            statement.executeUpdate();
        }
    }

    private void saveJobs(Connection connection, int userId, Set<Skill> jobs) throws SQLException {
        if (jobs.isEmpty()) {
            return;
        }
        String query = "INSERT INTO auraskills_key_values (user_id, data_id, category_id, key_name, value) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE value=?";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, userId);
            statement.setInt(2, 6);
            statement.setNull(3, 0);
            statement.setString(4, "jobs");
            String jobCommaList = String.join((CharSequence)",", jobs.stream().map(s -> s.getId().toString()).toList());
            statement.setString(5, jobCommaList);
            statement.setString(6, jobCommaList);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete(UUID uuid) throws Exception {
        try (Connection connection = this.pool.getConnection();){
            int userId = this.getUserId(connection, uuid);
            String usersQuery = "DELETE FROM auraskills_users WHERE user_id=?;";
            try (PreparedStatement statement = connection.prepareStatement(usersQuery);){
                statement.setInt(1, userId);
                statement.executeUpdate();
            }
            String skillLevelsQuery = "DELETE FROM auraskills_skill_levels WHERE user_id=?;";
            try (PreparedStatement statement = connection.prepareStatement(skillLevelsQuery);){
                statement.setInt(1, userId);
                statement.executeUpdate();
            }
        }
    }

    @Override
    public List<UserState> loadStates(boolean ignoreOnline) throws Exception {
        ArrayList<UserState> states = new ArrayList<UserState>();
        HashMap<Integer, Map> loadedSkillLevels = new HashMap<Integer, Map>();
        HashMap<Integer, Map> loadedSkillXp = new HashMap<Integer, Map>();
        try (Connection connection = this.pool.getConnection();){
            String skillLevelsQuery = "SELECT user_id, skill_name, skill_level, skill_xp FROM auraskills_skill_levels;";
            try (PreparedStatement statement = connection.prepareStatement(skillLevelsQuery);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    int userId = resultSet.getInt("user_id");
                    String skillName = resultSet.getString("skill_name");
                    Skill skill = (Skill)this.plugin.getSkillRegistry().get(NamespacedId.fromString(skillName));
                    int level = resultSet.getInt("skill_level");
                    double xp = resultSet.getDouble("skill_xp");
                    loadedSkillLevels.computeIfAbsent(userId, k -> new HashMap()).put(skill, level);
                    loadedSkillXp.computeIfAbsent(userId, k -> new HashMap()).put(skill, xp);
                }
            }
            String usersQuery = "SELECT user_id, player_uuid, mana FROM auraskills_users;";
            try (PreparedStatement statement = connection.prepareStatement(usersQuery);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    int userId = resultSet.getInt("user_id");
                    UUID uuid = UUID.fromString(resultSet.getString("player_uuid"));
                    if (ignoreOnline && this.userManager.hasUser(uuid)) continue;
                    double mana = resultSet.getDouble("mana");
                    Map<String, StatModifier> statModifiers = this.loadStatModifiers(connection, uuid, userId);
                    Map<String, TraitModifier> traitModifiers = this.loadTraitModifiers(connection, uuid, userId);
                    Map skillLevelMap = (Map)loadedSkillLevels.get(userId);
                    Map skillXpMap = (Map)loadedSkillXp.get(userId);
                    UserState state = new UserState(uuid, skillLevelMap, skillXpMap, statModifiers, traitModifiers, mana);
                    states.add(state);
                }
            }
        }
        return states;
    }

    private static /* synthetic */ void lambda$loadRaw$1(User user, TraitModifier m) {
        user.addTraitModifier(m, false);
    }

    private static /* synthetic */ void lambda$loadRaw$0(User user, StatModifier m) {
        user.addStatModifier(m, false);
    }
}

