/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage.file;

import dev.aurelium.auraskills.api.ability.AbstractAbility;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.mana.ManaAbilityData;
import dev.aurelium.auraskills.common.storage.StorageProvider;
import dev.aurelium.auraskills.common.ui.ActionBarType;
import dev.aurelium.auraskills.common.user.SkillLevelMaps;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserState;
import dev.aurelium.auraskills.common.util.data.KeyIntPair;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class FileStorageProvider
extends StorageProvider {
    private final String dataDirectory;

    public FileStorageProvider(AuraSkillsPlugin plugin, String dataDirectory) {
        super(plugin);
        this.dataDirectory = dataDirectory;
    }

    @Override
    protected User loadRaw(UUID uuid) throws Exception {
        CommentedConfigurationNode root = this.loadYamlFile(uuid);
        User user = this.userManager.createNewUser(uuid);
        if (root.empty()) {
            return user;
        }
        UUID loadedUuid = UUID.fromString(((CommentedConfigurationNode)root.node(new Object[]{"uuid"})).getString(uuid.toString()));
        if (!loadedUuid.equals(uuid)) {
            throw new IllegalStateException("UUID mismatch for player " + uuid);
        }
        SkillLevelMaps skillLevelMaps = this.loadSkills(root.node(new Object[]{"skills"}));
        for (Map.Entry<Skill, Integer> entry : skillLevelMaps.levels().entrySet()) {
            Skill skill = entry.getKey();
            user.setSkillLevel(skill, entry.getValue());
            user.setSkillXp(skill, skillLevelMaps.xp().get(skill));
        }
        String localeString = ((CommentedConfigurationNode)root.node(new Object[]{"locale"})).getString();
        if (localeString != null) {
            Locale locale = new Locale(localeString);
            user.setLocale(locale);
        }
        double mana = ((CommentedConfigurationNode)root.node(new Object[]{"mana"})).getDouble();
        user.setMana(mana);
        this.loadStatModifiers(root.node(new Object[]{"stat_modifiers"})).forEach((name, modifier) -> user.addStatModifier((StatModifier)modifier, false));
        this.loadTraitModifiers(root.node(new Object[]{"trait_modifiers"})).forEach((name, modifier) -> user.addTraitModifier((TraitModifier)modifier, false));
        this.loadAbilityData(root.node(new Object[]{"ability_data"}), user);
        this.loadUnclaimedItems(root.node(new Object[]{"unclaimed_items"}), user);
        this.loadActionBar(root.node(new Object[]{"action_bar"}), user);
        this.loadJobs(root.node(new Object[]{"jobs"}), user);
        return user;
    }

    private SkillLevelMaps loadSkills(ConfigurationNode node) {
        HashMap<Skill, Integer> levelsMap = new HashMap<Skill, Integer>();
        HashMap<Skill, Double> xpMap = new HashMap<Skill, Double>();
        node.childrenMap().forEach((skillName, skillNode) -> {
            NamespacedId skillId = NamespacedId.fromString(skillName.toString());
            Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(skillId);
            if (skill == null) {
                return;
            }
            int level = skillNode.node("level").getInt();
            double xp = skillNode.node("xp").getDouble();
            levelsMap.put(skill, level);
            xpMap.put(skill, xp);
        });
        return new SkillLevelMaps(levelsMap, xpMap);
    }

    private Map<String, StatModifier> loadStatModifiers(ConfigurationNode node) {
        HashMap<String, StatModifier> statModifiers = new HashMap<String, StatModifier>();
        node.childrenMap().forEach((index, modifierNode) -> {
            String name = modifierNode.node("name").getString();
            String statName = modifierNode.node("stat").getString();
            double value = modifierNode.node("value").getDouble();
            if (name != null && statName != null) {
                NamespacedId statId = NamespacedId.fromString(statName);
                Stat stat = (Stat)this.plugin.getStatRegistry().getOrNull(statId);
                if (stat == null) {
                    return;
                }
                StatModifier statModifier = new StatModifier(name, stat, value);
                statModifiers.put(name, statModifier);
            }
        });
        return statModifiers;
    }

    private Map<String, TraitModifier> loadTraitModifiers(ConfigurationNode node) {
        HashMap<String, TraitModifier> traitModifiers = new HashMap<String, TraitModifier>();
        node.childrenMap().forEach((index, modifierNode) -> {
            String name = modifierNode.node("name").getString();
            String traitName = modifierNode.node("trait").getString();
            double value = modifierNode.node("value").getDouble();
            if (name != null && traitName != null) {
                NamespacedId traitId = NamespacedId.fromString(traitName);
                Trait trait = (Trait)this.plugin.getTraitRegistry().getOrNull(traitId);
                if (trait == null) {
                    return;
                }
                TraitModifier traitModifier = new TraitModifier(name, trait, value);
                traitModifiers.put(name, traitModifier);
            }
        });
        return traitModifiers;
    }

    private void loadAbilityData(ConfigurationNode node, User user) {
        node.childrenMap().forEach((abilityName, abilityNode) -> {
            NamespacedId abilityId = NamespacedId.fromString(abilityName.toString());
            AbstractAbility ability = this.plugin.getAbilityManager().getAbstractAbility(abilityId);
            abilityNode.childrenMap().forEach((key, value) -> {
                String keyStr = String.valueOf(key);
                if (keyStr.equals("cooldown") && ability instanceof ManaAbility) {
                    ManaAbility manaAbility = (ManaAbility)ability;
                    user.getManaAbilityData(manaAbility).setCooldown(value.getInt());
                } else {
                    user.getAbilityData(ability).setData((String)key, value.raw());
                }
            });
        });
    }

    private void loadUnclaimedItems(ConfigurationNode node, User user) {
        ArrayList<KeyIntPair> itemList = new ArrayList<KeyIntPair>();
        node.childrenList().forEach(itemNode -> {
            String itemString = itemNode.getString();
            if (itemString != null) {
                String[] split = itemString.split(" ");
                String itemName = split[0];
                int amount = Integer.parseInt(split[1]);
                itemList.add(new KeyIntPair(itemName, amount));
            }
        });
        user.setUnclaimedItems(itemList);
    }

    private void loadActionBar(ConfigurationNode node, User user) {
        for (ActionBarType type : ActionBarType.values()) {
            String typeName = type.toString().toLowerCase(Locale.ROOT);
            if (node.node(typeName).virtual()) continue;
            user.setActionBarSetting(type, node.node(typeName).getBoolean());
        }
    }

    private void loadJobs(ConfigurationNode node, User user) {
        user.clearAllJobs();
        for (ConfigurationNode configurationNode : node.childrenList()) {
            Skill skill;
            String skillName = configurationNode.getString();
            if (skillName == null || (skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromString(skillName))) == null) continue;
            user.addJob(skill);
        }
    }

    @NotNull
    private CommentedConfigurationNode loadYamlFile(UUID uuid) throws ConfigurateException {
        Path path = Path.of(this.dataDirectory, uuid.toString() + ".yml");
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(path)).build();
        return (CommentedConfigurationNode)loader.load();
    }

    @Override
    @NotNull
    public UserState loadState(UUID uuid) throws Exception {
        CommentedConfigurationNode root = this.loadYamlFile(uuid);
        if (root.empty()) {
            return UserState.createEmpty(uuid, this.plugin);
        }
        UUID loadedUuid = UUID.fromString(((CommentedConfigurationNode)root.node(new Object[]{"uuid"})).getString(uuid.toString()));
        if (!loadedUuid.equals(uuid)) {
            throw new IllegalStateException("UUID mismatch for player " + uuid);
        }
        SkillLevelMaps skillLevelMaps = this.loadSkills(root.node(new Object[]{"skills"}));
        double mana = ((CommentedConfigurationNode)root.node(new Object[]{"mana"})).getDouble();
        Map<String, StatModifier> statModifiers = this.loadStatModifiers(root.node(new Object[]{"stat_modifiers"}));
        Map<String, TraitModifier> traitModifiers = this.loadTraitModifiers(root.node(new Object[]{"trait_modifiers"}));
        return new UserState(uuid, skillLevelMaps.levels(), skillLevelMaps.xp(), statModifiers, traitModifiers, mana);
    }

    @Override
    public void applyState(UserState state) throws Exception {
        CommentedConfigurationNode root = this.loadYamlFile(state.uuid());
        ((CommentedConfigurationNode)root.node(new Object[]{"uuid"})).set(state.uuid().toString());
        ConfigurationNode skillsNode = root.node(new Object[]{"skills"});
        for (Skill skill : state.skillLevels().keySet()) {
            ConfigurationNode skillNode = skillsNode.node(skill.getId().toString());
            skillNode.node("level").set(state.skillLevels().get(skill));
            skillNode.node("xp").set(state.skillXp().get(skill));
        }
        ((CommentedConfigurationNode)root.node(new Object[]{"mana"})).set(state.mana());
        ConfigurationNode statModifiersNode = root.node(new Object[]{"stat_modifiers"});
        statModifiersNode.set(null);
        this.applyStatModifiers(statModifiersNode, state.statModifiers());
        ConfigurationNode traitModifiersNode = root.node(new Object[]{"trait_modifiers"});
        traitModifiersNode.set(null);
        this.applyTraitModifiers(traitModifiersNode, state.traitModifiers());
        this.saveYamlFile(root, state.uuid());
    }

    @Override
    public void save(@NotNull User user) throws Exception {
        if (user.isSaving()) {
            return;
        }
        user.setSaving(true);
        CommentedConfigurationNode root = this.loadYamlFile(user.getUuid());
        ((CommentedConfigurationNode)root.node(new Object[]{"uuid"})).set(user.getUuid().toString());
        ConfigurationNode skillsNode = root.node(new Object[]{"skills"});
        for (Skill skill : user.getSkillLevelMap().keySet()) {
            ConfigurationNode skillNode = skillsNode.node(skill.getId().toString());
            skillNode.node("level").set(user.getSkillLevel(skill));
            skillNode.node("xp").set(user.getSkillXp(skill));
        }
        if (user.hasLocale()) {
            ((CommentedConfigurationNode)root.node(new Object[]{"locale"})).set(user.getLocale().toString());
        }
        ((CommentedConfigurationNode)root.node(new Object[]{"mana"})).set(user.getMana());
        ConfigurationNode statModifiersNode = root.node(new Object[]{"stat_modifiers"});
        statModifiersNode.set(null);
        this.applyStatModifiers(statModifiersNode, user.getStatModifiers());
        ConfigurationNode traitModifiersNode = root.node(new Object[]{"trait_modifiers"});
        traitModifiersNode.set(null);
        this.applyTraitModifiers(traitModifiersNode, user.getTraitModifiers());
        ConfigurationNode abilityDataNode = root.node(new Object[]{"ability_data"});
        abilityDataNode.set(null);
        for (AbstractAbility abstractAbility : user.getAbilityDataMap().keySet()) {
            ConfigurationNode configurationNode = abilityDataNode.node(abstractAbility.getId().toString());
            for (Map.Entry<String, Object> entry : user.getAbilityData(abstractAbility).getDataMap().entrySet()) {
                configurationNode.node(entry.getKey()).set(entry.getValue());
            }
        }
        for (ManaAbilityData manaAbilityData : user.getManaAbilityDataMap().values()) {
            if (manaAbilityData.getCooldown() <= 0) continue;
            ConfigurationNode configurationNode = abilityDataNode.node(manaAbilityData.getManaAbility().getId().toString());
            configurationNode.node("cooldown").set(manaAbilityData.getCooldown());
        }
        ConfigurationNode unclaimedItemsNode = root.node(new Object[]{"unclaimed_items"});
        unclaimedItemsNode.set(null);
        for (KeyIntPair keyIntPair : user.getUnclaimedItems()) {
            unclaimedItemsNode.appendListNode().set(keyIntPair.getKey() + " " + keyIntPair.getValue());
        }
        ConfigurationNode configurationNode = root.node(new Object[]{"action_bar"});
        for (ActionBarType type : ActionBarType.values()) {
            if (type != ActionBarType.IDLE) continue;
            boolean value = user.isActionBarEnabled(type);
            configurationNode.node(type.toString().toLowerCase(Locale.ROOT)).set(value);
        }
        if (user.getJobs().isEmpty()) {
            root.removeChild("jobs");
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Skill skill : user.getJobs()) {
                arrayList.add(skill.getId().toString());
            }
            ((CommentedConfigurationNode)root.node(new Object[]{"jobs"})).set(arrayList);
        }
        this.saveYamlFile(root, user.getUuid());
        user.setSaving(false);
    }

    private void saveYamlFile(CommentedConfigurationNode root, UUID uuid) throws ConfigurateException {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(Path.of(this.dataDirectory, uuid.toString() + ".yml"))).nodeStyle(NodeStyle.BLOCK).indent(2).build();
        loader.save(root);
    }

    private void applyStatModifiers(ConfigurationNode node, Map<String, StatModifier> modifiers) throws Exception {
        int index = 0;
        for (StatModifier modifier : modifiers.values()) {
            ConfigurationNode modifierNode = node.node(String.valueOf(index));
            modifierNode.node("name").set(modifier.name());
            modifierNode.node("stat").set(modifier.stat().getId().toString());
            modifierNode.node("value").set(modifier.value());
            ++index;
        }
    }

    private void applyTraitModifiers(ConfigurationNode node, Map<String, TraitModifier> modifiers) throws Exception {
        int index = 0;
        for (TraitModifier modifier : modifiers.values()) {
            ConfigurationNode modifierNode = node.node(String.valueOf(index));
            modifierNode.node("name").set(modifier.name());
            modifierNode.node("trait").set(modifier.trait().getId().toString());
            modifierNode.node("value").set(modifier.value());
            ++index;
        }
    }

    @Override
    public void delete(UUID uuid) throws Exception {
        Path path = Path.of(this.dataDirectory, uuid.toString() + ".yml");
        Files.deleteIfExists(path);
    }

    @Override
    public List<UserState> loadStates(boolean ignoreOnline) {
        ArrayList<UserState> states = new ArrayList<UserState>();
        File[] files = new File(this.dataDirectory).listFiles();
        if (files == null) {
            return states;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String uuidString = fileName.substring(0, fileName.length() - 4);
            try {
                UUID uuid = UUID.fromString(uuidString);
                if (ignoreOnline && this.userManager.hasUser(uuid)) continue;
                states.add(this.loadState(uuid));
            }
            catch (Exception e) {
                this.plugin.logger().warn("Invalid player data file name: " + fileName);
            }
        }
        return states;
    }
}

