/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage.backup;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserManager;
import dev.aurelium.auraskills.common.user.UserState;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class BackupProvider {
    public final AuraSkillsPlugin plugin;
    public final UserManager playerManager;

    public BackupProvider(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.playerManager = plugin.getUserManager();
    }

    public void createBackupFolder() {
        File backupFolder = new File(this.plugin.getPluginFolder() + "/backups");
        if (!backupFolder.exists() && !backupFolder.mkdir()) {
            this.plugin.logger().warn("Error creating backups folder!");
        }
    }

    public File saveBackup(boolean savePlayerData) throws Exception {
        if (savePlayerData) {
            for (User user : this.plugin.getUserManager().getOnlineUsers()) {
                this.plugin.getStorageProvider().save(user);
            }
        }
        this.createBackupFolder();
        LocalTime time = LocalTime.now();
        File backupFile = new File(this.plugin.getPluginFolder() + "/backups/backup-" + LocalDate.now() + "_" + time.getHour() + "-" + time.getMinute() + "-" + time.getSecond() + ".yml");
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(backupFile.toPath())).build();
        BasicConfigurationNode config = BasicConfigurationNode.root();
        config.node("backup_version").set(2);
        int index = 0;
        List<UserState> states = this.plugin.getStorageProvider().loadStates(false);
        if (states.size() > this.plugin.configInt(Option.AUTOMATIC_BACKUPS_MAX_USERS)) {
            this.plugin.logger().info("Automatic backup saving was skipped due to too many users (" + states.size() + "), use your own backup system.");
            return null;
        }
        for (UserState state : states) {
            ConfigurationNode userNode = config.node("users", state.uuid().toString());
            for (Skill skill : state.skillLevels().keySet()) {
                int level = state.skillLevels().getOrDefault(skill, this.plugin.config().getStartLevel());
                double xp = state.skillXp().getOrDefault(skill, 0.0);
                ConfigurationNode skillNode = userNode.node("skills", skill.getId().toString());
                skillNode.node("level").set(level);
                skillNode.node("xp").set(xp);
            }
            userNode.node("mana").set(state.mana());
            for (StatModifier statModifier : state.statModifiers().values()) {
                ConfigurationNode modifierNode = userNode.node("stat_modifiers").appendListNode();
                modifierNode.node("name").set(statModifier.name());
                modifierNode.node("stat").set(statModifier.stat().getId().toString());
                modifierNode.node("value").set(statModifier.value());
            }
            for (TraitModifier traitModifier : state.traitModifiers().values()) {
                ConfigurationNode modifierNode = userNode.node("trait_modifiers").appendListNode();
                modifierNode.node("name").set(traitModifier.name());
                modifierNode.node("trait").set(traitModifier.trait().getId().toString());
                modifierNode.node("value").set(traitModifier.value());
            }
            this.plugin.logger().info("Saved backup user " + index);
            ++index;
        }
        loader.save(config);
        return backupFile;
    }

    public void loadBackup(File file) throws Exception {
        Object root = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(file.toPath())).build().load();
        int version = root.node("backup_version").getInt(0);
        if (version == 2) {
            this.loadV2((ConfigurationNode)root);
        } else if (version == 1) {
            this.loadV1((ConfigurationNode)root);
        } else {
            throw new IllegalStateException("Invalid backup_version");
        }
    }

    private void loadV2(ConfigurationNode config) throws Exception {
        for (ConfigurationNode configurationNode : config.node("users").childrenMap().values()) {
            Object modifierNode2;
            UUID uuid = this.getFromKey(configurationNode);
            if (uuid == null) continue;
            HashMap<Skill, Integer> skillLevels = new HashMap<Skill, Integer>();
            HashMap<Skill, Double> skillXp = new HashMap<Skill, Double>();
            for (ConfigurationNode configurationNode2 : configurationNode.node("skills").childrenMap().values()) {
                this.loadSkillNode(configurationNode2, skillLevels, skillXp);
            }
            HashMap<String, StatModifier> statModifiers = new HashMap<String, StatModifier>();
            for (Object modifierNode2 : configurationNode.node("stat_modifiers").childrenList()) {
                String string = modifierNode2.node("name").getString();
                String statName = modifierNode2.node("stat").getString();
                if (statName == null) continue;
                Stat stat = (Stat)this.plugin.getStatRegistry().get(NamespacedId.fromString(statName));
                double value = modifierNode2.node("value").getDouble();
                StatModifier statModifier = new StatModifier(string, stat, value);
                statModifiers.put(string, statModifier);
            }
            HashMap<String, TraitModifier> hashMap = new HashMap<String, TraitModifier>();
            modifierNode2 = configurationNode.node("trait_modifiers").childrenList().iterator();
            while (modifierNode2.hasNext()) {
                ConfigurationNode configurationNode3 = (ConfigurationNode)modifierNode2.next();
                String name = configurationNode3.node("name").getString();
                String traitName = configurationNode3.node("trait").getString();
                if (traitName == null) continue;
                Trait trait = (Trait)this.plugin.getTraitRegistry().get(NamespacedId.fromString(traitName));
                double value = configurationNode3.node("value").getDouble();
                TraitModifier traitModifier = new TraitModifier(name, trait, value);
                hashMap.put(name, traitModifier);
            }
            double mana = configurationNode.node("mana").getDouble();
            UserState state = new UserState(uuid, skillLevels, skillXp, statModifiers, hashMap, mana);
            this.plugin.getStorageProvider().applyState(state);
        }
    }

    private void loadV1(ConfigurationNode config) throws Exception {
        for (ConfigurationNode configurationNode : config.node("player_data").childrenMap().values()) {
            UUID uuid = this.getFromKey(configurationNode);
            if (uuid == null) continue;
            HashMap<Skill, Integer> skillLevels = new HashMap<Skill, Integer>();
            HashMap<Skill, Double> skillXp = new HashMap<Skill, Double>();
            for (ConfigurationNode configurationNode2 : configurationNode.childrenMap().values()) {
                this.loadSkillNode(configurationNode2, skillLevels, skillXp);
            }
            UserState state = new UserState(uuid, skillLevels, skillXp, new HashMap<String, StatModifier>(), new HashMap<String, TraitModifier>(), 0.0);
            this.plugin.getStorageProvider().applyState(state);
        }
    }

    private void loadSkillNode(ConfigurationNode skillNode, Map<Skill, Integer> skillLevels, Map<Skill, Double> skillXp) {
        String skillName = (String)skillNode.key();
        if (skillName == null) {
            return;
        }
        Skill skill = (Skill)this.plugin.getSkillRegistry().get(NamespacedId.fromDefault(skillName.toLowerCase(Locale.ROOT)));
        int level = skillNode.node("level").getInt();
        double xp = skillNode.node("xp").getDouble();
        skillLevels.put(skill, level);
        skillXp.put(skill, xp);
    }

    @Nullable
    private UUID getFromKey(ConfigurationNode node) {
        String key = (String)node.key();
        if (key == null) {
            return null;
        }
        return UUID.fromString(key);
    }
}

