/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.storage;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.user.UserManager;
import dev.aurelium.auraskills.common.user.UserState;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class StorageProvider {
    public final AuraSkillsPlugin plugin;
    public final UserManager userManager;

    public StorageProvider(AuraSkillsPlugin plugin) {
        this.userManager = plugin.getUserManager();
        this.plugin = plugin;
    }

    public void load(UUID uuid) throws Exception {
        User user = this.loadRaw(uuid);
        this.fixInvalidData(user);
        this.plugin.getUserManager().addUser(user);
        this.plugin.getStatManager().updateStats(user);
        this.plugin.getScheduler().executeSync(() -> this.plugin.getEventHandler().callUserLoadEvent(user));
        this.plugin.getRewardManager().updatePermissions(user);
    }

    protected abstract User loadRaw(UUID var1) throws Exception;

    @NotNull
    public abstract UserState loadState(UUID var1) throws Exception;

    public abstract void applyState(UserState var1) throws Exception;

    public abstract void save(@NotNull User var1) throws Exception;

    public abstract void delete(UUID var1) throws Exception;

    public abstract List<UserState> loadStates(boolean var1) throws Exception;

    public void startAutoSaving() {
        if (!this.plugin.configBoolean(Option.AUTO_SAVE_ENABLED)) {
            return;
        }
        long interval = this.plugin.configInt(Option.AUTO_SAVE_INTERVAL_TICKS);
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                for (User user : StorageProvider.this.userManager.getOnlineUsers()) {
                    try {
                        if (user.isSaving()) continue;
                        StorageProvider.this.save(user);
                    }
                    catch (Exception e) {
                        user.setSaving(false);
                        StorageProvider.this.plugin.logger().warn("Error running auto-save on user data:");
                        e.printStackTrace();
                    }
                }
            }
        };
        this.plugin.getScheduler().timerAsync(task, interval * 50L, interval * 50L, TimeUnit.MILLISECONDS);
    }

    private void fixInvalidData(User user) {
        int startLevel = this.plugin.config().getStartLevel();
        for (Skill skill : user.getSkillLevelMap().keySet()) {
            if (user.getSkillLevel(skill) >= startLevel) continue;
            user.setSkillLevel(skill, startLevel);
        }
    }
}

