/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.stat;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.stat.LoadedStat;
import dev.aurelium.auraskills.common.stat.StatSupplier;
import dev.aurelium.auraskills.common.user.User;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class StatManager {
    protected final AuraSkillsPlugin plugin;
    private final Map<Stat, LoadedStat> statMap;
    private final StatSupplier supplier;

    public StatManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.statMap = new LinkedHashMap<Stat, LoadedStat>();
        this.supplier = new StatSupplier(this, plugin.getMessageProvider());
    }

    public StatSupplier getSupplier() {
        return this.supplier;
    }

    @NotNull
    public LoadedStat getStat(Stat stat) {
        LoadedStat loadedStat = this.statMap.get(stat);
        if (loadedStat == null) {
            throw new IllegalArgumentException("Stat " + stat + " is not loaded!");
        }
        return loadedStat;
    }

    public Collection<LoadedStat> getStats() {
        return this.statMap.values();
    }

    public Set<Stat> getEnabledStats() {
        LinkedHashSet<Stat> stats = new LinkedHashSet<Stat>();
        for (LoadedStat loaded : this.statMap.values()) {
            if (!loaded.options().enabled()) continue;
            stats.add(loaded.stat());
        }
        return stats;
    }

    public void register(Stat stat, LoadedStat loadedStat) {
        this.statMap.put(stat, loadedStat);
    }

    public void unregisterAll() {
        this.statMap.clear();
    }

    public abstract void reloadPlayer(User var1);

    public abstract <T> void reload(User var1, T var2);

    public abstract void reloadStat(User var1, Stat var2);

    public void updateStats(User user) {
        if (user == null) {
            return;
        }
        for (Stat stat : this.plugin.getStatRegistry().getValues()) {
            user.setStatLevel(stat, 0.0);
        }
        for (Skill skill : this.plugin.getSkillManager().getSkillValues()) {
            if (!user.hasSkillPermission(skill)) continue;
            this.plugin.getRewardManager().getRewardTable(skill).applyStats(user, user.getSkillLevel(skill));
        }
        for (String key : user.getStatModifiers().keySet()) {
            StatModifier modifier = user.getStatModifiers().get(key);
            user.addStatLevel(modifier.stat(), modifier.value());
        }
        this.reloadStats(user);
    }

    private void reloadStats(User user) {
        for (Stat stat : this.getEnabledStats()) {
            this.reloadStat(user, stat);
        }
    }

    public boolean isLoaded(Stat stat) {
        return this.statMap.containsKey(stat);
    }
}

