/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.stat;

import com.google.common.collect.ImmutableList;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.stat.LoadedStat;
import dev.aurelium.auraskills.common.stat.StatOptions;
import dev.aurelium.auraskills.common.stat.StatTraitConfig;
import dev.aurelium.auraskills.common.trait.LoadedTrait;
import dev.aurelium.auraskills.common.trait.TraitLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class StatLoader {
    private static final String FILE_NAME = "stats.yml";
    private final AuraSkillsPlugin plugin;
    private final ConfigurateLoader configurateLoader;
    private final TraitLoader traitLoader;

    public StatLoader(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        TypeSerializerCollection statSerializers = TypeSerializerCollection.builder().build();
        this.configurateLoader = new ConfigurateLoader(plugin, statSerializers);
        this.traitLoader = new TraitLoader(plugin);
    }

    public void loadStats() {
        try {
            this.plugin.getStatManager().unregisterAll();
            this.plugin.getTraitManager().unregisterAll();
            this.configurateLoader.updateUserFile(FILE_NAME);
            ConfigurationNode main = this.configurateLoader.loadUserFile(FILE_NAME);
            ConfigurationNode defined = this.plugin.getStatRegistry().getDefinedConfig();
            ConfigurationNode root = this.configurateLoader.loadContentAndMerge(defined, FILE_NAME, main);
            ConfigurationNode statsNode = root.node("stats");
            this.traitLoader.init();
            int statsLoaded = 0;
            int traitsLoaded = 0;
            ArrayList<Object> keys = new ArrayList<Object>(statsNode.childrenMap().keySet());
            keys.sort((o1, o2) -> {
                String stat1 = (String)o1;
                String stat2 = (String)o2;
                boolean is1Default = stat1.startsWith("auraskills/");
                boolean is2Default = stat2.startsWith("auraskills/");
                if (is1Default && is2Default) {
                    return 0;
                }
                if (is1Default) {
                    return -1;
                }
                if (is2Default) {
                    return 1;
                }
                return 0;
            });
            for (Object e : keys) {
                String statName = (String)e;
                Stat stat = (Stat)this.plugin.getStatRegistry().get(NamespacedId.fromString(statName));
                ConfigurationNode statNode = statsNode.node(statName);
                LoadedStat loadedStat = this.loadStat(stat, statNode);
                this.plugin.getStatManager().register(stat, loadedStat);
                ++statsLoaded;
                traitsLoaded += loadedStat.traits().size();
            }
            this.plugin.logger().info("Loaded " + statsLoaded + " stats and " + traitsLoaded + " traits");
        }
        catch (IOException e) {
            this.plugin.logger().warn("Error loading stats.yml file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private LoadedStat loadStat(Stat stat, ConfigurationNode config) {
        ConfigurationNode traitsNode = config.node("traits");
        Map<Trait, StatTraitConfig> traitConfigs = this.loadTraits(stat, traitsNode);
        ImmutableList traits = ImmutableList.copyOf(traitConfigs.keySet());
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        for (Object key : config.childrenMap().keySet()) {
            configMap.put((String)key, config.node(key).raw());
        }
        return new LoadedStat(stat, (ImmutableList<Trait>)traits, traitConfigs, new StatOptions(configMap));
    }

    private Map<Trait, StatTraitConfig> loadTraits(Stat stat, ConfigurationNode config) {
        LinkedHashMap<Trait, StatTraitConfig> traitConfigs = new LinkedHashMap<Trait, StatTraitConfig>();
        for (Object key : config.childrenMap().keySet()) {
            String traitName = (String)key;
            try {
                Trait trait = (Trait)this.plugin.getTraitRegistry().get(NamespacedId.fromString(traitName));
                this.createLoadedTrait(trait);
                ConfigurationNode traitNode = config.node(traitName);
                HashMap<String, Object> traitConfigMap = new HashMap<String, Object>();
                for (Object childKey : traitNode.childrenMap().keySet()) {
                    traitConfigMap.put((String)childKey, traitNode.node(childKey).raw());
                }
                traitConfigs.put(trait, new StatTraitConfig(traitConfigMap));
            }
            catch (IllegalArgumentException e) {
                this.plugin.logger().warn("Could not find trait with id " + traitName + " while loading stat " + stat.getId().toString());
            }
        }
        return traitConfigs;
    }

    private void createLoadedTrait(Trait trait) {
        try {
            LoadedTrait loadedTrait = this.traitLoader.loadTrait(trait);
            this.plugin.getTraitManager().register(trait, loadedTrait);
        }
        catch (SerializationException e) {
            this.plugin.logger().severe("Error loading trait " + trait.getId() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }
}

