/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source.type;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.parser.ParseException;
import com.google.common.collect.ImmutableMap;
import dev.aurelium.auraskills.api.source.SourceValues;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.source.Source;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class BlockSource
extends Source
implements BlockXpSource {
    private final String[] blocks;
    private final BlockXpSource.BlockTriggers[] triggers;
    private final boolean checkReplace;
    private final BlockXpSource.BlockXpSourceState[] states;
    private final BlockXpSource.BlockXpSourceState[] afterStates;
    private final String stateMultiplier;
    private final BlockXpSource.SupportBlockType supportBlockType;
    private final boolean trunk;
    private final boolean leaf;

    public BlockSource(AuraSkillsPlugin plugin, SourceValues values, String[] blocks, BlockXpSource.BlockTriggers[] triggers, boolean checkReplace, BlockXpSource.BlockXpSourceState[] states, BlockXpSource.BlockXpSourceState[] afterStates, String stateMultiplier, BlockXpSource.SupportBlockType supportBlockType, boolean trunk, boolean leaf) {
        super(plugin, values);
        this.blocks = blocks;
        this.triggers = triggers;
        this.checkReplace = checkReplace;
        this.states = states;
        this.afterStates = afterStates;
        this.stateMultiplier = stateMultiplier;
        this.supportBlockType = supportBlockType;
        this.trunk = trunk;
        this.leaf = leaf;
    }

    @Override
    public String getBlock() {
        return this.blocks[0];
    }

    @Override
    public String[] getBlocks() {
        return this.blocks;
    }

    @Override
    public BlockXpSource.BlockTriggers[] getTriggers() {
        return this.triggers;
    }

    @Override
    public boolean checkReplace() {
        return this.checkReplace;
    }

    @Override
    @Nullable
    public BlockXpSource.BlockXpSourceState[] getStates() {
        return this.states;
    }

    @Override
    @Nullable
    public BlockXpSource.BlockXpSourceState[] getAfterStates() {
        return this.afterStates;
    }

    @Override
    public double getStateMultiplier(String stateKey, Object stateValue) {
        String replaced = this.stateMultiplier.replace(stateKey, stateValue.toString());
        Expression expression = new Expression(replaced);
        try {
            return expression.evaluate().getNumberValue().doubleValue();
        }
        catch (EvaluationException | ParseException e) {
            e.printStackTrace();
            return 1.0;
        }
    }

    @Override
    public boolean hasStateMultiplier() {
        return !this.stateMultiplier.isEmpty();
    }

    @Override
    public boolean requiresSupportBlock(BlockXpSource.SupportBlockType direction) {
        return this.supportBlockType == direction;
    }

    @Override
    public boolean isTrunk() {
        return this.trunk;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    @Override
    public boolean isVersionValid() {
        for (String blockStr : this.blocks) {
            if (this.plugin.getPlatformUtil().isValidMaterial(blockStr)) continue;
            return false;
        }
        return true;
    }

    public static class BlockSourceState
    implements BlockXpSource.BlockXpSourceState {
        private final Map<String, Object> stateMap;

        public BlockSourceState(ImmutableMap<String, Object> stateMap) {
            this.stateMap = stateMap;
        }

        @Override
        public Map<String, Object> getStateMap() {
            return this.stateMap;
        }

        @Override
        public int getInt(String key) {
            return (Integer)this.stateMap.getOrDefault(key, 0);
        }

        @Override
        public double getDouble(String key) {
            return (Double)this.stateMap.getOrDefault(key, 0.0);
        }

        @Override
        public String getString(String key) {
            return (String)this.stateMap.getOrDefault(key, "");
        }

        @Override
        public boolean getBoolean(String key) {
            return (Boolean)this.stateMap.getOrDefault(key, false);
        }

        @Override
        public boolean containsKey(String key, Class<?> type) {
            Object obj = this.stateMap.get(key);
            if (obj == null) {
                return false;
            }
            return type.isInstance(obj);
        }
    }
}

