/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source.income;

import com.ezylang.evalex.Expression;
import dev.aurelium.auraskills.api.source.SourceIncome;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.source.income.ExpressionIncome;
import dev.aurelium.auraskills.common.source.income.FixedIncome;
import dev.aurelium.auraskills.common.source.income.XpIncome;
import org.spongepowered.configurate.ConfigurationNode;

public class IncomeLoader {
    private final AuraSkillsPlugin plugin;

    public IncomeLoader(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    public SourceIncome loadSourceIncome(ConfigurationNode source) {
        if (!source.node("income_per_xp").virtual()) {
            double incomePerXp = source.node("income_per_xp").getDouble();
            return new XpIncome(this.plugin, incomePerXp);
        }
        if (!source.node("income").virtual()) {
            double income = source.node("income").getDouble();
            return new FixedIncome(income);
        }
        if (!source.node("income_expression").virtual()) {
            String incomeExpression = source.node("income_expression").getString();
            Expression expression = new Expression(incomeExpression);
            return new ExpressionIncome(this.plugin, expression);
        }
        return this.getConfigDefaultIncome();
    }

    private SourceIncome getConfigDefaultIncome() {
        if (this.plugin.configBoolean(Option.JOBS_INCOME_USE_EXPRESSION)) {
            String expString = this.plugin.configString(Option.JOBS_INCOME_DEFAULT_EXPRESSION);
            Expression expression = new Expression(expString);
            return new ExpressionIncome(this.plugin, expression);
        }
        double incomePerXp = this.plugin.configDouble(Option.JOBS_INCOME_DEFAULT_INCOME_PER_XP);
        return new XpIncome(this.plugin, incomePerXp);
    }
}

