/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.source.SourceType;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.source.SourceTypes;
import java.util.HashMap;
import java.util.Map;

public class SourceTypeRegistry {
    private final AuraSkillsPlugin plugin;
    private final Map<NamespacedId, SourceType> sourceTypes;

    public SourceTypeRegistry(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.sourceTypes = new HashMap<NamespacedId, SourceType>();
    }

    public SourceType get(NamespacedId id) throws IllegalArgumentException {
        SourceType sourceType = this.sourceTypes.get(id);
        if (sourceType != null) {
            return sourceType;
        }
        throw new IllegalArgumentException("Source type with id " + id + " does not exist");
    }

    public void register(NamespacedId id, SourceType sourceType) {
        this.sourceTypes.put(id, sourceType);
    }

    public void unregister(NamespacedId id) {
        this.sourceTypes.remove(id);
    }

    public void registerDefaults() {
        for (SourceTypes defaultType : SourceTypes.values()) {
            this.sourceTypes.put(defaultType.getId(), defaultType);
        }
    }
}

