/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.source;

import dev.aurelium.auraskills.api.item.ItemFilter;
import dev.aurelium.auraskills.api.item.ItemFilterMeta;
import dev.aurelium.auraskills.api.item.LootItemFilter;
import dev.aurelium.auraskills.api.item.PotionData;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.BaseContext;
import dev.aurelium.auraskills.api.source.SourceContext;
import dev.aurelium.auraskills.api.source.SourceType;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.source.XpSourceParser;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.source.SourceTag;
import dev.aurelium.auraskills.common.source.parser.BlockSourceParser;
import dev.aurelium.auraskills.common.source.parser.util.ItemFilterMetaParser;
import dev.aurelium.auraskills.common.source.parser.util.ItemFilterParser;
import dev.aurelium.auraskills.common.source.parser.util.LootItemFilterParser;
import dev.aurelium.auraskills.common.source.parser.util.PotionDataParser;
import dev.aurelium.auraskills.common.source.parser.util.UtilitySerializer;
import dev.aurelium.auraskills.common.util.file.FileUtil;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class SourceLoader {
    private final AuraSkillsPlugin plugin;
    private final ConfigurateLoader configurateLoader;

    public SourceLoader(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        BaseContext context = new BaseContext(plugin.getApi());
        TypeSerializerCollection sourceSerializers = TypeSerializerCollection.builder().register(ItemFilterMeta.class, new UtilitySerializer<ItemFilterMeta>(new ItemFilterMetaParser(), context)).register(ItemFilter.class, new UtilitySerializer<ItemFilter>(new ItemFilterParser(), context)).register(LootItemFilter.class, new UtilitySerializer<LootItemFilter>(new LootItemFilterParser(), context)).register(PotionData.class, new UtilitySerializer<PotionData>(new PotionDataParser(), context)).register(BlockXpSource.BlockXpSourceState.class, new UtilitySerializer<BlockXpSource.BlockXpSourceState>(new BlockSourceParser.BlockSourceStateParser(), context)).build();
        this.configurateLoader = new ConfigurateLoader(plugin, sourceSerializers);
    }

    public List<XpSource> loadSources(Skill skill, File contentDirectory, boolean loadEmbedded) {
        File sourceFile = new File(contentDirectory, "sources/" + skill.name().toLowerCase(Locale.ROOT) + ".yml");
        String fileName = "sources/" + skill.name().toLowerCase(Locale.ROOT) + ".yml";
        try {
            HashMap<String, ConfigurationNode> embeddedSources = new HashMap<String, ConfigurationNode>();
            ConfigurationNode fileDefault = null;
            ConfigurationNode embedded = this.configurateLoader.loadEmbeddedFileOrNull(fileName);
            if (loadEmbedded && embedded != null) {
                fileDefault = embedded.node("default");
                this.addToMap(embedded, embeddedSources);
            }
            ConfigurationNode user = this.configurateLoader.loadUserFile(sourceFile);
            ConfigurationNode userDefault = user.node("default");
            HashMap<String, ConfigurationNode> userSources = new HashMap<String, ConfigurationNode>();
            this.addToMap(user, userSources);
            if (this.updateUserFile(embeddedSources, userSources, sourceFile, user)) {
                user = this.configurateLoader.loadUserFile(sourceFile);
                userDefault = user.node("default");
                userSources = new HashMap();
                this.addToMap(user, userSources);
            }
            HashMap<String, ConfigurationNode> sources = new HashMap<String, ConfigurationNode>();
            for (String sourceName : userSources.keySet()) {
                ConfigurationNode merged;
                ConfigurationNode userNode = (ConfigurationNode)userSources.get(sourceName);
                if (loadEmbedded && fileDefault != null) {
                    ConfigurationNode embeddedNode = (ConfigurationNode)embeddedSources.get(sourceName);
                    merged = this.configurateLoader.mergeNodes(fileDefault, embeddedNode, userDefault, userNode);
                } else {
                    merged = this.configurateLoader.mergeNodes(userDefault, userNode);
                }
                sources.put(sourceName, merged);
            }
            ArrayList<XpSource> deserializedSources = new ArrayList<XpSource>();
            for (Map.Entry entry : sources.entrySet()) {
                String sourceName = (String)entry.getKey();
                ConfigurationNode sourceNode = (ConfigurationNode)entry.getValue();
                NamespacedId id = NamespacedId.of("auraskills", sourceName);
                String type = sourceNode.node("type").getString();
                if (type == null) {
                    throw new IllegalArgumentException("Source " + id + " must specify a type");
                }
                this.applyNodeReplacements(sourceNode, sourceNode, sourceName);
                XpSource source = this.parseSourceFromType(type, sourceNode, sourceName);
                if (source == null || !(source.getXp() > 0.0)) continue;
                deserializedSources.add(source);
                this.registerMenuItem(source, sourceNode);
            }
            return deserializedSources;
        }
        catch (Exception e) {
            this.plugin.logger().warn("Error loading source file " + fileName + ": " + e.getMessage());
            e.printStackTrace();
            return new ArrayList<XpSource>();
        }
    }

    public boolean updateUserFile(Map<String, ConfigurationNode> embeddedSources, Map<String, ConfigurationNode> userSources, File userFile, ConfigurationNode user) throws IOException {
        String skillName = userFile.getName();
        if (skillName.contains("alchemy") || skillName.contains("agility") || skillName.contains("enchanting")) {
            return false;
        }
        int added = 0;
        for (Map.Entry<String, ConfigurationNode> embeddedEntry : embeddedSources.entrySet()) {
            String sourceName = embeddedEntry.getKey();
            if (userSources.containsKey(sourceName)) continue;
            ConfigurationNode embeddedSource = embeddedEntry.getValue();
            user.node("sources").node(sourceName).set(embeddedSource);
            ++added;
        }
        if (added > 0) {
            FileUtil.saveYamlFile(userFile, user);
            String path = this.plugin.getPluginFolder().toPath().relativize(userFile.toPath()).toString();
            this.plugin.logger().info("Updated " + path + " with " + added + " new source(s). If you had removed default sources they will be added back. Set the xp of the source to 0 to disable them instead.");
            return true;
        }
        return false;
    }

    public Map<SourceTag, List<XpSource>> loadTags(Skill skill, File contentDirectory) {
        File sourceFile = new File(contentDirectory, "sources/" + skill.name().toLowerCase(Locale.ROOT) + ".yml");
        try {
            HashMap<SourceTag, List<XpSource>> tagMap = new HashMap<SourceTag, List<XpSource>>();
            ConfigurationNode user = this.configurateLoader.loadUserFile(sourceFile);
            for (SourceTag tag : SourceTag.ofSkill(skill)) {
                ConfigurationNode tagNode = user.node("tags").node(tag.name().toLowerCase(Locale.ROOT));
                ArrayList<XpSource> sourceList = new ArrayList<XpSource>();
                for (String sourceString : tagNode.getList(String.class, new ArrayList())) {
                    if (sourceString.equals("*")) {
                        sourceList.addAll(skill.getSources());
                        continue;
                    }
                    if (sourceString.startsWith("!")) {
                        NamespacedId id = NamespacedId.fromDefault(sourceString.substring(1));
                        XpSource source = this.plugin.getSkillManager().getSourceById(id);
                        if (source == null) continue;
                        sourceList.remove(source);
                        continue;
                    }
                    XpSource source = this.plugin.getSkillManager().getSourceById(NamespacedId.fromDefault(sourceString));
                    if (source == null) continue;
                    sourceList.add(source);
                }
                tagMap.put(tag, sourceList);
            }
            return tagMap;
        }
        catch (Exception e) {
            this.plugin.logger().warn("Error loading tags in sources file " + sourceFile.getName() + ": " + e.getMessage());
            e.printStackTrace();
            HashMap<SourceTag, List<XpSource>> fallback = new HashMap<SourceTag, List<XpSource>>();
            for (SourceTag tag : SourceTag.ofSkill(skill)) {
                fallback.put(tag, new ArrayList());
            }
            return fallback;
        }
    }

    private void addToMap(ConfigurationNode root, Map<String, ConfigurationNode> sourcesMap) {
        root.node("sources").childrenMap().forEach((key, sourceNode) -> {
            String sourceName = key.toString();
            if (!sourceNode.isMap()) {
                try {
                    sourceNode.node("_value").set(sourceNode.raw());
                }
                catch (SerializationException e) {
                    throw new RuntimeException(e);
                }
            }
            sourcesMap.put(sourceName, (ConfigurationNode)sourceNode);
        });
    }

    @Nullable
    private XpSource parseSourceFromType(String type, ConfigurationNode sourceNode, String sourceName) {
        NamespacedId sourceTypeId = NamespacedId.fromDefault(type.toLowerCase(Locale.ROOT));
        SourceType sourceType = this.plugin.getSourceTypeRegistry().get(sourceTypeId);
        XpSourceParser<?> parser = sourceType.getParser();
        SourceContext context = new SourceContext(this.plugin.getApi(), sourceType, sourceName);
        try {
            XpSource source = (XpSource)parser.parse(sourceNode, context);
            if (source.isVersionValid()) {
                return source;
            }
            return null;
        }
        catch (SerializationException e) {
            throw new IllegalArgumentException("Error deserializing source of type " + type);
        }
    }

    private void registerMenuItem(XpSource source, ConfigurationNode sourceNode) {
        ConfigurationNode unitNode;
        ConfigurationNode menuNode = sourceNode.node("menu_item");
        if (!menuNode.virtual()) {
            this.plugin.getItemRegistry().getSourceMenuItems().parseAndRegisterMenuItem(source, menuNode);
        }
        if (!(unitNode = sourceNode.node("unit")).virtual()) {
            this.plugin.getItemRegistry().getSourceMenuItems().registerSourceUnit(source, unitNode.getString());
        }
    }

    private void applyNodeReplacements(ConfigurationNode baseNode, ConfigurationNode parentNode, String sourceName) throws SerializationException {
        for (ConfigurationNode configurationNode : baseNode.childrenMap().values()) {
            String text = configurationNode.getString();
            if (text != null) {
                List<String> placeholders = TextUtil.getPlaceholders(text);
                for (String placeholder : placeholders) {
                    String[] path;
                    String replacement;
                    if (placeholder.equals("key")) {
                        configurationNode.set(text.replace("{key}", sourceName));
                        continue;
                    }
                    if (placeholder.equals("value")) {
                        configurationNode.set(text.replace("{value}", String.valueOf(parentNode.node("_value").raw())));
                    }
                    if ((replacement = parentNode.node(path = placeholder.split("\\.")).getString()) == null) continue;
                    configurationNode.set(text.replace("{" + placeholder + "}", replacement));
                }
                continue;
            }
            this.applyNodeReplacements(configurationNode, parentNode, sourceName);
        }
    }
}

