/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.skill;

import dev.aurelium.auraskills.api.skill.CustomSkill;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.SkillProvider;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.registry.Registry;
import java.util.ArrayList;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class SkillRegistry
extends Registry<Skill, SkillProvider> {
    public SkillRegistry(AuraSkillsPlugin plugin) {
        super(plugin, Skill.class, SkillProvider.class);
        this.registerDefaults();
    }

    @Override
    public void registerDefaults() {
        for (Skills skill : Skills.values()) {
            this.register(skill.getId(), skill, this.plugin.getSkillManager().getSupplier());
        }
    }

    public ConfigurationNode getDefinedConfig() throws SerializationException {
        CommentedConfigurationNode root = CommentedConfigurationNode.root();
        for (Skill skill : this.getValues()) {
            if (!(skill instanceof CustomSkill)) continue;
            CustomSkill customSkill = (CustomSkill)skill;
            ConfigurationNode skillNode = root.node("skills", skill.getId().toString());
            ArrayList abilityList = new ArrayList();
            customSkill.getDefined().getAbilities().forEach(ability -> abilityList.add(ability.getId().toString()));
            if (!abilityList.isEmpty()) {
                skillNode.node("abilities").set(abilityList);
            }
            if (customSkill.getDefined().getManaAbility() != null) {
                skillNode.node("mana_abilities").set(customSkill.getDefined().getManaAbility().getId().toString());
            }
            ConfigurationNode options = skillNode.node("options");
            options.node("enabled").set(true);
            options.node("max_level").set(97);
            options.node("check_multiplier_permissions").set(true);
        }
        return root;
    }
}

