/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.skill;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.SourceType;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.ConfigurateLoader;
import dev.aurelium.auraskills.common.skill.LoadedSkill;
import dev.aurelium.auraskills.common.skill.SkillSupplier;
import dev.aurelium.auraskills.common.source.SourceTag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class SkillManager {
    private final AuraSkillsPlugin plugin;
    private final Map<Skill, LoadedSkill> skillMap;
    private final Map<SourceTag, List<XpSource>> sourceTagMap;
    private final SkillSupplier supplier;
    private final Set<File> contentDirectories;

    public SkillManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.skillMap = new LinkedHashMap<Skill, LoadedSkill>();
        this.sourceTagMap = new HashMap<SourceTag, List<XpSource>>();
        this.supplier = new SkillSupplier(this, plugin.getMessageProvider());
        this.contentDirectories = new LinkedHashSet<File>();
    }

    public SkillSupplier getSupplier() {
        return this.supplier;
    }

    public void register(Skill skill, LoadedSkill loadedSkill) {
        this.skillMap.put(skill, loadedSkill);
    }

    public void unregisterAll() {
        this.skillMap.clear();
    }

    @NotNull
    public LoadedSkill getSkill(Skill skill) {
        LoadedSkill loadedSkill = this.skillMap.get(skill);
        if (loadedSkill == null) {
            throw new IllegalArgumentException("Skill " + skill + " is not loaded!");
        }
        return loadedSkill;
    }

    public Collection<LoadedSkill> getSkills() {
        return this.skillMap.values();
    }

    public Set<Skill> getSkillValues() {
        HashSet<Skill> skills = new HashSet<Skill>();
        for (LoadedSkill loaded : this.skillMap.values()) {
            skills.add(loaded.skill());
        }
        return skills;
    }

    public Set<Skill> getEnabledSkills() {
        LinkedHashSet<Skill> skills = new LinkedHashSet<Skill>();
        for (LoadedSkill loaded : this.skillMap.values()) {
            if (!loaded.skill().isEnabled()) continue;
            skills.add(loaded.skill());
        }
        return skills;
    }

    public boolean isLoaded(Skill skill) {
        return this.skillMap.containsKey(skill);
    }

    @NotNull
    public <T extends XpSource> List<SkillSource<T>> getSourcesOfType(Class<T> typeClass) {
        ArrayList<SkillSource<T>> list = new ArrayList<SkillSource<T>>();
        for (Skill skill : this.getEnabledSkills()) {
            for (XpSource source : skill.getSources()) {
                if (!typeClass.isAssignableFrom(source.getClass())) continue;
                list.add(new SkillSource<XpSource>(source, skill));
            }
        }
        return list;
    }

    public boolean isSourceEnabled(SourceType sourceType) {
        for (Skill skill : this.getEnabledSkills()) {
            for (XpSource source : skill.getSources()) {
                if (!sourceType.equals(source.getType())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public XpSource getSourceById(NamespacedId id) {
        for (Skill skill : this.getSkillValues()) {
            for (XpSource source : skill.getSources()) {
                if (!source.getId().equals(id)) continue;
                return source;
            }
        }
        return null;
    }

    @Nullable
    public <T extends XpSource> SkillSource<T> getSingleSourceOfType(Class<T> typeClass) {
        List<SkillSource<T>> sources = this.plugin.getSkillManager().getSourcesOfType(typeClass);
        if (sources.isEmpty()) {
            return null;
        }
        return sources.get(0);
    }

    public void registerSourceTag(SourceTag tag, List<XpSource> sources) {
        this.sourceTagMap.put(tag, sources);
    }

    @NotNull
    public List<XpSource> getSourcesWithTag(SourceTag tag) {
        return this.sourceTagMap.getOrDefault((Object)tag, new ArrayList());
    }

    public boolean hasTag(XpSource source, SourceTag tag) {
        return ((List)this.sourceTagMap.getOrDefault((Object)tag, new ArrayList())).contains(source);
    }

    public Set<File> getContentDirectories() {
        return this.contentDirectories;
    }

    public void addContentDirectory(File file) {
        this.contentDirectories.add(file);
    }

    public Map<Skill, Boolean> loadConfigEnabledMap() {
        HashMap<Skill, Boolean> map = new HashMap<Skill, Boolean>();
        ConfigurateLoader loader = new ConfigurateLoader(this.plugin, TypeSerializerCollection.builder().build());
        try {
            ConfigurationNode root = loader.loadUserFile(new File(this.plugin.getPluginFolder(), "skills.yml"));
            for (Skills skill : Skills.values()) {
                ConfigurationNode node = root.node("skills", skill.getId().toString(), "options", "enabled");
                if (node.virtual()) {
                    map.put(skill, false);
                    continue;
                }
                map.put(skill, node.getBoolean(false));
            }
        }
        catch (IOException e) {
            this.plugin.logger().warn("Failed to load skills.yml to check for enabled skills");
            e.printStackTrace();
        }
        return map;
    }
}

