/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.reward.type;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.message.type.LevelerFormat;
import dev.aurelium.auraskills.common.reward.SkillReward;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;

public class StatReward
extends SkillReward {
    private final Stat stat;
    private final double value;

    public StatReward(AuraSkillsPlugin plugin, Stat stat, double value) {
        super(plugin);
        this.stat = stat;
        this.value = value;
    }

    @Override
    public void giveReward(User user, Skill skill, int level) {
        user.addStatLevel(this.stat, this.value);
        this.plugin.getStatManager().reloadStat(user, this.stat);
    }

    public Stat getStat() {
        return this.stat;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public String getMenuMessage(User player, Locale locale, Skill skill, int level) {
        String format = this.plugin.getMenuHelper().getFormat("level_progression", "stat_reward_entry");
        return TextUtil.replace(format, "{color}", this.stat.getColor(locale), "{num}", this.getDisplayValue(locale), "{symbol}", this.stat.getSymbol(locale), "{stat}", this.stat.getDisplayName(locale, false));
    }

    @Override
    public String getChatMessage(User player, Locale locale, Skill skill, int level) {
        return this.plugin.getMessageProvider().applyFormatting(TextUtil.replace(this.plugin.getMsg(LevelerFormat.STAT_LEVEL, locale), "{color}", this.stat.getColor(locale), "{num}", this.getDisplayValue(locale), "{symbol}", this.stat.getSymbol(locale), "{stat}", this.stat.getDisplayName(locale, false)));
    }

    private String getDisplayValue(Locale locale) {
        if (this.stat.getTraits().contains(Traits.HP) && this.stat.getTraitModifier(Traits.HP) == 1.0) {
            return Traits.HP.getMenuDisplay(this.value, locale);
        }
        return NumberUtil.format1(this.value);
    }
}

