/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.reward.type;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.parser.ParseException;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.hooks.EconomyHook;
import dev.aurelium.auraskills.common.reward.SkillReward;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class MoneyReward
extends SkillReward {
    private final double amount;
    @Nullable
    private final String formula;

    public MoneyReward(AuraSkillsPlugin plugin, double amount, @Nullable String formula) {
        super(plugin);
        this.amount = amount;
        this.formula = formula;
    }

    @Override
    public void giveReward(User user, Skill skill, int level) {
        if (!this.hooks.isRegistered(EconomyHook.class)) {
            return;
        }
        this.hooks.getHook(EconomyHook.class).deposit(user, this.getAmount(level));
    }

    public double getAmount(int level) {
        if (this.formula == null && this.amount > 0.0) {
            return this.amount;
        }
        if (this.formula != null) {
            Expression expression = new Expression(this.formula);
            expression.with("level", level);
            try {
                return expression.evaluate().getNumberValue().doubleValue();
            }
            catch (EvaluationException | ParseException e) {
                this.plugin.logger().warn("Failed to evaluate money reward expression " + expression);
                e.printStackTrace();
            }
        }
        return 0.0;
    }

    @Override
    public String getMenuMessage(User player, Locale locale, Skill skill, int level) {
        return "";
    }

    @Override
    public String getChatMessage(User player, Locale locale, Skill skill, int level) {
        return "";
    }
}

