/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.reward.parser;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.message.type.RewardMessage;
import dev.aurelium.auraskills.common.reward.SkillReward;
import dev.aurelium.auraskills.common.reward.builder.ItemRewardBuilder;
import dev.aurelium.auraskills.common.reward.parser.RewardParser;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Map;

public class ItemRewardParser
extends RewardParser {
    public ItemRewardParser(AuraSkillsPlugin plugin) {
        super(plugin);
    }

    @Override
    public SkillReward parse(Map<?, ?> map) {
        RewardMessage messageKey;
        String key = this.getString(map, "key");
        NamespacedId itemKey = NamespacedId.fromDefault(key);
        ItemRewardBuilder builder = new ItemRewardBuilder(this.plugin).itemKey(itemKey);
        int amount = 1;
        if (map.containsKey("amount")) {
            int definedAmount = this.getInt(map, "amount");
            builder.amount(definedAmount);
            amount = definedAmount;
        } else {
            int registryAmount = this.plugin.getItemRegistry().getItemAmount(itemKey);
            if (registryAmount != 0) {
                amount = registryAmount;
            }
        }
        if (map.containsKey("menu_message")) {
            builder.menuMessage(this.getString(map, "menu_message"));
        } else {
            String effectiveName = this.plugin.getItemRegistry().getEffectiveItemName(itemKey);
            if (effectiveName != null) {
                messageKey = amount == 1 ? RewardMessage.ITEM_DEFAULT_MENU_MESSAGE : RewardMessage.ITEM_DEFAULT_MENU_MESSAGE_MULTIPLE;
                builder.menuMessage(TextUtil.replace(this.plugin.getMsg(messageKey, this.plugin.getDefaultLanguage()), "{display_name}", effectiveName, "{amount}", String.valueOf(amount), "{key}", key));
            }
        }
        if (map.containsKey("chat_message")) {
            builder.chatMessage(this.getString(map, "chat_message"));
        } else {
            String effectiveName = this.plugin.getItemRegistry().getEffectiveItemName(itemKey);
            if (effectiveName != null) {
                messageKey = amount == 1 ? RewardMessage.ITEM_DEFAULT_CHAT_MESSAGE : RewardMessage.ITEM_DEFAULT_CHAT_MESSAGE_MULTIPLE;
                builder.chatMessage(TextUtil.replace(this.plugin.getMsg(messageKey, this.plugin.getDefaultLanguage()), "{display_name}", effectiveName, "{amount}", String.valueOf(amount), "{key}", key));
            }
        }
        if (map.containsKey("message")) {
            String message = this.getString(map, "message");
            builder.chatMessage(message).menuMessage(message);
        }
        return builder.build();
    }
}

