/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.reward;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.reward.RewardTable;
import dev.aurelium.auraskills.common.reward.RewardType;
import dev.aurelium.auraskills.common.reward.SkillReward;
import dev.aurelium.auraskills.common.reward.parser.RewardParser;
import dev.aurelium.auraskills.common.reward.type.CommandReward;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.DataUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class RewardManager {
    protected final AuraSkillsPlugin plugin;
    protected final Map<Skill, RewardTable> rewardTables;

    public RewardManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.rewardTables = new HashMap<Skill, RewardTable>();
    }

    public RewardTable getRewardTable(Skill skill) {
        return this.rewardTables.getOrDefault(skill, new RewardTable(this.plugin));
    }

    public abstract void loadRewards();

    protected int loadPatterns(RewardTable rewardTable, List<Map<?, ?>> patterns, File rewardsFile, int maxLevel) {
        int patternsLoaded = 0;
        for (int index = 0; index < patterns.size(); ++index) {
            Map<?, ?> rewardMap = patterns.get(index);
            try {
                SkillReward reward = this.parseReward(rewardMap);
                if (reward == null) continue;
                Object patternObj = DataUtil.getElement(rewardMap, "pattern");
                if (!(patternObj instanceof Map)) {
                    throw new IllegalArgumentException("Pattern must be a section");
                }
                Map patternMap = (Map)patternObj;
                int start = patternMap.containsKey("start") ? DataUtil.getInt(patternMap, "start") : this.plugin.configInt(Option.START_LEVEL) + 1;
                int interval = DataUtil.getInt(patternMap, "interval");
                int stop = maxLevel;
                if (patternMap.containsKey("stop")) {
                    stop = DataUtil.getInt(patternMap, "stop");
                }
                if (stop > maxLevel) {
                    stop = maxLevel;
                }
                for (int level = start; level <= stop; level += interval) {
                    rewardTable.addReward(reward, level);
                }
                ++patternsLoaded;
                continue;
            }
            catch (IllegalArgumentException e) {
                this.plugin.logger().warn("Error while loading rewards file " + rewardsFile.getName() + " at path patterns.[" + index + "]: " + e.getMessage());
            }
        }
        return patternsLoaded;
    }

    @Nullable
    protected SkillReward parseReward(Map<?, ?> map) {
        String type = DataUtil.getString(map, "type");
        for (RewardType rewardType : RewardType.values()) {
            if (!rewardType.getKey().equalsIgnoreCase(type)) continue;
            try {
                Constructor<? extends RewardParser> constructor = rewardType.getParser().getConstructor(AuraSkillsPlugin.class);
                return constructor.newInstance(this.plugin).parse(map);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new IllegalArgumentException("Unrecognized reward type: " + type);
    }

    public List<Skill> getSkillsLeveledBy(Stat stat) {
        ArrayList<Skill> skillsLeveledBy = new ArrayList<Skill>();
        block0: for (Skill skill : this.plugin.getSkillRegistry().getValues()) {
            RewardTable table;
            if (!skill.isEnabled() || (table = this.rewardTables.get(skill)) == null) continue;
            for (Stat statLeveled : table.getStatsLeveled()) {
                if (!statLeveled.equals(stat)) continue;
                skillsLeveledBy.add(skill);
                continue block0;
            }
        }
        return skillsLeveledBy;
    }

    public void updatePermissions(User user) {
        if (user == null) {
            return;
        }
        for (Skill skill : this.plugin.getSkillManager().getSkillValues()) {
            this.plugin.getRewardManager().getRewardTable(skill).applyPermissions(user, user.getSkillLevel(skill));
        }
    }

    public void applyLevelUpCommands(User user, Skill skill, int oldLevel, int newLevel) {
        if (newLevel > oldLevel) {
            for (int i = oldLevel + 1; i <= newLevel; ++i) {
                for (CommandReward reward : this.plugin.getRewardManager().getRewardTable(skill).searchRewards(CommandReward.class, i)) {
                    reward.giveReward(user, skill, i);
                }
            }
        }
    }

    public void applyRevertCommands(User user, Skill skill, int oldLevel, int newLevel) {
        if (newLevel < oldLevel) {
            for (int i = oldLevel; i > newLevel; --i) {
                for (CommandReward reward : this.plugin.getRewardManager().getRewardTable(skill).searchRewards(CommandReward.class, i)) {
                    reward.executeRevert(user, skill, i);
                }
            }
        }
    }
}

