/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.region;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.region.BlockPosition;
import dev.aurelium.auraskills.common.region.ChunkCoordinate;
import dev.aurelium.auraskills.common.region.ChunkData;
import dev.aurelium.auraskills.common.region.Region;
import dev.aurelium.auraskills.common.region.RegionCoordinate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.querz.nbt.io.NBTUtil;
import net.querz.nbt.io.NamedTag;
import net.querz.nbt.tag.CompoundTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.Tag;
import org.jetbrains.annotations.Nullable;

public abstract class RegionManager {
    protected final AuraSkillsPlugin plugin;
    protected final ConcurrentMap<RegionCoordinate, Region> regions;
    private boolean saving;

    public RegionManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.regions = new ConcurrentHashMap<RegionCoordinate, Region>();
        this.saving = false;
    }

    @Nullable
    public Region getRegion(RegionCoordinate regionCoordinate) {
        return (Region)this.regions.get(regionCoordinate);
    }

    public abstract boolean isChunkLoaded(String var1, int var2, int var3);

    public void clearRegionMap() {
        this.regions.clear();
    }

    public void setRegion(RegionCoordinate coordinate, Region region) {
        this.regions.put(coordinate, region);
    }

    public void loadRegion(Region region) {
        if (region.isLoading()) {
            return;
        }
        region.setLoading(true);
        RegionCoordinate regionCoordinate = new RegionCoordinate(region.getWorldName(), region.getX(), region.getZ());
        String worldName = regionCoordinate.getWorldName();
        int regionX = regionCoordinate.getX();
        int regionZ = regionCoordinate.getZ();
        File file = new File(this.plugin.getPluginFolder() + "/regiondata/" + worldName + "/r." + regionX + "." + regionZ + ".asrg");
        if (file.exists()) {
            if (this.saving) {
                region.setReload(true);
            }
            try {
                this.loadNbtFile(file, region);
            }
            catch (IOException e) {
                boolean deleted = file.delete();
                if (deleted) {
                    this.plugin.logger().warn("Deleted " + file.getName() + " because it was corrupted, this won't affect anything");
                }
                region.setReload(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                region.setReload(false);
            }
        }
        region.setLoading(false);
    }

    private void loadNbtFile(File file, Region region) throws IOException {
        NamedTag namedTag = NBTUtil.read(file);
        Tag<?> tag = namedTag.getTag();
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            for (String key : compoundTag.keySet()) {
                if (!key.startsWith("chunk")) continue;
                int commaIndex = key.indexOf(",");
                byte chunkX = Byte.parseByte(key.substring(key.indexOf("[") + 1, commaIndex));
                byte chunkZ = Byte.parseByte(key.substring(commaIndex + 1, key.lastIndexOf("]")));
                CompoundTag chunkCompound = compoundTag.getCompoundTag(key);
                ChunkCoordinate chunkCoordinate = new ChunkCoordinate(chunkX, chunkZ);
                this.loadChunk(region, chunkCoordinate, chunkCompound);
            }
        }
        region.setReload(false);
    }

    private void loadChunk(Region region, ChunkCoordinate chunkCoordinate, CompoundTag compound) {
        ChunkData chunkData = region.getChunkData(chunkCoordinate);
        if (chunkData == null) {
            chunkData = new ChunkData(region, chunkCoordinate.getX(), chunkCoordinate.getZ());
        }
        ListTag<?> placedBlocks = compound.getListTag("placed_blocks");
        for (CompoundTag block : placedBlocks.asCompoundTagList()) {
            int x = block.getInt("x");
            int y = block.getInt("y");
            int z = block.getInt("z");
            chunkData.addPlacedBlock(new BlockPosition(x, y, z));
        }
        region.setChunkData(chunkCoordinate, chunkData);
    }

    private void saveRegion(String worldName, int regionX, int regionZ) {
        block13: {
            RegionCoordinate regionCoordinate = new RegionCoordinate(worldName, regionX, regionZ);
            Region region = this.getRegion(regionCoordinate);
            if (region == null) {
                return;
            }
            if (region.getChunkMap().isEmpty()) {
                return;
            }
            File file = new File(this.plugin.getPluginFolder() + "/regiondata/" + worldName + "/r." + regionX + "." + regionZ + ".asrg");
            try {
                NamedTag namedTag;
                if (!file.exists()) {
                    File parent = file.getParentFile();
                    if (parent != null && !parent.exists() && !parent.mkdirs()) {
                        this.plugin.logger().warn("Failed to create directory " + parent.getName());
                    }
                    NBTUtil.write(new NamedTag(file.getName(), new CompoundTag()), file);
                }
                if (!((namedTag = NBTUtil.read(file)).getTag() instanceof CompoundTag)) {
                    namedTag.setTag(new CompoundTag());
                }
                CompoundTag compoundTag = (CompoundTag)namedTag.getTag();
                for (ChunkData chunkData : region.getChunkMap().values()) {
                    this.saveChunk(compoundTag, chunkData);
                }
                if (compoundTag.keySet().isEmpty()) {
                    if (file.exists()) {
                        try {
                            Files.delete(file.toPath());
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    NBTUtil.write(namedTag, file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                boolean deleted = file.delete();
                if (!deleted) break block13;
                this.plugin.logger().warn("Deleted " + file.getName() + " because it was corrupted, this won't affect anything");
            }
        }
    }

    private void saveChunk(CompoundTag compound, ChunkData chunkData) {
        ListTag<CompoundTag> placedBlocks;
        ListTag<?> listTag;
        String chunkName = "chunk[" + chunkData.getX() + "," + chunkData.getZ() + "]";
        CompoundTag chunk = compound.getCompoundTag(chunkName);
        if (chunk == null) {
            chunk = new CompoundTag();
            compound.put(chunkName, chunk);
        }
        if ((listTag = chunk.getListTag("placed_blocks")) != null) {
            placedBlocks = listTag.asCompoundTagList();
        } else {
            placedBlocks = new ListTag<CompoundTag>(CompoundTag.class);
            chunk.put("placed_blocks", placedBlocks);
        }
        placedBlocks.clear();
        for (BlockPosition block : chunkData.getPlacedBlocks().keySet()) {
            CompoundTag blockCompound = new CompoundTag();
            blockCompound.putInt("x", block.getX());
            blockCompound.putInt("y", block.getY());
            blockCompound.putInt("z", block.getZ());
            placedBlocks.add(blockCompound);
        }
        if (placedBlocks.size() == 0) {
            chunk.remove("placed_blocks");
        }
        if (chunk.keySet().isEmpty()) {
            compound.remove(chunkName);
        }
    }

    public void saveAllRegions(boolean clearUnused, boolean serverShutdown) {
        if (this.saving && !serverShutdown) {
            return;
        }
        this.saving = true;
        for (Region region : this.regions.values()) {
            try {
                this.saveRegion(region.getWorldName(), region.getX(), region.getZ());
                if (!clearUnused || !this.isRegionUnused(region)) continue;
                this.regions.remove(new RegionCoordinate(region.getWorldName(), region.getX(), region.getZ()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!serverShutdown) {
            this.plugin.getScheduler().scheduleSync(() -> {
                this.saving = false;
            }, 1L, TimeUnit.SECONDS);
        } else {
            this.saving = false;
        }
    }

    private boolean isRegionUnused(Region region) {
        for (int chunkX = region.getX() * 32; chunkX < region.getX() * 32 + 32; ++chunkX) {
            for (int chunkZ = region.getZ() * 32; chunkZ < region.getZ() * 32 + 32; ++chunkZ) {
                if (!this.isChunkLoaded(region.getWorldName(), chunkX, chunkZ)) continue;
                return false;
            }
        }
        return true;
    }
}

