/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.migration;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.util.file.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class FileUserMigrator {
    private final AuraSkillsPlugin plugin;

    FileUserMigrator(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    public void migrate() {
        File playerDataDir = new File(this.plugin.getPluginFolder().getParentFile(), "AureliumSkills/playerdata");
        if (!playerDataDir.exists() || !playerDataDir.isDirectory()) {
            return;
        }
        File userDataDir = new File(this.plugin.getPluginFolder(), "userdata");
        File[] files = playerDataDir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        this.plugin.logger().warn("[Migrator] Found AureliumSkills/playerdata files, attempting to migrate to AuraSkills/userdata");
        try {
            int migrated = 0;
            for (File playerDataFile : files) {
                if (!playerDataFile.getName().endsWith(".yml")) continue;
                File userFile = new File(userDataDir, playerDataFile.getName());
                Files.createDirectories(userFile.getParentFile().toPath(), new FileAttribute[0]);
                Files.copy(playerDataFile.toPath(), userFile.toPath(), new CopyOption[0]);
                if (!userFile.exists()) continue;
                ConfigurationNode config = FileUtil.loadYamlFile(userFile);
                this.applyFormatChanges(config);
                FileUtil.saveYamlFile(userFile, config);
                ++migrated;
            }
            this.plugin.logger().warn("[Migrator] Migrated " + migrated + " files from AureliumSkills/playerdata to AuraSkills/userdata");
        }
        catch (IOException e) {
            this.plugin.logger().severe("[Migrator] Failed to migrate files from AureliumSkills/playerdata to AuraSkills/userdata: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void applyFormatChanges(ConfigurationNode config) throws SerializationException {
        String PLUGIN_NAME = "auraskills";
        ConfigurationNode skillsNode = config.node("skills");
        for (ConfigurationNode configurationNode : skillsNode.childrenMap().values()) {
            String string = (String)configurationNode.key();
            if (string == null) continue;
            skillsNode.node("auraskills/" + string).set(configurationNode.raw());
            skillsNode.removeChild(string);
        }
        ConfigurationNode statModifiersNode = config.node("stat_modifiers");
        for (ConfigurationNode configurationNode : statModifiersNode.childrenMap().values()) {
            String string = configurationNode.node("stat").getString();
            configurationNode.node("stat").set("auraskills/" + string);
        }
        ConfigurationNode configurationNode = config.node("ability_data");
        for (ConfigurationNode configurationNode2 : configurationNode.childrenMap().values()) {
            String oldKey = (String)configurationNode2.key();
            if (oldKey == null) continue;
            configurationNode.node("auraskills/" + oldKey).set(configurationNode2.raw());
            configurationNode.removeChild(oldKey);
        }
    }
}

