/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.migration;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.preset.ConfigPreset;
import dev.aurelium.auraskills.common.config.preset.PresetLoadException;
import dev.aurelium.auraskills.common.config.preset.PresetLoadResult;
import dev.aurelium.auraskills.common.util.data.Pair;
import dev.aurelium.auraskills.common.util.file.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.spongepowered.configurate.ConfigurationNode;

public class ConfigMigrator {
    private final AuraSkillsPlugin plugin;

    public ConfigMigrator(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    public void migrate() {
        try {
            this.applyLegacyPreset();
            ConfigurationNode migrationPaths = FileUtil.loadEmbeddedYamlFile("migration_paths.yml", this.plugin);
            Map<Pair<File, File>, List<Pair<String, String>>> paths = this.loadFilesAndPaths(migrationPaths);
            for (Map.Entry<Pair<File, File>, List<Pair<String, String>>> entry : paths.entrySet()) {
                File oldFile = entry.getKey().first();
                File newFile = entry.getKey().second();
                this.migrateFile(entry.getValue(), oldFile, newFile);
            }
            this.migrateLootAndRewards();
            this.setMigrationDefaults();
        }
        catch (Exception e) {
            this.plugin.logger().severe("[Migrator] Error while migrating configs, please report this to the plugin Discord!");
            e.printStackTrace();
        }
    }

    public void migrateFile(List<Pair<String, String>> paths, File oldFile, File newFile) {
        try {
            ConfigurationNode fromNode = FileUtil.loadYamlFile(oldFile);
            ConfigurationNode toNode = FileUtil.loadYamlFile(newFile);
            for (Pair<String, String> path : paths) {
                Object[] fromPath = this.toPathArray(path.first());
                Object[] toPath = this.toPathArray(path.second());
                if (fromNode.node(fromPath).virtual() || toNode.node(toPath).virtual()) continue;
                toNode.node(toPath).set(fromNode.node(fromPath).raw());
            }
            FileUtil.saveYamlFile(newFile, toNode);
            Path pluginPath = this.plugin.getPluginFolder().toPath();
            this.plugin.logger().info("[Migrator] Migrated config values from " + oldFile.getName() + " to " + pluginPath.relativize(newFile.toPath()));
        }
        catch (Exception e) {
            this.plugin.logger().severe("[Migrator] Error while migrating from " + oldFile.getPath() + " to " + newFile.getPath());
            e.printStackTrace();
        }
    }

    public Map<Pair<File, File>, List<Pair<String, String>>> loadFilesAndPaths(ConfigurationNode config) {
        LinkedHashMap<Pair<File, File>, List<Pair<String, String>>> pathMap = new LinkedHashMap<Pair<File, File>, List<Pair<String, String>>>();
        for (Map.Entry<Object, ? extends ConfigurationNode> entry : config.childrenMap().entrySet()) {
            String oldFileName = (String)entry.getKey();
            File oldFile = new File(this.plugin.getPluginFolder().getParentFile(), "AureliumSkills/" + oldFileName);
            if (!oldFile.exists()) continue;
            ConfigurationNode oldFileNode = entry.getValue();
            for (Map.Entry<Object, ? extends ConfigurationNode> childEntry : oldFileNode.childrenMap().entrySet()) {
                String newFileName = (String)childEntry.getKey();
                File newFile = new File(this.plugin.getPluginFolder(), newFileName);
                if (!newFile.exists()) continue;
                pathMap.put(new Pair<File, File>(oldFile, newFile), this.loadMigrationPaths(childEntry.getValue()));
            }
        }
        this.loadAbilitiesConfigMigrationPaths(pathMap);
        this.loadSourcesConfigMigrationPaths(pathMap);
        return pathMap;
    }

    private void applyLegacyPreset() {
        try {
            ConfigPreset preset = this.plugin.getPresetManager().preparePreset("legacy.zip");
            PresetLoadResult result = this.plugin.getPresetManager().loadPreset(preset);
            int affected = result.created().size() + result.modified().size() + result.replaced().size() + result.deleted().size();
            this.plugin.logger().warn("[Migrator] Applied legacy.zip config preset for 15 skills, " + affected + " files affected");
        }
        catch (PresetLoadException | IOException e) {
            this.plugin.logger().warn("[Migrator] Failed to apply legacy preset");
            e.printStackTrace();
        }
    }

    private List<Pair<String, String>> loadMigrationPaths(ConfigurationNode config) {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        for (Map.Entry<Object, ? extends ConfigurationNode> entry : config.childrenMap().entrySet()) {
            String fromPath = (String)entry.getKey();
            if (entry.getValue().isList()) {
                for (ConfigurationNode configurationNode : entry.getValue().childrenList()) {
                    String toPath = configurationNode.getString();
                    list.add(new Pair<String, String>(fromPath, toPath));
                }
                continue;
            }
            String toPath = entry.getValue().getString();
            if (toPath == null) continue;
            if (toPath.isEmpty()) {
                list.add(new Pair<String, String>(fromPath, fromPath));
                continue;
            }
            if (toPath.equals("_")) {
                list.add(new Pair<String, String>(fromPath, fromPath.replace("-", "_")));
                continue;
            }
            list.add(new Pair<String, String>(fromPath, toPath));
        }
        return list;
    }

    private void loadAbilitiesConfigMigrationPaths(Map<Pair<File, File>, List<Pair<String, String>>> pathMap) {
        String nPath;
        String oPath;
        File legacyFile = new File(this.plugin.getPluginFolder().getParentFile(), "AureliumSkills/abilities_config.yml");
        File abilitiesFile = new File(this.plugin.getPluginFolder(), "abilities.yml");
        File manaAbilitiesFile = new File(this.plugin.getPluginFolder(), "mana_abilities.yml");
        ArrayList<Pair<Object, Object>> abList = new ArrayList<Pair<Object, Object>>();
        for (Abilities ability : Abilities.values()) {
            String skillName = ability.getLegacySkillName().toLowerCase(Locale.ROOT);
            String abilityName = ability.getId().getKey().toLowerCase(Locale.ROOT);
            oPath = "abilities." + skillName + "." + abilityName + ".";
            nPath = "abilities.auraskills/" + abilityName + ".";
            abList.add(this.genPair(oPath, nPath, "enabled"));
            abList.add(new Pair<CallSite, CallSite>((CallSite)((Object)(oPath + "base")), (CallSite)((Object)(nPath + "base_value"))));
            abList.add(new Pair<CallSite, CallSite>((CallSite)((Object)(oPath + "per_level")), (CallSite)((Object)(nPath + "value_per_level"))));
            abList.add(this.genPair(oPath, nPath, "unlock"));
            abList.add(this.genPair(oPath, nPath, "level_up"));
            abList.add(this.genPair(oPath, nPath, "max_level"));
            abList.add(new Pair<CallSite, CallSite>((CallSite)((Object)(oPath + "base_2")), (CallSite)((Object)(nPath + "secondary_base_value"))));
            abList.add(new Pair<CallSite, CallSite>((CallSite)((Object)(oPath + "per_level_2")), (CallSite)((Object)(nPath + "secondary_value_per_level"))));
            abList.add(this.genPair(oPath, nPath, "enable_message"));
            abList.add(this.genPair(oPath, nPath, "health_percent_required"));
            abList.add(this.genPair(oPath, nPath, "cooldown_ticks"));
            abList.add(this.genPair(oPath, nPath, "scale_base_chance"));
            if (ability != Abilities.BLEED) continue;
            abList.add(this.genPair(oPath, nPath, "enable_enemy_message"));
            abList.add(this.genPair(oPath, nPath, "enable_self_message"));
            abList.add(this.genPair(oPath, nPath, "enable_stop_message"));
            abList.add(this.genPair(oPath, nPath, "base_ticks"));
            abList.add(this.genPair(oPath, nPath, "added_ticks"));
            abList.add(this.genPair(oPath, nPath, "max_ticks"));
            abList.add(this.genPair(oPath, nPath, "tick_period"));
            abList.add(this.genPair(oPath, nPath, "show_particles"));
        }
        pathMap.put(new Pair<File, File>(legacyFile, abilitiesFile), abList);
        ArrayList<Pair<Object, Object>> maList = new ArrayList<Pair<Object, Object>>();
        for (ManaAbilities manaAbility : ManaAbilities.values()) {
            String manaAbilityName = manaAbility.getId().getKey().toLowerCase(Locale.ROOT);
            oPath = "mana_abilities." + manaAbilityName + ".";
            nPath = "mana_abilities.auraskills/" + manaAbilityName + ".";
            maList.add(this.genPair(oPath, nPath, "enabled"));
            maList.add(this.genPair(oPath, nPath, "base_value"));
            maList.add(this.genPair(oPath, nPath, "value_per_level"));
            maList.add(new Pair<CallSite, CallSite>((CallSite)((Object)(oPath + "cooldown")), (CallSite)((Object)(nPath + "base_cooldown"))));
            maList.add(this.genPair(oPath, nPath, "cooldown_per_level"));
            maList.add(new Pair<CallSite, CallSite>((CallSite)((Object)(oPath + "mana_cost")), (CallSite)((Object)(nPath + "base_mana_cost"))));
            maList.add(this.genPair(oPath, nPath, "mana_cost_per_level"));
            maList.add(this.genPair(oPath, nPath, "unlock"));
            maList.add(this.genPair(oPath, nPath, "level_up"));
            maList.add(this.genPair(oPath, nPath, "max_level"));
            maList.add(this.genPair(oPath, nPath, "require_sneak"));
            maList.add(this.genPair(oPath, nPath, "check_offhand"));
            maList.add(this.genPair(oPath, nPath, "sneak_offhand_bypass"));
            maList.add(this.genPair(oPath, nPath, "replant_delay"));
            maList.add(this.genPair(oPath, nPath, "show_particles"));
            maList.add(this.genPair(oPath, nPath, "prevent_unripe_break"));
            maList.add(this.genPair(oPath, nPath, "max_blocks_multipliers"));
            maList.add(this.genPair(oPath, nPath, "haste_level"));
            maList.add(this.genPair(oPath, nPath, "display_damage_with_scaling"));
            maList.add(this.genPair(oPath, nPath, "enable_sound"));
            maList.add(this.genPair(oPath, nPath, "disable_health_check"));
            maList.add(this.genPair(oPath, nPath, "max_blocks"));
            maList.add(this.genPair(oPath, nPath, "enable_message"));
            maList.add(this.genPair(oPath, nPath, "enable_particles"));
        }
        pathMap.put(new Pair<File, File>(legacyFile, manaAbilitiesFile), maList);
    }

    private void loadSourcesConfigMigrationPaths(Map<Pair<File, File>, List<Pair<String, String>>> pathMap) {
        File legacyFile = new File(this.plugin.getPluginFolder().getParentFile(), "AureliumSkills/sources_config.yml");
        try {
            ConfigurationNode sConfig = FileUtil.loadYamlFile(legacyFile);
            for (Skills skill : Skills.values()) {
                if (skill == Skills.ENCHANTING) {
                    return;
                }
                ArrayList<Pair<CallSite, CallSite>> paths = new ArrayList<Pair<CallSite, CallSite>>();
                String skillName = skill.getId().getKey().toLowerCase(Locale.ROOT);
                File newFile = new File(this.plugin.getPluginFolder(), "sources/" + skillName + ".yml");
                for (Object key : sConfig.node("sources", skillName).childrenMap().keySet()) {
                    String sourceName = (String)key;
                    String oPath = "sources." + skillName + "." + sourceName;
                    String nPath = "sources." + sourceName + ".xp";
                    paths.add(new Pair<CallSite, CallSite>((CallSite)((Object)oPath), (CallSite)((Object)nPath)));
                }
                pathMap.put(new Pair<File, File>(legacyFile, newFile), paths);
            }
        }
        catch (IOException e) {
            this.plugin.logger().severe("[Migrator] Error loading sources config migration paths");
            e.printStackTrace();
        }
    }

    private void migrateLootAndRewards() {
        File oldPluginDir = new File(this.plugin.getPluginFolder().getParentFile(), "AureliumSkills");
        this.copyDirectory(new File(oldPluginDir, "loot"), new File(this.plugin.getPluginFolder(), "loot"));
        this.plugin.logger().info("[Migrator] Copied contents of AureliumSkills/loot directory to AuraSkills/loot");
        this.copyDirectory(new File(oldPluginDir, "rewards"), new File(this.plugin.getPluginFolder(), "rewards"));
        this.plugin.logger().info("[Migrator] Copied contents of AureliumSkills/rewards directory to AuraSkills/rewards");
    }

    private void setMigrationDefaults() throws IOException {
        File file = new File(this.plugin.getPluginFolder(), "config.yml");
        ConfigurationNode config = FileUtil.loadYamlFile(file);
        config.node("start_level").set(1);
        FileUtil.saveYamlFile(file, config);
    }

    private void copyDirectory(File sourceDir, File destDir) {
        try {
            File[] files;
            Path sourcePath = sourceDir.toPath();
            Path destinationPath = destDir.toPath();
            if (!destinationPath.toFile().exists()) {
                Files.copy(sourcePath, destinationPath, new CopyOption[0]);
            }
            if ((files = sourceDir.listFiles()) != null) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    Path filePath = file.toPath();
                    Path destFilePath = destinationPath.resolve(file.getName());
                    Files.copy(filePath, destFilePath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Pair<String, String> genPair(String legacyPath, String newPath, String append) {
        return new Pair<CallSite, CallSite>((CallSite)((Object)(legacyPath + append)), (CallSite)((Object)(newPath + append)));
    }

    private String[] toPathArray(String path) {
        return path.split("\\.");
    }
}

