/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.message;

import com.archyx.polyglot.Polyglot;
import com.archyx.polyglot.PolyglotProvider;
import com.archyx.polyglot.config.MessageReplacements;
import com.archyx.polyglot.config.PolyglotConfig;
import com.archyx.polyglot.config.PolyglotConfigBuilder;
import com.archyx.polyglot.lang.LangMessages;
import com.archyx.polyglot.lang.MessageManager;
import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.message.LocalizedKey;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.type.UnitMessage;
import dev.aurelium.auraskills.kyori.adventure.text.Component;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class MessageProvider
implements PolyglotProvider {
    private final AuraSkillsPlugin plugin;
    protected final Polyglot polyglot;
    protected final MessageManager manager;
    @Nullable
    private Locale defaultLanguage;
    private final Map<LocalizedKey, Component> componentCache = new HashMap<LocalizedKey, Component>();

    public MessageProvider(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{mana_unit}", UnitMessage.MANA.getPath());
        replace.put("{xp_unit}", UnitMessage.XP.getPath());
        replace.put("{hp_unit}", UnitMessage.HP.getPath());
        PolyglotConfig config = new PolyglotConfigBuilder().messageDirectory("messages").messageFileName("messages_{language}.yml").defaultLanguage("en").providedLanguages(new String[]{"global", "en", "fr", "de", "es", "zh-CN", "zh-TW", "pt-BR", "it", "cs", "pl", "uk", "ko", "nl", "ja", "ru", "id", "vi", "tr", "fi", "th"}).messageReplacements(new MessageReplacements(replace)).build();
        this.polyglot = new Polyglot(this, config);
        this.manager = this.polyglot.getMessageManager();
        this.defaultLanguage = null;
    }

    public abstract String applyFormatting(String var1);

    public abstract String componentToString(Component var1);

    public abstract Component stringToComponent(String var1);

    public void loadMessages() {
        this.clearComponentCache();
        this.polyglot.getMessageManager().loadMessages();
    }

    public String get(MessageKey key, Locale locale) {
        LocalizedKey localizedKey = new LocalizedKey(key, locale);
        Component cached = this.componentCache.get(localizedKey);
        if (cached != null) {
            return this.componentToString(cached);
        }
        String message = this.manager.get(locale, this.convertKey(key));
        Component converted = this.stringToComponent(message);
        this.componentCache.put(localizedKey, converted);
        return this.componentToString(converted);
    }

    public String getRaw(MessageKey key, Locale locale) {
        return this.manager.get(locale, this.convertKey(key));
    }

    public String getSkillDisplayName(Skill skill, Locale locale, boolean formatted) {
        if (formatted) {
            return this.get(this.getSkillDisplayNameKey(skill), locale);
        }
        return this.getRaw(this.getSkillDisplayNameKey(skill), locale);
    }

    private MessageKey getSkillDisplayNameKey(Skill skill) {
        String key = skill instanceof Skills ? skill.getId().getKey() : skill.getId().toString();
        return MessageKey.of("skills." + key + ".name");
    }

    public String getSkillDescription(Skill skill, Locale locale, boolean formatted) {
        if (formatted) {
            return this.get(this.getSkillDescriptionKey(skill), locale);
        }
        return this.getRaw(this.getSkillDescriptionKey(skill), locale);
    }

    private MessageKey getSkillDescriptionKey(Skill skill) {
        String key = skill instanceof Skills ? skill.getId().getKey() : skill.getId().toString();
        return MessageKey.of("skills." + key + ".desc");
    }

    public String getStatDisplayName(Stat stat, Locale locale, boolean formatted) {
        if (formatted) {
            return this.get(this.getStatDisplayNameKey(stat), locale);
        }
        return this.getRaw(this.getStatDisplayNameKey(stat), locale);
    }

    public MessageKey getStatDisplayNameKey(Stat stat) {
        String key = stat instanceof Stats ? stat.getId().getKey() : stat.getId().toString();
        return MessageKey.of("stats." + key + ".name");
    }

    public String getStatDescription(Stat stat, Locale locale, boolean formatted) {
        if (formatted) {
            return this.get(this.getStatDescriptionKey(stat), locale);
        }
        return this.getRaw(this.getStatDescriptionKey(stat), locale);
    }

    public MessageKey getStatDescriptionKey(Stat stat) {
        String key = stat instanceof Stats ? stat.getId().getKey() : stat.getId().toString();
        return MessageKey.of("stats." + key + ".desc");
    }

    public String getStatColor(Stat stat, Locale locale) {
        String key = stat instanceof Stats ? stat.getId().getKey() : stat.getId().toString();
        return this.getRaw(MessageKey.of("stats." + key + ".color"), locale);
    }

    public String getStatSymbol(Stat stat, Locale locale) {
        String key = stat instanceof Stats ? stat.getId().getKey() : stat.getId().toString();
        return this.getRaw(MessageKey.of("stats." + key + ".symbol"), locale);
    }

    public String getAbilityDisplayName(Ability ability, Locale locale, boolean formatted) {
        String key = ability instanceof Abilities ? ability.getId().getKey() : ability.getId().toString();
        MessageKey msgKey = MessageKey.of("abilities." + key + ".name");
        if (formatted) {
            return this.get(msgKey, locale);
        }
        return this.getRaw(msgKey, locale);
    }

    public String getAbilityDescription(Ability ability, Locale locale, boolean formatted) {
        String key = ability instanceof Abilities ? ability.getId().getKey() : ability.getId().toString();
        MessageKey msgKey = MessageKey.of("abilities." + key + ".desc");
        if (formatted) {
            return this.get(msgKey, locale);
        }
        return this.getRaw(msgKey, locale);
    }

    public String getAbilityInfo(Ability ability, Locale locale, boolean formatted) {
        String key = ability instanceof Abilities ? ability.getId().getKey() : ability.getId().toString();
        MessageKey msgKey = MessageKey.of("abilities." + key + ".info");
        if (formatted) {
            return this.get(msgKey, locale);
        }
        return this.getRaw(msgKey, locale);
    }

    public String getManaAbilityDisplayName(ManaAbility ability, Locale locale, boolean formatted) {
        String key = ability instanceof ManaAbilities ? ability.getId().getKey() : ability.getId().toString();
        MessageKey msgKey = MessageKey.of("mana_abilities." + key + ".name");
        if (formatted) {
            return this.get(msgKey, locale);
        }
        return this.getRaw(msgKey, locale);
    }

    public String getManaAbilityDescription(ManaAbility ability, Locale locale, boolean formatted) {
        String key = ability instanceof ManaAbilities ? ability.getId().getKey() : ability.getId().toString();
        MessageKey msgKey = MessageKey.of("mana_abilities." + key + ".desc");
        if (formatted) {
            return this.get(msgKey, locale);
        }
        return this.getRaw(msgKey, locale);
    }

    public String getTraitDisplayName(Trait trait, Locale locale, boolean formatted) {
        String key = trait instanceof Traits ? trait.getId().getKey() : trait.getId().toString();
        MessageKey msgKey = MessageKey.of("traits." + key + ".name");
        if (formatted) {
            return this.get(msgKey, locale);
        }
        return this.getRaw(msgKey, locale);
    }

    public void loadDefaultLanguageOption() {
        Locale locale = new Locale(this.plugin.configString(Option.DEFAULT_LANGUAGE));
        this.defaultLanguage = this.manager.getLoadedLanguages().contains(locale) ? locale : this.manager.getDefaultLanguage();
    }

    public Locale getDefaultLanguage() {
        if (this.defaultLanguage == null) {
            this.loadDefaultLanguageOption();
        }
        return this.defaultLanguage;
    }

    private com.archyx.polyglot.lang.MessageKey convertKey(MessageKey key) {
        return com.archyx.polyglot.lang.MessageKey.of(key.getPath());
    }

    private void clearComponentCache() {
        this.componentCache.clear();
    }

    @Override
    public InputStream getResource(String path) {
        return this.plugin.getResource(path);
    }

    @Override
    public void saveResource(String path, boolean replace) {
        this.plugin.saveResource(path, replace);
    }

    @Override
    public File getDataFolder() {
        return this.plugin.getPluginFolder();
    }

    public boolean hasLocale(Locale locale) {
        return this.manager.getLoadedLanguages().contains(locale);
    }

    public Set<Locale> getLoadedLanguages() {
        return this.manager.getLoadedLanguages();
    }

    public List<String> getLanguageCodes() {
        return this.manager.getLanguageCodes();
    }

    public String getLanguageCode(Locale locale) {
        LangMessages messages = this.manager.getLangMessages(locale);
        if (messages != null) {
            return messages.getLanguageCode();
        }
        return locale.toLanguageTag();
    }

    @Override
    public void logInfo(String message) {
        this.plugin.logger().info(message);
    }

    @Override
    public void logWarn(String message) {
        this.plugin.logger().warn(message);
    }

    @Override
    public void logSevere(String message) {
        this.plugin.logger().severe(message);
    }
}

